/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that specifies the type of resource associations that should be retrieved for a custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesAssociatedToCustomLineItemFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListResourcesAssociatedToCustomLineItemFilter.Builder, ListResourcesAssociatedToCustomLineItemFilter> {
    private static final SdkField<String> RELATIONSHIP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Relationship").getter(getter(ListResourcesAssociatedToCustomLineItemFilter::relationshipAsString))
            .setter(setter(Builder::relationship))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relationship").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONSHIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relationship;

    private ListResourcesAssociatedToCustomLineItemFilter(BuilderImpl builder) {
        this.relationship = builder.relationship;
    }

    /**
     * <p>
     * The type of relationship between the custom line item and the associated resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationship} will
     * return {@link CustomLineItemRelationship#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #relationshipAsString}.
     * </p>
     * 
     * @return The type of relationship between the custom line item and the associated resource.
     * @see CustomLineItemRelationship
     */
    public final CustomLineItemRelationship relationship() {
        return CustomLineItemRelationship.fromValue(relationship);
    }

    /**
     * <p>
     * The type of relationship between the custom line item and the associated resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationship} will
     * return {@link CustomLineItemRelationship#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #relationshipAsString}.
     * </p>
     * 
     * @return The type of relationship between the custom line item and the associated resource.
     * @see CustomLineItemRelationship
     */
    public final String relationshipAsString() {
        return relationship;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationshipAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesAssociatedToCustomLineItemFilter)) {
            return false;
        }
        ListResourcesAssociatedToCustomLineItemFilter other = (ListResourcesAssociatedToCustomLineItemFilter) obj;
        return Objects.equals(relationshipAsString(), other.relationshipAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourcesAssociatedToCustomLineItemFilter").add("Relationship", relationshipAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Relationship":
            return Optional.ofNullable(clazz.cast(relationshipAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Relationship", RELATIONSHIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesAssociatedToCustomLineItemFilter, T> g) {
        return obj -> g.apply((ListResourcesAssociatedToCustomLineItemFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemFilter> {
        /**
         * <p>
         * The type of relationship between the custom line item and the associated resource.
         * </p>
         * 
         * @param relationship
         *        The type of relationship between the custom line item and the associated resource.
         * @see CustomLineItemRelationship
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomLineItemRelationship
         */
        Builder relationship(String relationship);

        /**
         * <p>
         * The type of relationship between the custom line item and the associated resource.
         * </p>
         * 
         * @param relationship
         *        The type of relationship between the custom line item and the associated resource.
         * @see CustomLineItemRelationship
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomLineItemRelationship
         */
        Builder relationship(CustomLineItemRelationship relationship);
    }

    static final class BuilderImpl implements Builder {
        private String relationship;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesAssociatedToCustomLineItemFilter model) {
            relationship(model.relationship);
        }

        public final String getRelationship() {
            return relationship;
        }

        public final void setRelationship(String relationship) {
            this.relationship = relationship;
        }

        @Override
        public final Builder relationship(String relationship) {
            this.relationship = relationship;
            return this;
        }

        @Override
        public final Builder relationship(CustomLineItemRelationship relationship) {
            this.relationship(relationship == null ? null : relationship.toString());
            return this;
        }

        @Override
        public ListResourcesAssociatedToCustomLineItemFilter build() {
            return new ListResourcesAssociatedToCustomLineItemFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
