/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePricingRuleRequest extends BillingconductorRequest implements
        ToCopyableBuilder<UpdatePricingRuleRequest.Builder, UpdatePricingRuleRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdatePricingRuleRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdatePricingRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePricingRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdatePricingRuleRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ModifierPercentage").getter(getter(UpdatePricingRuleRequest::modifierPercentage))
            .setter(setter(Builder::modifierPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build())
            .build();

    private static final SdkField<UpdateTieringInput> TIERING_FIELD = SdkField
            .<UpdateTieringInput> builder(MarshallingType.SDK_POJO).memberName("Tiering")
            .getter(getter(UpdatePricingRuleRequest::tiering)).setter(setter(Builder::tiering))
            .constructor(UpdateTieringInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tiering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, TIERING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String description;

    private final String type;

    private final Double modifierPercentage;

    private final UpdateTieringInput tiering;

    private UpdatePricingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.tiering = builder.tiering;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pricing rule to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pricing rule to update.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The new name of the pricing rule. The name must be unique to each pricing rule.
     * </p>
     * 
     * @return The new name of the pricing rule. The name must be unique to each pricing rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new description for the pricing rule.
     * </p>
     * 
     * @return The new description for the pricing rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new pricing rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The new pricing rule type.
     * @see PricingRuleType
     */
    public final PricingRuleType type() {
        return PricingRuleType.fromValue(type);
    }

    /**
     * <p>
     * The new pricing rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The new pricing rule type.
     * @see PricingRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The new modifier to show pricing plan rates as a percentage.
     * </p>
     * 
     * @return The new modifier to show pricing plan rates as a percentage.
     */
    public final Double modifierPercentage() {
        return modifierPercentage;
    }

    /**
     * <p>
     * The set of tiering configurations for the pricing rule.
     * </p>
     * 
     * @return The set of tiering configurations for the pricing rule.
     */
    public final UpdateTieringInput tiering() {
        return tiering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(tiering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePricingRuleRequest)) {
            return false;
        }
        UpdatePricingRuleRequest other = (UpdatePricingRuleRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(modifierPercentage(), other.modifierPercentage()) && Objects.equals(tiering(), other.tiering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePricingRuleRequest").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("ModifierPercentage", modifierPercentage()).add("Tiering", tiering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ModifierPercentage":
            return Optional.ofNullable(clazz.cast(modifierPercentage()));
        case "Tiering":
            return Optional.ofNullable(clazz.cast(tiering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ModifierPercentage", MODIFIER_PERCENTAGE_FIELD);
        map.put("Tiering", TIERING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePricingRuleRequest, T> g) {
        return obj -> g.apply((UpdatePricingRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePricingRuleRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pricing rule to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the pricing rule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The new name of the pricing rule. The name must be unique to each pricing rule.
         * </p>
         * 
         * @param name
         *        The new name of the pricing rule. The name must be unique to each pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new description for the pricing rule.
         * </p>
         * 
         * @param description
         *        The new description for the pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new pricing rule type.
         * </p>
         * 
         * @param type
         *        The new pricing rule type.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The new pricing rule type.
         * </p>
         * 
         * @param type
         *        The new pricing rule type.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(PricingRuleType type);

        /**
         * <p>
         * The new modifier to show pricing plan rates as a percentage.
         * </p>
         * 
         * @param modifierPercentage
         *        The new modifier to show pricing plan rates as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifierPercentage(Double modifierPercentage);

        /**
         * <p>
         * The set of tiering configurations for the pricing rule.
         * </p>
         * 
         * @param tiering
         *        The set of tiering configurations for the pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tiering(UpdateTieringInput tiering);

        /**
         * <p>
         * The set of tiering configurations for the pricing rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateTieringInput.Builder} avoiding the
         * need to create one manually via {@link UpdateTieringInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateTieringInput.Builder#build()} is called immediately and its
         * result is passed to {@link #tiering(UpdateTieringInput)}.
         * 
         * @param tiering
         *        a consumer that will call methods on {@link UpdateTieringInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tiering(UpdateTieringInput)
         */
        default Builder tiering(Consumer<UpdateTieringInput.Builder> tiering) {
            return tiering(UpdateTieringInput.builder().applyMutation(tiering).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String type;

        private Double modifierPercentage;

        private UpdateTieringInput tiering;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePricingRuleRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            type(model.type);
            modifierPercentage(model.modifierPercentage);
            tiering(model.tiering);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final UpdateTieringInput.Builder getTiering() {
            return tiering != null ? tiering.toBuilder() : null;
        }

        public final void setTiering(UpdateTieringInput.BuilderImpl tiering) {
            this.tiering = tiering != null ? tiering.build() : null;
        }

        @Override
        public final Builder tiering(UpdateTieringInput tiering) {
            this.tiering = tiering;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePricingRuleRequest build() {
            return new UpdatePricingRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
