/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePricingRuleResponse extends BillingconductorResponse implements
        ToCopyableBuilder<UpdatePricingRuleResponse.Builder, UpdatePricingRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdatePricingRuleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdatePricingRuleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePricingRuleResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(UpdatePricingRuleResponse::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdatePricingRuleResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ModifierPercentage").getter(getter(UpdatePricingRuleResponse::modifierPercentage))
            .setter(setter(Builder::modifierPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build())
            .build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(UpdatePricingRuleResponse::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<Long> ASSOCIATED_PRICING_PLAN_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AssociatedPricingPlanCount")
            .getter(getter(UpdatePricingRuleResponse::associatedPricingPlanCount))
            .setter(setter(Builder::associatedPricingPlanCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedPricingPlanCount").build())
            .build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(UpdatePricingRuleResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> BILLING_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingEntity").getter(getter(UpdatePricingRuleResponse::billingEntity))
            .setter(setter(Builder::billingEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingEntity").build()).build();

    private static final SdkField<UpdateTieringInput> TIERING_FIELD = SdkField
            .<UpdateTieringInput> builder(MarshallingType.SDK_POJO).memberName("Tiering")
            .getter(getter(UpdatePricingRuleResponse::tiering)).setter(setter(Builder::tiering))
            .constructor(UpdateTieringInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tiering").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageType").getter(getter(UpdatePricingRuleResponse::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(UpdatePricingRuleResponse::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SCOPE_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, SERVICE_FIELD,
            ASSOCIATED_PRICING_PLAN_COUNT_FIELD, LAST_MODIFIED_TIME_FIELD, BILLING_ENTITY_FIELD, TIERING_FIELD, USAGE_TYPE_FIELD,
            OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String description;

    private final String scope;

    private final String type;

    private final Double modifierPercentage;

    private final String service;

    private final Long associatedPricingPlanCount;

    private final Long lastModifiedTime;

    private final String billingEntity;

    private final UpdateTieringInput tiering;

    private final String usageType;

    private final String operation;

    private UpdatePricingRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.scope = builder.scope;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.service = builder.service;
        this.associatedPricingPlanCount = builder.associatedPricingPlanCount;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.billingEntity = builder.billingEntity;
        this.tiering = builder.tiering;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the successfully updated pricing rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the successfully updated pricing rule.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The new name of the pricing rule. The name must be unique to each pricing rule.
     * </p>
     * 
     * @return The new name of the pricing rule. The name must be unique to each pricing rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new description for the pricing rule.
     * </p>
     * 
     * @return The new description for the pricing rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PricingRuleScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * @see PricingRuleScope
     */
    public final PricingRuleScope scope() {
        return PricingRuleScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PricingRuleScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * @see PricingRuleScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The new pricing rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The new pricing rule type.
     * @see PricingRuleType
     */
    public final PricingRuleType type() {
        return PricingRuleType.fromValue(type);
    }

    /**
     * <p>
     * The new pricing rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The new pricing rule type.
     * @see PricingRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The new modifier to show pricing plan rates as a percentage.
     * </p>
     * 
     * @return The new modifier to show pricing plan rates as a percentage.
     */
    public final Double modifierPercentage() {
        return modifierPercentage;
    }

    /**
     * <p>
     * If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the
     * <code>PricingRule</code> is applicable for.
     * </p>
     * 
     * @return If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service
     *         the <code>PricingRule</code> is applicable for.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The pricing plans count that this pricing rule is associated with.
     * </p>
     * 
     * @return The pricing plans count that this pricing rule is associated with.
     */
    public final Long associatedPricingPlanCount() {
        return associatedPricingPlanCount;
    }

    /**
     * <p>
     * The most recent time the pricing rule was modified.
     * </p>
     * 
     * @return The most recent time the pricing rule was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling
     * services via Amazon Web Services Marketplace.
     * </p>
     * 
     * @return The seller of services provided by Amazon Web Services, their affiliates, or third-party providers
     *         selling services via Amazon Web Services Marketplace.
     */
    public final String billingEntity() {
        return billingEntity;
    }

    /**
     * <p>
     * The set of tiering configurations for the pricing rule.
     * </p>
     * 
     * @return The set of tiering configurations for the pricing rule.
     */
    public final UpdateTieringInput tiering() {
        return tiering;
    }

    /**
     * <p>
     * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
     * </p>
     * <p>
     * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage type the
     * <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code> describes an
     * <code>M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
     * </p>
     * 
     * @return Usage type is the unit that each service uses to measure the usage of a specific type of resource.</p>
     *         <p>
     *         If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage type
     *         the <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code> describes
     *         an <code>M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * Operation refers to the specific Amazon Web Services covered by this line item. This describes the specific usage
     * of the line item.
     * </p>
     * <p>
     * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which operation the
     * <code>PricingRule</code> is modifying. For example, a value of <code>RunInstances:0202</code> indicates the
     * operation of running an Amazon EC2 instance.
     * </p>
     * 
     * @return Operation refers to the specific Amazon Web Services covered by this line item. This describes the
     *         specific usage of the line item.</p>
     *         <p>
     *         If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which operation
     *         the <code>PricingRule</code> is modifying. For example, a value of <code>RunInstances:0202</code>
     *         indicates the operation of running an Amazon EC2 instance.
     */
    public final String operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(associatedPricingPlanCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(billingEntity());
        hashCode = 31 * hashCode + Objects.hashCode(tiering());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePricingRuleResponse)) {
            return false;
        }
        UpdatePricingRuleResponse other = (UpdatePricingRuleResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(modifierPercentage(), other.modifierPercentage()) && Objects.equals(service(), other.service())
                && Objects.equals(associatedPricingPlanCount(), other.associatedPricingPlanCount())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(billingEntity(), other.billingEntity()) && Objects.equals(tiering(), other.tiering())
                && Objects.equals(usageType(), other.usageType()) && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePricingRuleResponse").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Scope", scopeAsString()).add("Type", typeAsString()).add("ModifierPercentage", modifierPercentage())
                .add("Service", service()).add("AssociatedPricingPlanCount", associatedPricingPlanCount())
                .add("LastModifiedTime", lastModifiedTime()).add("BillingEntity", billingEntity()).add("Tiering", tiering())
                .add("UsageType", usageType()).add("Operation", operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ModifierPercentage":
            return Optional.ofNullable(clazz.cast(modifierPercentage()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "AssociatedPricingPlanCount":
            return Optional.ofNullable(clazz.cast(associatedPricingPlanCount()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "BillingEntity":
            return Optional.ofNullable(clazz.cast(billingEntity()));
        case "Tiering":
            return Optional.ofNullable(clazz.cast(tiering()));
        case "UsageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ModifierPercentage", MODIFIER_PERCENTAGE_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("AssociatedPricingPlanCount", ASSOCIATED_PRICING_PLAN_COUNT_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("BillingEntity", BILLING_ENTITY_FIELD);
        map.put("Tiering", TIERING_FIELD);
        map.put("UsageType", USAGE_TYPE_FIELD);
        map.put("Operation", OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePricingRuleResponse, T> g) {
        return obj -> g.apply((UpdatePricingRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePricingRuleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the successfully updated pricing rule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the successfully updated pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The new name of the pricing rule. The name must be unique to each pricing rule.
         * </p>
         * 
         * @param name
         *        The new name of the pricing rule. The name must be unique to each pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new description for the pricing rule.
         * </p>
         * 
         * @param description
         *        The new description for the pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * </p>
         * 
         * @param scope
         *        The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * @see PricingRuleScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * </p>
         * 
         * @param scope
         *        The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * @see PricingRuleScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleScope
         */
        Builder scope(PricingRuleScope scope);

        /**
         * <p>
         * The new pricing rule type.
         * </p>
         * 
         * @param type
         *        The new pricing rule type.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The new pricing rule type.
         * </p>
         * 
         * @param type
         *        The new pricing rule type.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(PricingRuleType type);

        /**
         * <p>
         * The new modifier to show pricing plan rates as a percentage.
         * </p>
         * 
         * @param modifierPercentage
         *        The new modifier to show pricing plan rates as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifierPercentage(Double modifierPercentage);

        /**
         * <p>
         * If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which service the
         * <code>PricingRule</code> is applicable for.
         * </p>
         * 
         * @param service
         *        If the <code>Scope</code> attribute is set to <code>SERVICE</code>, the attribute indicates which
         *        service the <code>PricingRule</code> is applicable for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The pricing plans count that this pricing rule is associated with.
         * </p>
         * 
         * @param associatedPricingPlanCount
         *        The pricing plans count that this pricing rule is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPricingPlanCount(Long associatedPricingPlanCount);

        /**
         * <p>
         * The most recent time the pricing rule was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time the pricing rule was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling
         * services via Amazon Web Services Marketplace.
         * </p>
         * 
         * @param billingEntity
         *        The seller of services provided by Amazon Web Services, their affiliates, or third-party providers
         *        selling services via Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingEntity(String billingEntity);

        /**
         * <p>
         * The set of tiering configurations for the pricing rule.
         * </p>
         * 
         * @param tiering
         *        The set of tiering configurations for the pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tiering(UpdateTieringInput tiering);

        /**
         * <p>
         * The set of tiering configurations for the pricing rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateTieringInput.Builder} avoiding the
         * need to create one manually via {@link UpdateTieringInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateTieringInput.Builder#build()} is called immediately and its
         * result is passed to {@link #tiering(UpdateTieringInput)}.
         * 
         * @param tiering
         *        a consumer that will call methods on {@link UpdateTieringInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tiering(UpdateTieringInput)
         */
        default Builder tiering(Consumer<UpdateTieringInput.Builder> tiering) {
            return tiering(UpdateTieringInput.builder().applyMutation(tiering).build());
        }

        /**
         * <p>
         * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
         * </p>
         * <p>
         * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage type the
         * <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code> describes an
         * <code>M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
         * </p>
         * 
         * @param usageType
         *        Usage type is the unit that each service uses to measure the usage of a specific type of resource.</p>
         *        <p>
         *        If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage
         *        type the <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code>
         *        describes an <code>M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * Operation refers to the specific Amazon Web Services covered by this line item. This describes the specific
         * usage of the line item.
         * </p>
         * <p>
         * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which operation the
         * <code>PricingRule</code> is modifying. For example, a value of <code>RunInstances:0202</code> indicates the
         * operation of running an Amazon EC2 instance.
         * </p>
         * 
         * @param operation
         *        Operation refers to the specific Amazon Web Services covered by this line item. This describes the
         *        specific usage of the line item.</p>
         *        <p>
         *        If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which
         *        operation the <code>PricingRule</code> is modifying. For example, a value of
         *        <code>RunInstances:0202</code> indicates the operation of running an Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String scope;

        private String type;

        private Double modifierPercentage;

        private String service;

        private Long associatedPricingPlanCount;

        private Long lastModifiedTime;

        private String billingEntity;

        private UpdateTieringInput tiering;

        private String usageType;

        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePricingRuleResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            scope(model.scope);
            type(model.type);
            modifierPercentage(model.modifierPercentage);
            service(model.service);
            associatedPricingPlanCount(model.associatedPricingPlanCount);
            lastModifiedTime(model.lastModifiedTime);
            billingEntity(model.billingEntity);
            tiering(model.tiering);
            usageType(model.usageType);
            operation(model.operation);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PricingRuleScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Long getAssociatedPricingPlanCount() {
            return associatedPricingPlanCount;
        }

        public final void setAssociatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
        }

        @Override
        public final Builder associatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getBillingEntity() {
            return billingEntity;
        }

        public final void setBillingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
        }

        @Override
        public final Builder billingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
            return this;
        }

        public final UpdateTieringInput.Builder getTiering() {
            return tiering != null ? tiering.toBuilder() : null;
        }

        public final void setTiering(UpdateTieringInput.BuilderImpl tiering) {
            this.tiering = tiering != null ? tiering.build() : null;
        }

        @Override
        public final Builder tiering(UpdateTieringInput tiering) {
            this.tiering = tiering;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public UpdatePricingRuleResponse build() {
            return new UpdatePricingRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
