/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter that specifies the billing groups and pricing plans to retrieve billing group information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBillingGroupsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListBillingGroupsFilter.Builder, ListBillingGroupsFilter> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Arns")
            .getter(getter(ListBillingGroupsFilter::arns))
            .setter(setter(Builder::arns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(ListBillingGroupsFilter::pricingPlan)).setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Statuses")
            .getter(getter(ListBillingGroupsFilter::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_ASSOCIATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAssociate").getter(getter(ListBillingGroupsFilter::autoAssociate))
            .setter(setter(Builder::autoAssociate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssociate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD,
            PRICING_PLAN_FIELD, STATUSES_FIELD, AUTO_ASSOCIATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> arns;

    private final String pricingPlan;

    private final List<String> statuses;

    private final Boolean autoAssociate;

    private ListBillingGroupsFilter(BuilderImpl builder) {
        this.arns = builder.arns;
        this.pricingPlan = builder.pricingPlan;
        this.statuses = builder.statuses;
        this.autoAssociate = builder.autoAssociate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasArns() {
        return arns != null && !(arns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of billing group Amazon Resource Names (ARNs) to retrieve information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArns} method.
     * </p>
     * 
     * @return The list of billing group Amazon Resource Names (ARNs) to retrieve information.
     */
    public final List<String> arns() {
        return arns;
    }

    /**
     * <p>
     * The pricing plan Amazon Resource Names (ARNs) to retrieve information.
     * </p>
     * 
     * @return The pricing plan Amazon Resource Names (ARNs) to retrieve information.
     */
    public final String pricingPlan() {
        return pricingPlan;
    }

    /**
     * <p>
     * A list of billing groups to retrieve their current status for a specific time range
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return A list of billing groups to retrieve their current status for a specific time range
     */
    public final List<BillingGroupStatus> statuses() {
        return BillingGroupStatusListCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of billing groups to retrieve their current status for a specific time range
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return A list of billing groups to retrieve their current status for a specific time range
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * <p>
     * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that join
     * your consolidated billing family.
     * </p>
     * 
     * @return Specifies if this billing group will automatically associate newly added Amazon Web Services accounts
     *         that join your consolidated billing family.
     */
    public final Boolean autoAssociate() {
        return autoAssociate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasArns() ? arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoAssociate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsFilter)) {
            return false;
        }
        ListBillingGroupsFilter other = (ListBillingGroupsFilter) obj;
        return hasArns() == other.hasArns() && Objects.equals(arns(), other.arns())
                && Objects.equals(pricingPlan(), other.pricingPlan()) && hasStatuses() == other.hasStatuses()
                && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && Objects.equals(autoAssociate(), other.autoAssociate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBillingGroupsFilter").add("Arns", hasArns() ? arns() : null)
                .add("PricingPlan", pricingPlan()).add("Statuses", hasStatuses() ? statusesAsStrings() : null)
                .add("AutoAssociate", autoAssociate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arns":
            return Optional.ofNullable(clazz.cast(arns()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlan()));
        case "Statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "AutoAssociate":
            return Optional.ofNullable(clazz.cast(autoAssociate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arns", ARNS_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("Statuses", STATUSES_FIELD);
        map.put("AutoAssociate", AUTO_ASSOCIATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupsFilter, T> g) {
        return obj -> g.apply((ListBillingGroupsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListBillingGroupsFilter> {
        /**
         * <p>
         * The list of billing group Amazon Resource Names (ARNs) to retrieve information.
         * </p>
         * 
         * @param arns
         *        The list of billing group Amazon Resource Names (ARNs) to retrieve information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(Collection<String> arns);

        /**
         * <p>
         * The list of billing group Amazon Resource Names (ARNs) to retrieve information.
         * </p>
         * 
         * @param arns
         *        The list of billing group Amazon Resource Names (ARNs) to retrieve information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(String... arns);

        /**
         * <p>
         * The pricing plan Amazon Resource Names (ARNs) to retrieve information.
         * </p>
         * 
         * @param pricingPlan
         *        The pricing plan Amazon Resource Names (ARNs) to retrieve information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * A list of billing groups to retrieve their current status for a specific time range
         * </p>
         * 
         * @param statuses
         *        A list of billing groups to retrieve their current status for a specific time range
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * A list of billing groups to retrieve their current status for a specific time range
         * </p>
         * 
         * @param statuses
         *        A list of billing groups to retrieve their current status for a specific time range
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * A list of billing groups to retrieve their current status for a specific time range
         * </p>
         * 
         * @param statuses
         *        A list of billing groups to retrieve their current status for a specific time range
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<BillingGroupStatus> statuses);

        /**
         * <p>
         * A list of billing groups to retrieve their current status for a specific time range
         * </p>
         * 
         * @param statuses
         *        A list of billing groups to retrieve their current status for a specific time range
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(BillingGroupStatus... statuses);

        /**
         * <p>
         * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that
         * join your consolidated billing family.
         * </p>
         * 
         * @param autoAssociate
         *        Specifies if this billing group will automatically associate newly added Amazon Web Services accounts
         *        that join your consolidated billing family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssociate(Boolean autoAssociate);
    }

    static final class BuilderImpl implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private String pricingPlan;

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoAssociate;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupsFilter model) {
            arns(model.arns);
            pricingPlan(model.pricingPlan);
            statusesWithStrings(model.statuses);
            autoAssociate(model.autoAssociate);
        }

        public final Collection<String> getArns() {
            if (arns instanceof SdkAutoConstructList) {
                return null;
            }
            return arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String... arns) {
            arns(Arrays.asList(arns));
            return this;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = BillingGroupStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = BillingGroupStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<BillingGroupStatus> statuses) {
            this.statuses = BillingGroupStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(BillingGroupStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final Boolean getAutoAssociate() {
            return autoAssociate;
        }

        public final void setAutoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
        }

        @Override
        public final Builder autoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
            return this;
        }

        @Override
        public ListBillingGroupsFilter build() {
            return new ListBillingGroupsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
