/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the charge details of a custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomLineItemChargeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCustomLineItemChargeDetails.Builder, ListCustomLineItemChargeDetails> {
    private static final SdkField<ListCustomLineItemFlatChargeDetails> FLAT_FIELD = SdkField
            .<ListCustomLineItemFlatChargeDetails> builder(MarshallingType.SDK_POJO).memberName("Flat")
            .getter(getter(ListCustomLineItemChargeDetails::flat)).setter(setter(Builder::flat))
            .constructor(ListCustomLineItemFlatChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flat").build()).build();

    private static final SdkField<ListCustomLineItemPercentageChargeDetails> PERCENTAGE_FIELD = SdkField
            .<ListCustomLineItemPercentageChargeDetails> builder(MarshallingType.SDK_POJO).memberName("Percentage")
            .getter(getter(ListCustomLineItemChargeDetails::percentage)).setter(setter(Builder::percentage))
            .constructor(ListCustomLineItemPercentageChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListCustomLineItemChargeDetails::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<LineItemFilter>> LINE_ITEM_FILTERS_FIELD = SdkField
            .<List<LineItemFilter>> builder(MarshallingType.LIST)
            .memberName("LineItemFilters")
            .getter(getter(ListCustomLineItemChargeDetails::lineItemFilters))
            .setter(setter(Builder::lineItemFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineItemFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineItemFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAT_FIELD, PERCENTAGE_FIELD,
            TYPE_FIELD, LINE_ITEM_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ListCustomLineItemFlatChargeDetails flat;

    private final ListCustomLineItemPercentageChargeDetails percentage;

    private final String type;

    private final List<LineItemFilter> lineItemFilters;

    private ListCustomLineItemChargeDetails(BuilderImpl builder) {
        this.flat = builder.flat;
        this.percentage = builder.percentage;
        this.type = builder.type;
        this.lineItemFilters = builder.lineItemFilters;
    }

    /**
     * <p>
     * A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line item.
     * </p>
     * 
     * @return A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom
     *         line item.
     */
    public final ListCustomLineItemFlatChargeDetails flat() {
        return flat;
    }

    /**
     * <p>
     * A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage custom
     * line item.
     * </p>
     * 
     * @return A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a
     *         percentage custom line item.
     */
    public final ListCustomLineItemPercentageChargeDetails percentage() {
        return percentage;
    }

    /**
     * <p>
     * The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CustomLineItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the custom line item that indicates whether the charge is a <code>fee</code> or
     *         <code>credit</code>.
     * @see CustomLineItemType
     */
    public final CustomLineItemType type() {
        return CustomLineItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of the custom line item that indicates whether the charge is a <code>fee</code> or <code>credit</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CustomLineItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the custom line item that indicates whether the charge is a <code>fee</code> or
     *         <code>credit</code>.
     * @see CustomLineItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineItemFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLineItemFilters() {
        return lineItemFilters != null && !(lineItemFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A representation of the line item filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItemFilters} method.
     * </p>
     * 
     * @return A representation of the line item filter.
     */
    public final List<LineItemFilter> lineItemFilters() {
        return lineItemFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flat());
        hashCode = 31 * hashCode + Objects.hashCode(percentage());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLineItemFilters() ? lineItemFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemChargeDetails)) {
            return false;
        }
        ListCustomLineItemChargeDetails other = (ListCustomLineItemChargeDetails) obj;
        return Objects.equals(flat(), other.flat()) && Objects.equals(percentage(), other.percentage())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasLineItemFilters() == other.hasLineItemFilters()
                && Objects.equals(lineItemFilters(), other.lineItemFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomLineItemChargeDetails").add("Flat", flat()).add("Percentage", percentage())
                .add("Type", typeAsString()).add("LineItemFilters", hasLineItemFilters() ? lineItemFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flat":
            return Optional.ofNullable(clazz.cast(flat()));
        case "Percentage":
            return Optional.ofNullable(clazz.cast(percentage()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "LineItemFilters":
            return Optional.ofNullable(clazz.cast(lineItemFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Flat", FLAT_FIELD);
        map.put("Percentage", PERCENTAGE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("LineItemFilters", LINE_ITEM_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemChargeDetails, T> g) {
        return obj -> g.apply((ListCustomLineItemChargeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCustomLineItemChargeDetails> {
        /**
         * <p>
         * A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line
         * item.
         * </p>
         * 
         * @param flat
         *        A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom
         *        line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flat(ListCustomLineItemFlatChargeDetails flat);

        /**
         * <p>
         * A <code>ListCustomLineItemFlatChargeDetails</code> that describes the charge details of a flat custom line
         * item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ListCustomLineItemFlatChargeDetails.Builder} avoiding the need to create one manually via
         * {@link ListCustomLineItemFlatChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCustomLineItemFlatChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #flat(ListCustomLineItemFlatChargeDetails)}.
         * 
         * @param flat
         *        a consumer that will call methods on {@link ListCustomLineItemFlatChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flat(ListCustomLineItemFlatChargeDetails)
         */
        default Builder flat(Consumer<ListCustomLineItemFlatChargeDetails.Builder> flat) {
            return flat(ListCustomLineItemFlatChargeDetails.builder().applyMutation(flat).build());
        }

        /**
         * <p>
         * A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage
         * custom line item.
         * </p>
         * 
         * @param percentage
         *        A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a
         *        percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentage(ListCustomLineItemPercentageChargeDetails percentage);

        /**
         * <p>
         * A <code>ListCustomLineItemPercentageChargeDetails</code> that describes the charge details of a percentage
         * custom line item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ListCustomLineItemPercentageChargeDetails.Builder} avoiding the need to create one manually via
         * {@link ListCustomLineItemPercentageChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCustomLineItemPercentageChargeDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #percentage(ListCustomLineItemPercentageChargeDetails)}.
         * 
         * @param percentage
         *        a consumer that will call methods on {@link ListCustomLineItemPercentageChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #percentage(ListCustomLineItemPercentageChargeDetails)
         */
        default Builder percentage(Consumer<ListCustomLineItemPercentageChargeDetails.Builder> percentage) {
            return percentage(ListCustomLineItemPercentageChargeDetails.builder().applyMutation(percentage).build());
        }

        /**
         * <p>
         * The type of the custom line item that indicates whether the charge is a <code>fee</code> or
         * <code>credit</code>.
         * </p>
         * 
         * @param type
         *        The type of the custom line item that indicates whether the charge is a <code>fee</code> or
         *        <code>credit</code>.
         * @see CustomLineItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomLineItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the custom line item that indicates whether the charge is a <code>fee</code> or
         * <code>credit</code>.
         * </p>
         * 
         * @param type
         *        The type of the custom line item that indicates whether the charge is a <code>fee</code> or
         *        <code>credit</code>.
         * @see CustomLineItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomLineItemType
         */
        Builder type(CustomLineItemType type);

        /**
         * <p>
         * A representation of the line item filter.
         * </p>
         * 
         * @param lineItemFilters
         *        A representation of the line item filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemFilters(Collection<LineItemFilter> lineItemFilters);

        /**
         * <p>
         * A representation of the line item filter.
         * </p>
         * 
         * @param lineItemFilters
         *        A representation of the line item filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemFilters(LineItemFilter... lineItemFilters);

        /**
         * <p>
         * A representation of the line item filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.LineItemFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.LineItemFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.LineItemFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lineItemFilters(List<LineItemFilter>)}.
         * 
         * @param lineItemFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.LineItemFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineItemFilters(java.util.Collection<LineItemFilter>)
         */
        Builder lineItemFilters(Consumer<LineItemFilter.Builder>... lineItemFilters);
    }

    static final class BuilderImpl implements Builder {
        private ListCustomLineItemFlatChargeDetails flat;

        private ListCustomLineItemPercentageChargeDetails percentage;

        private String type;

        private List<LineItemFilter> lineItemFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemChargeDetails model) {
            flat(model.flat);
            percentage(model.percentage);
            type(model.type);
            lineItemFilters(model.lineItemFilters);
        }

        public final ListCustomLineItemFlatChargeDetails.Builder getFlat() {
            return flat != null ? flat.toBuilder() : null;
        }

        public final void setFlat(ListCustomLineItemFlatChargeDetails.BuilderImpl flat) {
            this.flat = flat != null ? flat.build() : null;
        }

        @Override
        public final Builder flat(ListCustomLineItemFlatChargeDetails flat) {
            this.flat = flat;
            return this;
        }

        public final ListCustomLineItemPercentageChargeDetails.Builder getPercentage() {
            return percentage != null ? percentage.toBuilder() : null;
        }

        public final void setPercentage(ListCustomLineItemPercentageChargeDetails.BuilderImpl percentage) {
            this.percentage = percentage != null ? percentage.build() : null;
        }

        @Override
        public final Builder percentage(ListCustomLineItemPercentageChargeDetails percentage) {
            this.percentage = percentage;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CustomLineItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<LineItemFilter.Builder> getLineItemFilters() {
            List<LineItemFilter.Builder> result = LineItemFiltersListCopier.copyToBuilder(this.lineItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemFilters(Collection<LineItemFilter.BuilderImpl> lineItemFilters) {
            this.lineItemFilters = LineItemFiltersListCopier.copyFromBuilder(lineItemFilters);
        }

        @Override
        public final Builder lineItemFilters(Collection<LineItemFilter> lineItemFilters) {
            this.lineItemFilters = LineItemFiltersListCopier.copy(lineItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemFilters(LineItemFilter... lineItemFilters) {
            lineItemFilters(Arrays.asList(lineItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemFilters(Consumer<LineItemFilter.Builder>... lineItemFilters) {
            lineItemFilters(Stream.of(lineItemFilters).map(c -> LineItemFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCustomLineItemChargeDetails build() {
            return new ListCustomLineItemChargeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
