/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomLineItemResponse extends BillingconductorResponse implements
        ToCopyableBuilder<UpdateCustomLineItemResponse.Builder, UpdateCustomLineItemResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateCustomLineItemResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingGroupArn").getter(getter(UpdateCustomLineItemResponse::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateCustomLineItemResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateCustomLineItemResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ListCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField
            .<ListCustomLineItemChargeDetails> builder(MarshallingType.SDK_POJO).memberName("ChargeDetails")
            .getter(getter(UpdateCustomLineItemResponse::chargeDetails)).setter(setter(Builder::chargeDetails))
            .constructor(ListCustomLineItemChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(UpdateCustomLineItemResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Long> ASSOCIATION_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AssociationSize").getter(getter(UpdateCustomLineItemResponse::associationSize))
            .setter(setter(Builder::associationSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            BILLING_GROUP_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CHARGE_DETAILS_FIELD, LAST_MODIFIED_TIME_FIELD,
            ASSOCIATION_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String billingGroupArn;

    private final String name;

    private final String description;

    private final ListCustomLineItemChargeDetails chargeDetails;

    private final Long lastModifiedTime;

    private final Long associationSize;

    private UpdateCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.billingGroupArn = builder.billingGroupArn;
        this.name = builder.name;
        this.description = builder.description;
        this.chargeDetails = builder.chargeDetails;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.associationSize = builder.associationSize;
    }

    /**
     * <p>
     * The ARN of the successfully updated custom line item.
     * </p>
     * 
     * @return The ARN of the successfully updated custom line item.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the billing group that the custom line item is applied to.
     * </p>
     * 
     * @return The ARN of the billing group that the custom line item is applied to.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The name of the successfully updated custom line item.
     * </p>
     * 
     * @return The name of the successfully updated custom line item.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the successfully updated custom line item.
     * </p>
     * 
     * @return The description of the successfully updated custom line item.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated custom
     * line item.
     * </p>
     * 
     * @return A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated
     *         custom line item.
     */
    public final ListCustomLineItemChargeDetails chargeDetails() {
        return chargeDetails;
    }

    /**
     * <p>
     * The most recent time when the custom line item was modified.
     * </p>
     * 
     * @return The most recent time when the custom line item was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The number of resources that are associated to the custom line item.
     * </p>
     * 
     * @return The number of resources that are associated to the custom line item.
     */
    public final Long associationSize() {
        return associationSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(associationSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemResponse)) {
            return false;
        }
        UpdateCustomLineItemResponse other = (UpdateCustomLineItemResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(billingGroupArn(), other.billingGroupArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(chargeDetails(), other.chargeDetails())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(associationSize(), other.associationSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomLineItemResponse").add("Arn", arn()).add("BillingGroupArn", billingGroupArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChargeDetails", chargeDetails()).add("LastModifiedTime", lastModifiedTime())
                .add("AssociationSize", associationSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "BillingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ChargeDetails":
            return Optional.ofNullable(clazz.cast(chargeDetails()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "AssociationSize":
            return Optional.ofNullable(clazz.cast(associationSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ChargeDetails", CHARGE_DETAILS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("AssociationSize", ASSOCIATION_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemResponse, T> g) {
        return obj -> g.apply((UpdateCustomLineItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCustomLineItemResponse> {
        /**
         * <p>
         * The ARN of the successfully updated custom line item.
         * </p>
         * 
         * @param arn
         *        The ARN of the successfully updated custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the billing group that the custom line item is applied to.
         * </p>
         * 
         * @param billingGroupArn
         *        The ARN of the billing group that the custom line item is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The name of the successfully updated custom line item.
         * </p>
         * 
         * @param name
         *        The name of the successfully updated custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the successfully updated custom line item.
         * </p>
         * 
         * @param description
         *        The description of the successfully updated custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated
         * custom line item.
         * </p>
         * 
         * @param chargeDetails
         *        A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully
         *        updated custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails);

        /**
         * <p>
         * A <code>ListCustomLineItemChargeDetails</code> containing the charge details of the successfully updated
         * custom line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListCustomLineItemChargeDetails.Builder}
         * avoiding the need to create one manually via {@link ListCustomLineItemChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCustomLineItemChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chargeDetails(ListCustomLineItemChargeDetails)}.
         * 
         * @param chargeDetails
         *        a consumer that will call methods on {@link ListCustomLineItemChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chargeDetails(ListCustomLineItemChargeDetails)
         */
        default Builder chargeDetails(Consumer<ListCustomLineItemChargeDetails.Builder> chargeDetails) {
            return chargeDetails(ListCustomLineItemChargeDetails.builder().applyMutation(chargeDetails).build());
        }

        /**
         * <p>
         * The most recent time when the custom line item was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time when the custom line item was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The number of resources that are associated to the custom line item.
         * </p>
         * 
         * @param associationSize
         *        The number of resources that are associated to the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSize(Long associationSize);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private String arn;

        private String billingGroupArn;

        private String name;

        private String description;

        private ListCustomLineItemChargeDetails chargeDetails;

        private Long lastModifiedTime;

        private Long associationSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemResponse model) {
            super(model);
            arn(model.arn);
            billingGroupArn(model.billingGroupArn);
            name(model.name);
            description(model.description);
            chargeDetails(model.chargeDetails);
            lastModifiedTime(model.lastModifiedTime);
            associationSize(model.associationSize);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ListCustomLineItemChargeDetails.Builder getChargeDetails() {
            return chargeDetails != null ? chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(ListCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getAssociationSize() {
            return associationSize;
        }

        public final void setAssociationSize(Long associationSize) {
            this.associationSize = associationSize;
        }

        @Override
        public final Builder associationSize(Long associationSize) {
            this.associationSize = associationSize;
            return this;
        }

        @Override
        public UpdateCustomLineItemResponse build() {
            return new UpdateCustomLineItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
