/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of tiering configurations for the pricing rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTieringInput implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateTieringInput.Builder, UpdateTieringInput> {
    private static final SdkField<UpdateFreeTierConfig> FREE_TIER_FIELD = SdkField
            .<UpdateFreeTierConfig> builder(MarshallingType.SDK_POJO).memberName("FreeTier")
            .getter(getter(UpdateTieringInput::freeTier)).setter(setter(Builder::freeTier))
            .constructor(UpdateFreeTierConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeTier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREE_TIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateFreeTierConfig freeTier;

    private UpdateTieringInput(BuilderImpl builder) {
        this.freeTier = builder.freeTier;
    }

    /**
     * <p>
     * The possible Amazon Web Services Free Tier configurations.
     * </p>
     * 
     * @return The possible Amazon Web Services Free Tier configurations.
     */
    public final UpdateFreeTierConfig freeTier() {
        return freeTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(freeTier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTieringInput)) {
            return false;
        }
        UpdateTieringInput other = (UpdateTieringInput) obj;
        return Objects.equals(freeTier(), other.freeTier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTieringInput").add("FreeTier", freeTier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FreeTier":
            return Optional.ofNullable(clazz.cast(freeTier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FreeTier", FREE_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTieringInput, T> g) {
        return obj -> g.apply((UpdateTieringInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateTieringInput> {
        /**
         * <p>
         * The possible Amazon Web Services Free Tier configurations.
         * </p>
         * 
         * @param freeTier
         *        The possible Amazon Web Services Free Tier configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTier(UpdateFreeTierConfig freeTier);

        /**
         * <p>
         * The possible Amazon Web Services Free Tier configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateFreeTierConfig.Builder} avoiding
         * the need to create one manually via {@link UpdateFreeTierConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFreeTierConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #freeTier(UpdateFreeTierConfig)}.
         * 
         * @param freeTier
         *        a consumer that will call methods on {@link UpdateFreeTierConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #freeTier(UpdateFreeTierConfig)
         */
        default Builder freeTier(Consumer<UpdateFreeTierConfig.Builder> freeTier) {
            return freeTier(UpdateFreeTierConfig.builder().applyMutation(freeTier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateFreeTierConfig freeTier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTieringInput model) {
            freeTier(model.freeTier);
        }

        public final UpdateFreeTierConfig.Builder getFreeTier() {
            return freeTier != null ? freeTier.toBuilder() : null;
        }

        public final void setFreeTier(UpdateFreeTierConfig.BuilderImpl freeTier) {
            this.freeTier = freeTier != null ? freeTier.build() : null;
        }

        @Override
        public final Builder freeTier(UpdateFreeTierConfig freeTier) {
            this.freeTier = freeTier;
            return this;
        }

        @Override
        public UpdateTieringInput build() {
            return new UpdateTieringInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
