/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateResourcesFromCustomLineItemResponse extends BillingconductorResponse
        implements
        ToCopyableBuilder<BatchDisassociateResourcesFromCustomLineItemResponse.Builder, BatchDisassociateResourcesFromCustomLineItemResponse> {
    private static final SdkField<List<DisassociateResourceResponseElement>> SUCCESSFULLY_DISASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<DisassociateResourceResponseElement>> builder(MarshallingType.LIST)
            .memberName("SuccessfullyDisassociatedResources")
            .getter(getter(BatchDisassociateResourcesFromCustomLineItemResponse::successfullyDisassociatedResources))
            .setter(setter(Builder::successfullyDisassociatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfullyDisassociatedResources")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DisassociateResourceResponseElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisassociateResourceResponseElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DisassociateResourceResponseElement>> FAILED_DISASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<DisassociateResourceResponseElement>> builder(MarshallingType.LIST)
            .memberName("FailedDisassociatedResources")
            .getter(getter(BatchDisassociateResourcesFromCustomLineItemResponse::failedDisassociatedResources))
            .setter(setter(Builder::failedDisassociatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedDisassociatedResources")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DisassociateResourceResponseElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisassociateResourceResponseElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFULLY_DISASSOCIATED_RESOURCES_FIELD, FAILED_DISASSOCIATED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DisassociateResourceResponseElement> successfullyDisassociatedResources;

    private final List<DisassociateResourceResponseElement> failedDisassociatedResources;

    private BatchDisassociateResourcesFromCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyDisassociatedResources = builder.successfullyDisassociatedResources;
        this.failedDisassociatedResources = builder.failedDisassociatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfullyDisassociatedResources
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSuccessfullyDisassociatedResources() {
        return successfullyDisassociatedResources != null
                && !(successfullyDisassociatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a
     * percentage custom line item successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfullyDisassociatedResources}
     * method.
     * </p>
     * 
     * @return A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated
     *         from a percentage custom line item successfully.
     */
    public final List<DisassociateResourceResponseElement> successfullyDisassociatedResources() {
        return successfullyDisassociatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedDisassociatedResources property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedDisassociatedResources() {
        return failedDisassociatedResources != null && !(failedDisassociatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from a
     * percentage custom line item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedDisassociatedResources} method.
     * </p>
     * 
     * @return A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation
     *         from a percentage custom line item.
     */
    public final List<DisassociateResourceResponseElement> failedDisassociatedResources() {
        return failedDisassociatedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSuccessfullyDisassociatedResources() ? successfullyDisassociatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedDisassociatedResources() ? failedDisassociatedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourcesFromCustomLineItemResponse)) {
            return false;
        }
        BatchDisassociateResourcesFromCustomLineItemResponse other = (BatchDisassociateResourcesFromCustomLineItemResponse) obj;
        return hasSuccessfullyDisassociatedResources() == other.hasSuccessfullyDisassociatedResources()
                && Objects.equals(successfullyDisassociatedResources(), other.successfullyDisassociatedResources())
                && hasFailedDisassociatedResources() == other.hasFailedDisassociatedResources()
                && Objects.equals(failedDisassociatedResources(), other.failedDisassociatedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchDisassociateResourcesFromCustomLineItemResponse")
                .add("SuccessfullyDisassociatedResources",
                        hasSuccessfullyDisassociatedResources() ? successfullyDisassociatedResources() : null)
                .add("FailedDisassociatedResources", hasFailedDisassociatedResources() ? failedDisassociatedResources() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfullyDisassociatedResources":
            return Optional.ofNullable(clazz.cast(successfullyDisassociatedResources()));
        case "FailedDisassociatedResources":
            return Optional.ofNullable(clazz.cast(failedDisassociatedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessfullyDisassociatedResources", SUCCESSFULLY_DISASSOCIATED_RESOURCES_FIELD);
        map.put("FailedDisassociatedResources", FAILED_DISASSOCIATED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateResourcesFromCustomLineItemResponse, T> g) {
        return obj -> g.apply((BatchDisassociateResourcesFromCustomLineItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDisassociateResourcesFromCustomLineItemResponse> {
        /**
         * <p>
         * A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a
         * percentage custom line item successfully.
         * </p>
         * 
         * @param successfullyDisassociatedResources
         *        A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated
         *        from a percentage custom line item successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfullyDisassociatedResources(
                Collection<DisassociateResourceResponseElement> successfullyDisassociatedResources);

        /**
         * <p>
         * A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a
         * percentage custom line item successfully.
         * </p>
         * 
         * @param successfullyDisassociatedResources
         *        A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated
         *        from a percentage custom line item successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfullyDisassociatedResources(DisassociateResourceResponseElement... successfullyDisassociatedResources);

        /**
         * <p>
         * A list of <code>DisassociateResourceResponseElement</code> for each resource that's been disassociated from a
         * percentage custom line item successfully.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successfullyDisassociatedResources(List<DisassociateResourceResponseElement>)}.
         * 
         * @param successfullyDisassociatedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfullyDisassociatedResources(java.util.Collection<DisassociateResourceResponseElement>)
         */
        Builder successfullyDisassociatedResources(
                Consumer<DisassociateResourceResponseElement.Builder>... successfullyDisassociatedResources);

        /**
         * <p>
         * A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from
         * a percentage custom line item.
         * </p>
         * 
         * @param failedDisassociatedResources
         *        A list of <code>DisassociateResourceResponseElement</code> for each resource that failed
         *        disassociation from a percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedDisassociatedResources(Collection<DisassociateResourceResponseElement> failedDisassociatedResources);

        /**
         * <p>
         * A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from
         * a percentage custom line item.
         * </p>
         * 
         * @param failedDisassociatedResources
         *        A list of <code>DisassociateResourceResponseElement</code> for each resource that failed
         *        disassociation from a percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedDisassociatedResources(DisassociateResourceResponseElement... failedDisassociatedResources);

        /**
         * <p>
         * A list of <code>DisassociateResourceResponseElement</code> for each resource that failed disassociation from
         * a percentage custom line item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedDisassociatedResources(List<DisassociateResourceResponseElement>)}.
         * 
         * @param failedDisassociatedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedDisassociatedResources(java.util.Collection<DisassociateResourceResponseElement>)
         */
        Builder failedDisassociatedResources(
                Consumer<DisassociateResourceResponseElement.Builder>... failedDisassociatedResources);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private List<DisassociateResourceResponseElement> successfullyDisassociatedResources = DefaultSdkAutoConstructList
                .getInstance();

        private List<DisassociateResourceResponseElement> failedDisassociatedResources = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateResourcesFromCustomLineItemResponse model) {
            super(model);
            successfullyDisassociatedResources(model.successfullyDisassociatedResources);
            failedDisassociatedResources(model.failedDisassociatedResources);
        }

        public final List<DisassociateResourceResponseElement.Builder> getSuccessfullyDisassociatedResources() {
            List<DisassociateResourceResponseElement.Builder> result = DisassociateResourcesResponseListCopier
                    .copyToBuilder(this.successfullyDisassociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfullyDisassociatedResources(
                Collection<DisassociateResourceResponseElement.BuilderImpl> successfullyDisassociatedResources) {
            this.successfullyDisassociatedResources = DisassociateResourcesResponseListCopier
                    .copyFromBuilder(successfullyDisassociatedResources);
        }

        @Override
        public final Builder successfullyDisassociatedResources(
                Collection<DisassociateResourceResponseElement> successfullyDisassociatedResources) {
            this.successfullyDisassociatedResources = DisassociateResourcesResponseListCopier
                    .copy(successfullyDisassociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDisassociatedResources(
                DisassociateResourceResponseElement... successfullyDisassociatedResources) {
            successfullyDisassociatedResources(Arrays.asList(successfullyDisassociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDisassociatedResources(
                Consumer<DisassociateResourceResponseElement.Builder>... successfullyDisassociatedResources) {
            successfullyDisassociatedResources(Stream.of(successfullyDisassociatedResources)
                    .map(c -> DisassociateResourceResponseElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DisassociateResourceResponseElement.Builder> getFailedDisassociatedResources() {
            List<DisassociateResourceResponseElement.Builder> result = DisassociateResourcesResponseListCopier
                    .copyToBuilder(this.failedDisassociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedDisassociatedResources(
                Collection<DisassociateResourceResponseElement.BuilderImpl> failedDisassociatedResources) {
            this.failedDisassociatedResources = DisassociateResourcesResponseListCopier
                    .copyFromBuilder(failedDisassociatedResources);
        }

        @Override
        public final Builder failedDisassociatedResources(
                Collection<DisassociateResourceResponseElement> failedDisassociatedResources) {
            this.failedDisassociatedResources = DisassociateResourcesResponseListCopier.copy(failedDisassociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDisassociatedResources(DisassociateResourceResponseElement... failedDisassociatedResources) {
            failedDisassociatedResources(Arrays.asList(failedDisassociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDisassociatedResources(
                Consumer<DisassociateResourceResponseElement.Builder>... failedDisassociatedResources) {
            failedDisassociatedResources(Stream.of(failedDisassociatedResources)
                    .map(c -> DisassociateResourceResponseElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateResourcesFromCustomLineItemResponse build() {
            return new BatchDisassociateResourcesFromCustomLineItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
