/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomLineItemRequest extends BillingconductorRequest implements
        ToCopyableBuilder<CreateCustomLineItemRequest.Builder, CreateCustomLineItemRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateCustomLineItemRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCustomLineItemRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCustomLineItemRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingGroupArn").getter(getter(CreateCustomLineItemRequest::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()).build();

    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField
            .<CustomLineItemBillingPeriodRange> builder(MarshallingType.SDK_POJO).memberName("BillingPeriodRange")
            .getter(getter(CreateCustomLineItemRequest::billingPeriodRange)).setter(setter(Builder::billingPeriodRange))
            .constructor(CustomLineItemBillingPeriodRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCustomLineItemRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField
            .<CustomLineItemChargeDetails> builder(MarshallingType.SDK_POJO).memberName("ChargeDetails")
            .getter(getter(CreateCustomLineItemRequest::chargeDetails)).setter(setter(Builder::chargeDetails))
            .constructor(CustomLineItemChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CreateCustomLineItemRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> COMPUTATION_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationRule").getter(getter(CreateCustomLineItemRequest::computationRuleAsString))
            .setter(setter(Builder::computationRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationRule").build()).build();

    private static final SdkField<PresentationObject> PRESENTATION_DETAILS_FIELD = SdkField
            .<PresentationObject> builder(MarshallingType.SDK_POJO).memberName("PresentationDetails")
            .getter(getter(CreateCustomLineItemRequest::presentationDetails)).setter(setter(Builder::presentationDetails))
            .constructor(PresentationObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresentationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, BILLING_GROUP_ARN_FIELD, BILLING_PERIOD_RANGE_FIELD, TAGS_FIELD, CHARGE_DETAILS_FIELD,
            ACCOUNT_ID_FIELD, COMPUTATION_RULE_FIELD, PRESENTATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String name;

    private final String description;

    private final String billingGroupArn;

    private final CustomLineItemBillingPeriodRange billingPeriodRange;

    private final Map<String, String> tags;

    private final CustomLineItemChargeDetails chargeDetails;

    private final String accountId;

    private final String computationRule;

    private final PresentationObject presentationDetails;

    private CreateCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.billingGroupArn = builder.billingGroupArn;
        this.billingPeriodRange = builder.billingPeriodRange;
        this.tags = builder.tags;
        this.chargeDetails = builder.chargeDetails;
        this.accountId = builder.accountId;
        this.computationRule = builder.computationRule;
        this.presentationDetails = builder.presentationDetails;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you specify to ensure idempotency of the request. Idempotency ensures
     * that an API request completes no more than one time. With an idempotent request, if the original request
     * completes successfully, any subsequent retries complete successfully without performing any further actions.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you specify to ensure idempotency of the request. Idempotency
     *         ensures that an API request completes no more than one time. With an idempotent request, if the original
     *         request completes successfully, any subsequent retries complete successfully without performing any
     *         further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the custom line item.
     * </p>
     * 
     * @return The name of the custom line item.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the custom line item. This is shown on the Bills page in association with the charge value.
     * </p>
     * 
     * @return The description of the custom line item. This is shown on the Bills page in association with the charge
     *         value.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * A time range for which the custom line item is effective.
     * </p>
     * 
     * @return A time range for which the custom line item is effective.
     */
    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return billingPeriodRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to a custom line item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to a custom line item.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item.
     * </p>
     * 
     * @return A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item.
     */
    public final CustomLineItemChargeDetails chargeDetails() {
        return chargeDetails;
    }

    /**
     * <p>
     * The Amazon Web Services account in which this custom line item will be applied to.
     * </p>
     * 
     * @return The Amazon Web Services account in which this custom line item will be applied to.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Specifies how the custom line item charges are computed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computationRule}
     * will return {@link ComputationRuleEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #computationRuleAsString}.
     * </p>
     * 
     * @return Specifies how the custom line item charges are computed.
     * @see ComputationRuleEnum
     */
    public final ComputationRuleEnum computationRule() {
        return ComputationRuleEnum.fromValue(computationRule);
    }

    /**
     * <p>
     * Specifies how the custom line item charges are computed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computationRule}
     * will return {@link ComputationRuleEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #computationRuleAsString}.
     * </p>
     * 
     * @return Specifies how the custom line item charges are computed.
     * @see ComputationRuleEnum
     */
    public final String computationRuleAsString() {
        return computationRule;
    }

    /**
     * <p>
     * Details controlling how the custom line item charges are presented in the bill. Contains specifications for which
     * service the charges will be shown under.
     * </p>
     * 
     * @return Details controlling how the custom line item charges are presented in the bill. Contains specifications
     *         for which service the charges will be shown under.
     */
    public final PresentationObject presentationDetails() {
        return presentationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriodRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(computationRuleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(presentationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLineItemRequest)) {
            return false;
        }
        CreateCustomLineItemRequest other = (CreateCustomLineItemRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(billingGroupArn(), other.billingGroupArn())
                && Objects.equals(billingPeriodRange(), other.billingPeriodRange()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(chargeDetails(), other.chargeDetails())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(computationRuleAsString(), other.computationRuleAsString())
                && Objects.equals(presentationDetails(), other.presentationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomLineItemRequest").add("ClientToken", clientToken())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingGroupArn", billingGroupArn()).add("BillingPeriodRange", billingPeriodRange())
                .add("Tags", hasTags() ? tags() : null).add("ChargeDetails", chargeDetails()).add("AccountId", accountId())
                .add("ComputationRule", computationRuleAsString()).add("PresentationDetails", presentationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BillingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "BillingPeriodRange":
            return Optional.ofNullable(clazz.cast(billingPeriodRange()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ChargeDetails":
            return Optional.ofNullable(clazz.cast(chargeDetails()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ComputationRule":
            return Optional.ofNullable(clazz.cast(computationRuleAsString()));
        case "PresentationDetails":
            return Optional.ofNullable(clazz.cast(presentationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("X-Amzn-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("BillingPeriodRange", BILLING_PERIOD_RANGE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ChargeDetails", CHARGE_DETAILS_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ComputationRule", COMPUTATION_RULE_FIELD);
        map.put("PresentationDetails", PRESENTATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLineItemRequest, T> g) {
        return obj -> g.apply((CreateCustomLineItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomLineItemRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you specify to ensure idempotency of the request. Idempotency
         * ensures that an API request completes no more than one time. With an idempotent request, if the original
         * request completes successfully, any subsequent retries complete successfully without performing any further
         * actions.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you specify to ensure idempotency of the request. Idempotency
         *        ensures that an API request completes no more than one time. With an idempotent request, if the
         *        original request completes successfully, any subsequent retries complete successfully without
         *        performing any further actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the custom line item.
         * </p>
         * 
         * @param name
         *        The name of the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the custom line item. This is shown on the Bills page in association with the charge
         * value.
         * </p>
         * 
         * @param description
         *        The description of the custom line item. This is shown on the Bills page in association with the
         *        charge value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
         * </p>
         * 
         * @param billingGroupArn
         *        The Amazon Resource Name (ARN) that references the billing group where the custom line item applies
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * A time range for which the custom line item is effective.
         * </p>
         * 
         * @param billingPeriodRange
         *        A time range for which the custom line item is effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange);

        /**
         * <p>
         * A time range for which the custom line item is effective.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLineItemBillingPeriodRange.Builder}
         * avoiding the need to create one manually via {@link CustomLineItemBillingPeriodRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLineItemBillingPeriodRange.Builder#build()} is called
         * immediately and its result is passed to {@link #billingPeriodRange(CustomLineItemBillingPeriodRange)}.
         * 
         * @param billingPeriodRange
         *        a consumer that will call methods on {@link CustomLineItemBillingPeriodRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriodRange(CustomLineItemBillingPeriodRange)
         */
        default Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return billingPeriodRange(CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange).build());
        }

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to a custom line item.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to a custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item.
         * </p>
         * 
         * @param chargeDetails
         *        A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeDetails(CustomLineItemChargeDetails chargeDetails);

        /**
         * <p>
         * A <code>CustomLineItemChargeDetails</code> that describes the charge details for a custom line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLineItemChargeDetails.Builder}
         * avoiding the need to create one manually via {@link CustomLineItemChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLineItemChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chargeDetails(CustomLineItemChargeDetails)}.
         * 
         * @param chargeDetails
         *        a consumer that will call methods on {@link CustomLineItemChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chargeDetails(CustomLineItemChargeDetails)
         */
        default Builder chargeDetails(Consumer<CustomLineItemChargeDetails.Builder> chargeDetails) {
            return chargeDetails(CustomLineItemChargeDetails.builder().applyMutation(chargeDetails).build());
        }

        /**
         * <p>
         * The Amazon Web Services account in which this custom line item will be applied to.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account in which this custom line item will be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Specifies how the custom line item charges are computed.
         * </p>
         * 
         * @param computationRule
         *        Specifies how the custom line item charges are computed.
         * @see ComputationRuleEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationRuleEnum
         */
        Builder computationRule(String computationRule);

        /**
         * <p>
         * Specifies how the custom line item charges are computed.
         * </p>
         * 
         * @param computationRule
         *        Specifies how the custom line item charges are computed.
         * @see ComputationRuleEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationRuleEnum
         */
        Builder computationRule(ComputationRuleEnum computationRule);

        /**
         * <p>
         * Details controlling how the custom line item charges are presented in the bill. Contains specifications for
         * which service the charges will be shown under.
         * </p>
         * 
         * @param presentationDetails
         *        Details controlling how the custom line item charges are presented in the bill. Contains
         *        specifications for which service the charges will be shown under.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presentationDetails(PresentationObject presentationDetails);

        /**
         * <p>
         * Details controlling how the custom line item charges are presented in the bill. Contains specifications for
         * which service the charges will be shown under.
         * </p>
         * This is a convenience method that creates an instance of the {@link PresentationObject.Builder} avoiding the
         * need to create one manually via {@link PresentationObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PresentationObject.Builder#build()} is called immediately and its
         * result is passed to {@link #presentationDetails(PresentationObject)}.
         * 
         * @param presentationDetails
         *        a consumer that will call methods on {@link PresentationObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presentationDetails(PresentationObject)
         */
        default Builder presentationDetails(Consumer<PresentationObject.Builder> presentationDetails) {
            return presentationDetails(PresentationObject.builder().applyMutation(presentationDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private String description;

        private String billingGroupArn;

        private CustomLineItemBillingPeriodRange billingPeriodRange;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private CustomLineItemChargeDetails chargeDetails;

        private String accountId;

        private String computationRule;

        private PresentationObject presentationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLineItemRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            description(model.description);
            billingGroupArn(model.billingGroupArn);
            billingPeriodRange(model.billingPeriodRange);
            tags(model.tags);
            chargeDetails(model.chargeDetails);
            accountId(model.accountId);
            computationRule(model.computationRule);
            presentationDetails(model.presentationDetails);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return billingPeriodRange != null ? billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final CustomLineItemChargeDetails.Builder getChargeDetails() {
            return chargeDetails != null ? chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(CustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(CustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getComputationRule() {
            return computationRule;
        }

        public final void setComputationRule(String computationRule) {
            this.computationRule = computationRule;
        }

        @Override
        public final Builder computationRule(String computationRule) {
            this.computationRule = computationRule;
            return this;
        }

        @Override
        public final Builder computationRule(ComputationRuleEnum computationRule) {
            this.computationRule(computationRule == null ? null : computationRule.toString());
            return this;
        }

        public final PresentationObject.Builder getPresentationDetails() {
            return presentationDetails != null ? presentationDetails.toBuilder() : null;
        }

        public final void setPresentationDetails(PresentationObject.BuilderImpl presentationDetails) {
            this.presentationDetails = presentationDetails != null ? presentationDetails.build() : null;
        }

        @Override
        public final Builder presentationDetails(PresentationObject presentationDetails) {
            this.presentationDetails = presentationDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomLineItemRequest build() {
            return new CreateCustomLineItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
