/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the charge details that are associated with a flat custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLineItemFlatChargeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLineItemFlatChargeDetails.Builder, CustomLineItemFlatChargeDetails> {
    private static final SdkField<Double> CHARGE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ChargeValue").getter(getter(CustomLineItemFlatChargeDetails::chargeValue))
            .setter(setter(Builder::chargeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARGE_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double chargeValue;

    private CustomLineItemFlatChargeDetails(BuilderImpl builder) {
        this.chargeValue = builder.chargeValue;
    }

    /**
     * <p>
     * The custom line item's fixed charge value in USD.
     * </p>
     * 
     * @return The custom line item's fixed charge value in USD.
     */
    public final Double chargeValue() {
        return chargeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chargeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemFlatChargeDetails)) {
            return false;
        }
        CustomLineItemFlatChargeDetails other = (CustomLineItemFlatChargeDetails) obj;
        return Objects.equals(chargeValue(), other.chargeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLineItemFlatChargeDetails").add("ChargeValue", chargeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChargeValue":
            return Optional.ofNullable(clazz.cast(chargeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChargeValue", CHARGE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemFlatChargeDetails, T> g) {
        return obj -> g.apply((CustomLineItemFlatChargeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLineItemFlatChargeDetails> {
        /**
         * <p>
         * The custom line item's fixed charge value in USD.
         * </p>
         * 
         * @param chargeValue
         *        The custom line item's fixed charge value in USD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeValue(Double chargeValue);
    }

    static final class BuilderImpl implements Builder {
        private Double chargeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemFlatChargeDetails model) {
            chargeValue(model.chargeValue);
        }

        public final Double getChargeValue() {
            return chargeValue;
        }

        public final void setChargeValue(Double chargeValue) {
            this.chargeValue = chargeValue;
        }

        @Override
        public final Builder chargeValue(Double chargeValue) {
            this.chargeValue = chargeValue;
            return this;
        }

        @Override
        public CustomLineItemFlatChargeDetails build() {
            return new CustomLineItemFlatChargeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
