/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of a custom line item version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLineItemVersionListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLineItemVersionListElement.Builder, CustomLineItemVersionListElement> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CustomLineItemVersionListElement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ListCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField
            .<ListCustomLineItemChargeDetails> builder(MarshallingType.SDK_POJO).memberName("ChargeDetails")
            .getter(getter(CustomLineItemVersionListElement::chargeDetails)).setter(setter(Builder::chargeDetails))
            .constructor(ListCustomLineItemChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(CustomLineItemVersionListElement::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CustomLineItemVersionListElement::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(CustomLineItemVersionListElement::productCode))
            .setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingGroupArn").getter(getter(CustomLineItemVersionListElement::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreationTime").getter(getter(CustomLineItemVersionListElement::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(CustomLineItemVersionListElement::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Long> ASSOCIATION_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AssociationSize").getter(getter(CustomLineItemVersionListElement::associationSize))
            .setter(setter(Builder::associationSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSize").build()).build();

    private static final SdkField<String> START_BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartBillingPeriod").getter(getter(CustomLineItemVersionListElement::startBillingPeriod))
            .setter(setter(Builder::startBillingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartBillingPeriod").build())
            .build();

    private static final SdkField<String> END_BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndBillingPeriod").getter(getter(CustomLineItemVersionListElement::endBillingPeriod))
            .setter(setter(Builder::endBillingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndBillingPeriod").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CustomLineItemVersionListElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("StartTime")
            .getter(getter(CustomLineItemVersionListElement::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CustomLineItemVersionListElement::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> COMPUTATION_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationRule").getter(getter(CustomLineItemVersionListElement::computationRuleAsString))
            .setter(setter(Builder::computationRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationRule").build()).build();

    private static final SdkField<PresentationObject> PRESENTATION_DETAILS_FIELD = SdkField
            .<PresentationObject> builder(MarshallingType.SDK_POJO).memberName("PresentationDetails")
            .getter(getter(CustomLineItemVersionListElement::presentationDetails)).setter(setter(Builder::presentationDetails))
            .constructor(PresentationObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresentationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CHARGE_DETAILS_FIELD, CURRENCY_CODE_FIELD, DESCRIPTION_FIELD, PRODUCT_CODE_FIELD, BILLING_GROUP_ARN_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ASSOCIATION_SIZE_FIELD, START_BILLING_PERIOD_FIELD,
            END_BILLING_PERIOD_FIELD, ARN_FIELD, START_TIME_FIELD, ACCOUNT_ID_FIELD, COMPUTATION_RULE_FIELD,
            PRESENTATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ListCustomLineItemChargeDetails chargeDetails;

    private final String currencyCode;

    private final String description;

    private final String productCode;

    private final String billingGroupArn;

    private final Long creationTime;

    private final Long lastModifiedTime;

    private final Long associationSize;

    private final String startBillingPeriod;

    private final String endBillingPeriod;

    private final String arn;

    private final Long startTime;

    private final String accountId;

    private final String computationRule;

    private final PresentationObject presentationDetails;

    private CustomLineItemVersionListElement(BuilderImpl builder) {
        this.name = builder.name;
        this.chargeDetails = builder.chargeDetails;
        this.currencyCode = builder.currencyCode;
        this.description = builder.description;
        this.productCode = builder.productCode;
        this.billingGroupArn = builder.billingGroupArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.associationSize = builder.associationSize;
        this.startBillingPeriod = builder.startBillingPeriod;
        this.endBillingPeriod = builder.endBillingPeriod;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.accountId = builder.accountId;
        this.computationRule = builder.computationRule;
        this.presentationDetails = builder.presentationDetails;
    }

    /**
     * <p>
     * The name of the custom line item.
     * </p>
     * 
     * @return The name of the custom line item.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the ChargeDetails property for this object.
     * 
     * @return The value of the ChargeDetails property for this object.
     */
    public final ListCustomLineItemChargeDetails chargeDetails() {
        return chargeDetails;
    }

    /**
     * <p>
     * The charge value currency of the custom line item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The charge value currency of the custom line item.
     * @see CurrencyCode
     */
    public final CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(currencyCode);
    }

    /**
     * <p>
     * The charge value currency of the custom line item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The charge value currency of the custom line item.
     * @see CurrencyCode
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The description of the custom line item.
     * </p>
     * 
     * @return The description of the custom line item.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The product code that’s associated with the custom line item.
     * </p>
     * 
     * @return The product code that’s associated with the custom line item.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the billing group that the custom line item applies to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the billing group that the custom line item applies to.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The time when the custom line item version was created.
     * </p>
     * 
     * @return The time when the custom line item version was created.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The most recent time that the custom line item version was modified.
     * </p>
     * 
     * @return The most recent time that the custom line item version was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The number of resources that are associated with the custom line item.
     * </p>
     * 
     * @return The number of resources that are associated with the custom line item.
     */
    public final Long associationSize() {
        return associationSize;
    }

    /**
     * <p>
     * The start billing period of the custom line item version.
     * </p>
     * 
     * @return The start billing period of the custom line item version.
     */
    public final String startBillingPeriod() {
        return startBillingPeriod;
    }

    /**
     * <p>
     * The end billing period of the custom line item version.
     * </p>
     * 
     * @return The end billing period of the custom line item version.
     */
    public final String endBillingPeriod() {
        return endBillingPeriod;
    }

    /**
     * <p>
     * A list of custom line item Amazon Resource Names (ARNs) to retrieve information.
     * </p>
     * 
     * @return A list of custom line item Amazon Resource Names (ARNs) to retrieve information.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The inclusive start time.
     * </p>
     * 
     * @return The inclusive start time.
     */
    public final Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The Amazon Web Services account in which this custom line item will be applied to.
     * </p>
     * 
     * @return The Amazon Web Services account in which this custom line item will be applied to.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The computation rule for a specific version of a custom line item, determining how charges are computed and
     * reflected in the bill.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computationRule}
     * will return {@link ComputationRuleEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #computationRuleAsString}.
     * </p>
     * 
     * @return The computation rule for a specific version of a custom line item, determining how charges are computed
     *         and reflected in the bill.
     * @see ComputationRuleEnum
     */
    public final ComputationRuleEnum computationRule() {
        return ComputationRuleEnum.fromValue(computationRule);
    }

    /**
     * <p>
     * The computation rule for a specific version of a custom line item, determining how charges are computed and
     * reflected in the bill.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computationRule}
     * will return {@link ComputationRuleEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #computationRuleAsString}.
     * </p>
     * 
     * @return The computation rule for a specific version of a custom line item, determining how charges are computed
     *         and reflected in the bill.
     * @see ComputationRuleEnum
     */
    public final String computationRuleAsString() {
        return computationRule;
    }

    /**
     * <p>
     * Presentation configuration for a specific version of a custom line item, specifying how charges are displayed in
     * the bill.
     * </p>
     * 
     * @return Presentation configuration for a specific version of a custom line item, specifying how charges are
     *         displayed in the bill.
     */
    public final PresentationObject presentationDetails() {
        return presentationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(associationSize());
        hashCode = 31 * hashCode + Objects.hashCode(startBillingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(endBillingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(computationRuleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(presentationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemVersionListElement)) {
            return false;
        }
        CustomLineItemVersionListElement other = (CustomLineItemVersionListElement) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(chargeDetails(), other.chargeDetails())
                && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(productCode(), other.productCode())
                && Objects.equals(billingGroupArn(), other.billingGroupArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(associationSize(), other.associationSize())
                && Objects.equals(startBillingPeriod(), other.startBillingPeriod())
                && Objects.equals(endBillingPeriod(), other.endBillingPeriod()) && Objects.equals(arn(), other.arn())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(computationRuleAsString(), other.computationRuleAsString())
                && Objects.equals(presentationDetails(), other.presentationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLineItemVersionListElement")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ChargeDetails", chargeDetails())
                .add("CurrencyCode", currencyCodeAsString())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProductCode", productCode()).add("BillingGroupArn", billingGroupArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("AssociationSize", associationSize())
                .add("StartBillingPeriod", startBillingPeriod()).add("EndBillingPeriod", endBillingPeriod()).add("Arn", arn())
                .add("StartTime", startTime()).add("AccountId", accountId()).add("ComputationRule", computationRuleAsString())
                .add("PresentationDetails", presentationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ChargeDetails":
            return Optional.ofNullable(clazz.cast(chargeDetails()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "BillingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "AssociationSize":
            return Optional.ofNullable(clazz.cast(associationSize()));
        case "StartBillingPeriod":
            return Optional.ofNullable(clazz.cast(startBillingPeriod()));
        case "EndBillingPeriod":
            return Optional.ofNullable(clazz.cast(endBillingPeriod()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ComputationRule":
            return Optional.ofNullable(clazz.cast(computationRuleAsString()));
        case "PresentationDetails":
            return Optional.ofNullable(clazz.cast(presentationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ChargeDetails", CHARGE_DETAILS_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("AssociationSize", ASSOCIATION_SIZE_FIELD);
        map.put("StartBillingPeriod", START_BILLING_PERIOD_FIELD);
        map.put("EndBillingPeriod", END_BILLING_PERIOD_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ComputationRule", COMPUTATION_RULE_FIELD);
        map.put("PresentationDetails", PRESENTATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemVersionListElement, T> g) {
        return obj -> g.apply((CustomLineItemVersionListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLineItemVersionListElement> {
        /**
         * <p>
         * The name of the custom line item.
         * </p>
         * 
         * @param name
         *        The name of the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ChargeDetails property for this object.
         *
         * @param chargeDetails
         *        The new value for the ChargeDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails);

        /**
         * Sets the value of the ChargeDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ListCustomLineItemChargeDetails.Builder}
         * avoiding the need to create one manually via {@link ListCustomLineItemChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCustomLineItemChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chargeDetails(ListCustomLineItemChargeDetails)}.
         * 
         * @param chargeDetails
         *        a consumer that will call methods on {@link ListCustomLineItemChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chargeDetails(ListCustomLineItemChargeDetails)
         */
        default Builder chargeDetails(Consumer<ListCustomLineItemChargeDetails.Builder> chargeDetails) {
            return chargeDetails(ListCustomLineItemChargeDetails.builder().applyMutation(chargeDetails).build());
        }

        /**
         * <p>
         * The charge value currency of the custom line item.
         * </p>
         * 
         * @param currencyCode
         *        The charge value currency of the custom line item.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The charge value currency of the custom line item.
         * </p>
         * 
         * @param currencyCode
         *        The charge value currency of the custom line item.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(CurrencyCode currencyCode);

        /**
         * <p>
         * The description of the custom line item.
         * </p>
         * 
         * @param description
         *        The description of the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The product code that’s associated with the custom line item.
         * </p>
         * 
         * @param productCode
         *        The product code that’s associated with the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the billing group that the custom line item applies to.
         * </p>
         * 
         * @param billingGroupArn
         *        The Amazon Resource Name (ARN) of the billing group that the custom line item applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The time when the custom line item version was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the custom line item version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The most recent time that the custom line item version was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time that the custom line item version was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The number of resources that are associated with the custom line item.
         * </p>
         * 
         * @param associationSize
         *        The number of resources that are associated with the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSize(Long associationSize);

        /**
         * <p>
         * The start billing period of the custom line item version.
         * </p>
         * 
         * @param startBillingPeriod
         *        The start billing period of the custom line item version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startBillingPeriod(String startBillingPeriod);

        /**
         * <p>
         * The end billing period of the custom line item version.
         * </p>
         * 
         * @param endBillingPeriod
         *        The end billing period of the custom line item version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endBillingPeriod(String endBillingPeriod);

        /**
         * <p>
         * A list of custom line item Amazon Resource Names (ARNs) to retrieve information.
         * </p>
         * 
         * @param arn
         *        A list of custom line item Amazon Resource Names (ARNs) to retrieve information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The inclusive start time.
         * </p>
         * 
         * @param startTime
         *        The inclusive start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The Amazon Web Services account in which this custom line item will be applied to.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account in which this custom line item will be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The computation rule for a specific version of a custom line item, determining how charges are computed and
         * reflected in the bill.
         * </p>
         * 
         * @param computationRule
         *        The computation rule for a specific version of a custom line item, determining how charges are
         *        computed and reflected in the bill.
         * @see ComputationRuleEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationRuleEnum
         */
        Builder computationRule(String computationRule);

        /**
         * <p>
         * The computation rule for a specific version of a custom line item, determining how charges are computed and
         * reflected in the bill.
         * </p>
         * 
         * @param computationRule
         *        The computation rule for a specific version of a custom line item, determining how charges are
         *        computed and reflected in the bill.
         * @see ComputationRuleEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationRuleEnum
         */
        Builder computationRule(ComputationRuleEnum computationRule);

        /**
         * <p>
         * Presentation configuration for a specific version of a custom line item, specifying how charges are displayed
         * in the bill.
         * </p>
         * 
         * @param presentationDetails
         *        Presentation configuration for a specific version of a custom line item, specifying how charges are
         *        displayed in the bill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presentationDetails(PresentationObject presentationDetails);

        /**
         * <p>
         * Presentation configuration for a specific version of a custom line item, specifying how charges are displayed
         * in the bill.
         * </p>
         * This is a convenience method that creates an instance of the {@link PresentationObject.Builder} avoiding the
         * need to create one manually via {@link PresentationObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PresentationObject.Builder#build()} is called immediately and its
         * result is passed to {@link #presentationDetails(PresentationObject)}.
         * 
         * @param presentationDetails
         *        a consumer that will call methods on {@link PresentationObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presentationDetails(PresentationObject)
         */
        default Builder presentationDetails(Consumer<PresentationObject.Builder> presentationDetails) {
            return presentationDetails(PresentationObject.builder().applyMutation(presentationDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ListCustomLineItemChargeDetails chargeDetails;

        private String currencyCode;

        private String description;

        private String productCode;

        private String billingGroupArn;

        private Long creationTime;

        private Long lastModifiedTime;

        private Long associationSize;

        private String startBillingPeriod;

        private String endBillingPeriod;

        private String arn;

        private Long startTime;

        private String accountId;

        private String computationRule;

        private PresentationObject presentationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemVersionListElement model) {
            name(model.name);
            chargeDetails(model.chargeDetails);
            currencyCode(model.currencyCode);
            description(model.description);
            productCode(model.productCode);
            billingGroupArn(model.billingGroupArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            associationSize(model.associationSize);
            startBillingPeriod(model.startBillingPeriod);
            endBillingPeriod(model.endBillingPeriod);
            arn(model.arn);
            startTime(model.startTime);
            accountId(model.accountId);
            computationRule(model.computationRule);
            presentationDetails(model.presentationDetails);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ListCustomLineItemChargeDetails.Builder getChargeDetails() {
            return chargeDetails != null ? chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(ListCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getAssociationSize() {
            return associationSize;
        }

        public final void setAssociationSize(Long associationSize) {
            this.associationSize = associationSize;
        }

        @Override
        public final Builder associationSize(Long associationSize) {
            this.associationSize = associationSize;
            return this;
        }

        public final String getStartBillingPeriod() {
            return startBillingPeriod;
        }

        public final void setStartBillingPeriod(String startBillingPeriod) {
            this.startBillingPeriod = startBillingPeriod;
        }

        @Override
        public final Builder startBillingPeriod(String startBillingPeriod) {
            this.startBillingPeriod = startBillingPeriod;
            return this;
        }

        public final String getEndBillingPeriod() {
            return endBillingPeriod;
        }

        public final void setEndBillingPeriod(String endBillingPeriod) {
            this.endBillingPeriod = endBillingPeriod;
        }

        @Override
        public final Builder endBillingPeriod(String endBillingPeriod) {
            this.endBillingPeriod = endBillingPeriod;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getStartTime() {
            return startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getComputationRule() {
            return computationRule;
        }

        public final void setComputationRule(String computationRule) {
            this.computationRule = computationRule;
        }

        @Override
        public final Builder computationRule(String computationRule) {
            this.computationRule = computationRule;
            return this;
        }

        @Override
        public final Builder computationRule(ComputationRuleEnum computationRule) {
            this.computationRule(computationRule == null ? null : computationRule.toString());
            return this;
        }

        public final PresentationObject.Builder getPresentationDetails() {
            return presentationDetails != null ? presentationDetails.toBuilder() : null;
        }

        public final void setPresentationDetails(PresentationObject.BuilderImpl presentationDetails) {
            this.presentationDetails = presentationDetails != null ? presentationDetails.build() : null;
        }

        @Override
        public final Builder presentationDetails(PresentationObject presentationDetails) {
            this.presentationDetails = presentationDetails;
            return this;
        }

        @Override
        public CustomLineItemVersionListElement build() {
            return new CustomLineItemVersionListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
