/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPricingPlansRequest extends BillingconductorRequest implements
        ToCopyableBuilder<ListPricingPlansRequest.Builder, ListPricingPlansRequest> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingPeriod").getter(getter(ListPricingPlansRequest::billingPeriod))
            .setter(setter(Builder::billingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<ListPricingPlansFilter> FILTERS_FIELD = SdkField
            .<ListPricingPlansFilter> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListPricingPlansRequest::filters)).setter(setter(Builder::filters))
            .constructor(ListPricingPlansFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPricingPlansRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPricingPlansRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String billingPeriod;

    private final ListPricingPlansFilter filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListPricingPlansRequest(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The preferred billing period to get pricing plan.
     * </p>
     * 
     * @return The preferred billing period to get pricing plan.
     */
    public final String billingPeriod() {
        return billingPeriod;
    }

    /**
     * <p>
     * A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to retrieve
     * pricing plans information.
     * </p>
     * 
     * @return A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to
     *         retrieve pricing plans information.
     */
    public final ListPricingPlansFilter filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of pricing plans to retrieve.
     * </p>
     * 
     * @return The maximum number of pricing plans to retrieve.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that's used on subsequent call to get pricing plans.
     * </p>
     * 
     * @return The pagination token that's used on subsequent call to get pricing plans.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingPlansRequest)) {
            return false;
        }
        ListPricingPlansRequest other = (ListPricingPlansRequest) obj;
        return Objects.equals(billingPeriod(), other.billingPeriod()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPricingPlansRequest").add("BillingPeriod", billingPeriod()).add("Filters", filters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPricingPlansRequest, T> g) {
        return obj -> g.apply((ListPricingPlansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingconductorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPricingPlansRequest> {
        /**
         * <p>
         * The preferred billing period to get pricing plan.
         * </p>
         * 
         * @param billingPeriod
         *        The preferred billing period to get pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(String billingPeriod);

        /**
         * <p>
         * A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to
         * retrieve pricing plans information.
         * </p>
         * 
         * @param filters
         *        A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans
         *        to retrieve pricing plans information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListPricingPlansFilter filters);

        /**
         * <p>
         * A <code>ListPricingPlansFilter</code> that specifies the Amazon Resource Name (ARNs) of pricing plans to
         * retrieve pricing plans information.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListPricingPlansFilter.Builder} avoiding
         * the need to create one manually via {@link ListPricingPlansFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListPricingPlansFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(ListPricingPlansFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ListPricingPlansFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ListPricingPlansFilter)
         */
        default Builder filters(Consumer<ListPricingPlansFilter.Builder> filters) {
            return filters(ListPricingPlansFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum number of pricing plans to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of pricing plans to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that's used on subsequent call to get pricing plans.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used on subsequent call to get pricing plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String billingPeriod;

        private ListPricingPlansFilter filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingPlansRequest model) {
            super(model);
            billingPeriod(model.billingPeriod);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final ListPricingPlansFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ListPricingPlansFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ListPricingPlansFilter filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPricingPlansRequest build() {
            return new ListPricingPlansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
