/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPricingRulesResponse extends BillingconductorResponse implements
        ToCopyableBuilder<ListPricingRulesResponse.Builder, ListPricingRulesResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingPeriod").getter(getter(ListPricingRulesResponse::billingPeriod))
            .setter(setter(Builder::billingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<List<PricingRuleListElement>> PRICING_RULES_FIELD = SdkField
            .<List<PricingRuleListElement>> builder(MarshallingType.LIST)
            .memberName("PricingRules")
            .getter(getter(ListPricingRulesResponse::pricingRules))
            .setter(setter(Builder::pricingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PricingRuleListElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(PricingRuleListElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPricingRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD,
            PRICING_RULES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String billingPeriod;

    private final List<PricingRuleListElement> pricingRules;

    private final String nextToken;

    private ListPricingRulesResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingRules = builder.pricingRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The billing period for which the described pricing rules are applicable.
     * </p>
     * 
     * @return The billing period for which the described pricing rules are applicable.
     */
    public final String billingPeriod() {
        return billingPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the PricingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPricingRules() {
        return pricingRules != null && !(pricingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the described pricing rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPricingRules} method.
     * </p>
     * 
     * @return A list containing the described pricing rules.
     */
    public final List<PricingRuleListElement> pricingRules() {
        return pricingRules;
    }

    /**
     * <p>
     * The pagination token that's used on subsequent calls to get pricing rules.
     * </p>
     * 
     * @return The pagination token that's used on subsequent calls to get pricing rules.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasPricingRules() ? pricingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingRulesResponse)) {
            return false;
        }
        ListPricingRulesResponse other = (ListPricingRulesResponse) obj;
        return Objects.equals(billingPeriod(), other.billingPeriod()) && hasPricingRules() == other.hasPricingRules()
                && Objects.equals(pricingRules(), other.pricingRules()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPricingRulesResponse").add("BillingPeriod", billingPeriod())
                .add("PricingRules", hasPricingRules() ? pricingRules() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "PricingRules":
            return Optional.ofNullable(clazz.cast(pricingRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("PricingRules", PRICING_RULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPricingRulesResponse, T> g) {
        return obj -> g.apply((ListPricingRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPricingRulesResponse> {
        /**
         * <p>
         * The billing period for which the described pricing rules are applicable.
         * </p>
         * 
         * @param billingPeriod
         *        The billing period for which the described pricing rules are applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(String billingPeriod);

        /**
         * <p>
         * A list containing the described pricing rules.
         * </p>
         * 
         * @param pricingRules
         *        A list containing the described pricing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingRules(Collection<PricingRuleListElement> pricingRules);

        /**
         * <p>
         * A list containing the described pricing rules.
         * </p>
         * 
         * @param pricingRules
         *        A list containing the described pricing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingRules(PricingRuleListElement... pricingRules);

        /**
         * <p>
         * A list containing the described pricing rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement.Builder#build()} is
         * called immediately and its result is passed to {@link #pricingRules(List<PricingRuleListElement>)}.
         * 
         * @param pricingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pricingRules(java.util.Collection<PricingRuleListElement>)
         */
        Builder pricingRules(Consumer<PricingRuleListElement.Builder>... pricingRules);

        /**
         * <p>
         * The pagination token that's used on subsequent calls to get pricing rules.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used on subsequent calls to get pricing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private String billingPeriod;

        private List<PricingRuleListElement> pricingRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingRulesResponse model) {
            super(model);
            billingPeriod(model.billingPeriod);
            pricingRules(model.pricingRules);
            nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final List<PricingRuleListElement.Builder> getPricingRules() {
            List<PricingRuleListElement.Builder> result = PricingRuleListCopier.copyToBuilder(this.pricingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPricingRules(Collection<PricingRuleListElement.BuilderImpl> pricingRules) {
            this.pricingRules = PricingRuleListCopier.copyFromBuilder(pricingRules);
        }

        @Override
        public final Builder pricingRules(Collection<PricingRuleListElement> pricingRules) {
            this.pricingRules = PricingRuleListCopier.copy(pricingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRules(PricingRuleListElement... pricingRules) {
            pricingRules(Arrays.asList(pricingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRules(Consumer<PricingRuleListElement.Builder>... pricingRules) {
            pricingRules(Stream.of(pricingRules).map(c -> PricingRuleListElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingRulesResponse build() {
            return new ListPricingRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
