/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceResponse extends BraketResponse implements
        ToCopyableBuilder<GetDeviceResponse.Builder, GetDeviceResponse> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(GetDeviceResponse::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> DEVICE_CAPABILITIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceCapabilities")
            .getter(getter(GetDeviceResponse::deviceCapabilities))
            .setter(setter(Builder::deviceCapabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCapabilities").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceName").getter(getter(GetDeviceResponse::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceStatus").getter(getter(GetDeviceResponse::deviceStatusAsString))
            .setter(setter(Builder::deviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceStatus").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceType").getter(getter(GetDeviceResponse::deviceTypeAsString)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(GetDeviceResponse::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD,
            DEVICE_CAPABILITIES_FIELD, DEVICE_NAME_FIELD, DEVICE_STATUS_FIELD, DEVICE_TYPE_FIELD, PROVIDER_NAME_FIELD));

    private final String deviceArn;

    private final String deviceCapabilities;

    private final String deviceName;

    private final String deviceStatus;

    private final String deviceType;

    private final String providerName;

    private GetDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceCapabilities = builder.deviceCapabilities;
        this.deviceName = builder.deviceName;
        this.deviceStatus = builder.deviceStatus;
        this.deviceType = builder.deviceType;
        this.providerName = builder.providerName;
    }

    /**
     * <p>
     * The ARN of the device.
     * </p>
     * 
     * @return The ARN of the device.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * Details about the capabilities of the device.
     * </p>
     * 
     * @return Details about the capabilities of the device.
     */
    public String deviceCapabilities() {
        return deviceCapabilities;
    }

    /**
     * <p>
     * The name of the device.
     * </p>
     * 
     * @return The name of the device.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(deviceStatus);
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public String deviceStatusAsString() {
        return deviceStatus;
    }

    /**
     * <p>
     * The type of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The type of the device.
     * @see DeviceType
     */
    public DeviceType deviceType() {
        return DeviceType.fromValue(deviceType);
    }

    /**
     * <p>
     * The type of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The type of the device.
     * @see DeviceType
     */
    public String deviceTypeAsString() {
        return deviceType;
    }

    /**
     * <p>
     * The name of the partner company for the device.
     * </p>
     * 
     * @return The name of the partner company for the device.
     */
    public String providerName() {
        return providerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceCapabilities(), other.deviceCapabilities())
                && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(deviceStatusAsString(), other.deviceStatusAsString())
                && Objects.equals(deviceTypeAsString(), other.deviceTypeAsString())
                && Objects.equals(providerName(), other.providerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDeviceResponse").add("DeviceArn", deviceArn())
                .add("DeviceCapabilities", deviceCapabilities()).add("DeviceName", deviceName())
                .add("DeviceStatus", deviceStatusAsString()).add("DeviceType", deviceTypeAsString())
                .add("ProviderName", providerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "deviceCapabilities":
            return Optional.ofNullable(clazz.cast(deviceCapabilities()));
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "deviceStatus":
            return Optional.ofNullable(clazz.cast(deviceStatusAsString()));
        case "deviceType":
            return Optional.ofNullable(clazz.cast(deviceTypeAsString()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceResponse, T> g) {
        return obj -> g.apply((GetDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeviceResponse> {
        /**
         * <p>
         * The ARN of the device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * Details about the capabilities of the device.
         * </p>
         * 
         * @param deviceCapabilities
         *        Details about the capabilities of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCapabilities(String deviceCapabilities);

        /**
         * <p>
         * The name of the device.
         * </p>
         * 
         * @param deviceName
         *        The name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(String deviceStatus);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(DeviceStatus deviceStatus);

        /**
         * <p>
         * The type of the device.
         * </p>
         * 
         * @param deviceType
         *        The type of the device.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The type of the device.
         * </p>
         * 
         * @param deviceType
         *        The type of the device.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(DeviceType deviceType);

        /**
         * <p>
         * The name of the partner company for the device.
         * </p>
         * 
         * @param providerName
         *        The name of the partner company for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceCapabilities;

        private String deviceName;

        private String deviceStatus;

        private String deviceType;

        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            super(model);
            deviceArn(model.deviceArn);
            deviceCapabilities(model.deviceCapabilities);
            deviceName(model.deviceName);
            deviceStatus(model.deviceStatus);
            deviceType(model.deviceType);
            providerName(model.providerName);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceCapabilities() {
            return deviceCapabilities;
        }

        @Override
        public final Builder deviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
            return this;
        }

        public final void setDeviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getDeviceStatus() {
            return deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
