/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Amazon Braket job to be created. Specifies the container image the job uses and the paths to the Python
 * scripts used for entry and training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AlgorithmSpecification.Builder, AlgorithmSpecification> {
    private static final SdkField<ContainerImage> CONTAINER_IMAGE_FIELD = SdkField
            .<ContainerImage> builder(MarshallingType.SDK_POJO).memberName("containerImage")
            .getter(getter(AlgorithmSpecification::containerImage)).setter(setter(Builder::containerImage))
            .constructor(ContainerImage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerImage").build()).build();

    private static final SdkField<ScriptModeConfig> SCRIPT_MODE_CONFIG_FIELD = SdkField
            .<ScriptModeConfig> builder(MarshallingType.SDK_POJO).memberName("scriptModeConfig")
            .getter(getter(AlgorithmSpecification::scriptModeConfig)).setter(setter(Builder::scriptModeConfig))
            .constructor(ScriptModeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptModeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_IMAGE_FIELD,
            SCRIPT_MODE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContainerImage containerImage;

    private final ScriptModeConfig scriptModeConfig;

    private AlgorithmSpecification(BuilderImpl builder) {
        this.containerImage = builder.containerImage;
        this.scriptModeConfig = builder.scriptModeConfig;
    }

    /**
     * <p>
     * The container image used to create an Amazon Braket job.
     * </p>
     * 
     * @return The container image used to create an Amazon Braket job.
     */
    public final ContainerImage containerImage() {
        return containerImage;
    }

    /**
     * <p>
     * Configures the paths to the Python scripts used for entry and training.
     * </p>
     * 
     * @return Configures the paths to the Python scripts used for entry and training.
     */
    public final ScriptModeConfig scriptModeConfig() {
        return scriptModeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerImage());
        hashCode = 31 * hashCode + Objects.hashCode(scriptModeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSpecification)) {
            return false;
        }
        AlgorithmSpecification other = (AlgorithmSpecification) obj;
        return Objects.equals(containerImage(), other.containerImage())
                && Objects.equals(scriptModeConfig(), other.scriptModeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlgorithmSpecification").add("ContainerImage", containerImage())
                .add("ScriptModeConfig", scriptModeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerImage":
            return Optional.ofNullable(clazz.cast(containerImage()));
        case "scriptModeConfig":
            return Optional.ofNullable(clazz.cast(scriptModeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmSpecification, T> g) {
        return obj -> g.apply((AlgorithmSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmSpecification> {
        /**
         * <p>
         * The container image used to create an Amazon Braket job.
         * </p>
         * 
         * @param containerImage
         *        The container image used to create an Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerImage(ContainerImage containerImage);

        /**
         * <p>
         * The container image used to create an Amazon Braket job.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerImage.Builder} avoiding the need to
         * create one manually via {@link ContainerImage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerImage.Builder#build()} is called immediately and its
         * result is passed to {@link #containerImage(ContainerImage)}.
         * 
         * @param containerImage
         *        a consumer that will call methods on {@link ContainerImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerImage(ContainerImage)
         */
        default Builder containerImage(Consumer<ContainerImage.Builder> containerImage) {
            return containerImage(ContainerImage.builder().applyMutation(containerImage).build());
        }

        /**
         * <p>
         * Configures the paths to the Python scripts used for entry and training.
         * </p>
         * 
         * @param scriptModeConfig
         *        Configures the paths to the Python scripts used for entry and training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptModeConfig(ScriptModeConfig scriptModeConfig);

        /**
         * <p>
         * Configures the paths to the Python scripts used for entry and training.
         * </p>
         * This is a convenience that creates an instance of the {@link ScriptModeConfig.Builder} avoiding the need to
         * create one manually via {@link ScriptModeConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScriptModeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #scriptModeConfig(ScriptModeConfig)}.
         * 
         * @param scriptModeConfig
         *        a consumer that will call methods on {@link ScriptModeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptModeConfig(ScriptModeConfig)
         */
        default Builder scriptModeConfig(Consumer<ScriptModeConfig.Builder> scriptModeConfig) {
            return scriptModeConfig(ScriptModeConfig.builder().applyMutation(scriptModeConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContainerImage containerImage;

        private ScriptModeConfig scriptModeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSpecification model) {
            containerImage(model.containerImage);
            scriptModeConfig(model.scriptModeConfig);
        }

        public final ContainerImage.Builder getContainerImage() {
            return containerImage != null ? containerImage.toBuilder() : null;
        }

        public final void setContainerImage(ContainerImage.BuilderImpl containerImage) {
            this.containerImage = containerImage != null ? containerImage.build() : null;
        }

        @Override
        @Transient
        public final Builder containerImage(ContainerImage containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        public final ScriptModeConfig.Builder getScriptModeConfig() {
            return scriptModeConfig != null ? scriptModeConfig.toBuilder() : null;
        }

        public final void setScriptModeConfig(ScriptModeConfig.BuilderImpl scriptModeConfig) {
            this.scriptModeConfig = scriptModeConfig != null ? scriptModeConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder scriptModeConfig(ScriptModeConfig scriptModeConfig) {
            this.scriptModeConfig = scriptModeConfig;
            return this;
        }

        @Override
        public AlgorithmSpecification build() {
            return new AlgorithmSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
