/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelJobResponse extends BraketResponse implements
        ToCopyableBuilder<CancelJobResponse.Builder, CancelJobResponse> {
    private static final SdkField<String> CANCELLATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cancellationStatus").getter(getter(CancelJobResponse::cancellationStatusAsString))
            .setter(setter(Builder::cancellationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancellationStatus").build())
            .build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(CancelJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLATION_STATUS_FIELD,
            JOB_ARN_FIELD));

    private final String cancellationStatus;

    private final String jobArn;

    private CancelJobResponse(BuilderImpl builder) {
        super(builder);
        this.cancellationStatus = builder.cancellationStatus;
        this.jobArn = builder.jobArn;
    }

    /**
     * <p>
     * The status of the job cancellation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cancellationStatus} will return {@link CancellationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #cancellationStatusAsString}.
     * </p>
     * 
     * @return The status of the job cancellation request.
     * @see CancellationStatus
     */
    public final CancellationStatus cancellationStatus() {
        return CancellationStatus.fromValue(cancellationStatus);
    }

    /**
     * <p>
     * The status of the job cancellation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cancellationStatus} will return {@link CancellationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #cancellationStatusAsString}.
     * </p>
     * 
     * @return The status of the job cancellation request.
     * @see CancellationStatus
     */
    public final String cancellationStatusAsString() {
        return cancellationStatus;
    }

    /**
     * <p>
     * The ARN of the Amazon Braket job.
     * </p>
     * 
     * @return The ARN of the Amazon Braket job.
     */
    public final String jobArn() {
        return jobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cancellationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobResponse)) {
            return false;
        }
        CancelJobResponse other = (CancelJobResponse) obj;
        return Objects.equals(cancellationStatusAsString(), other.cancellationStatusAsString())
                && Objects.equals(jobArn(), other.jobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelJobResponse").add("CancellationStatus", cancellationStatusAsString())
                .add("JobArn", jobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cancellationStatus":
            return Optional.ofNullable(clazz.cast(cancellationStatusAsString()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelJobResponse, T> g) {
        return obj -> g.apply((CancelJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelJobResponse> {
        /**
         * <p>
         * The status of the job cancellation request.
         * </p>
         * 
         * @param cancellationStatus
         *        The status of the job cancellation request.
         * @see CancellationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancellationStatus
         */
        Builder cancellationStatus(String cancellationStatus);

        /**
         * <p>
         * The status of the job cancellation request.
         * </p>
         * 
         * @param cancellationStatus
         *        The status of the job cancellation request.
         * @see CancellationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancellationStatus
         */
        Builder cancellationStatus(CancellationStatus cancellationStatus);

        /**
         * <p>
         * The ARN of the Amazon Braket job.
         * </p>
         * 
         * @param jobArn
         *        The ARN of the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private String cancellationStatus;

        private String jobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobResponse model) {
            super(model);
            cancellationStatus(model.cancellationStatus);
            jobArn(model.jobArn);
        }

        public final String getCancellationStatus() {
            return cancellationStatus;
        }

        public final void setCancellationStatus(String cancellationStatus) {
            this.cancellationStatus = cancellationStatus;
        }

        @Override
        @Transient
        public final Builder cancellationStatus(String cancellationStatus) {
            this.cancellationStatus = cancellationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder cancellationStatus(CancellationStatus cancellationStatus) {
            this.cancellationStatus(cancellationStatus == null ? null : cancellationStatus.toString());
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        @Transient
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        @Override
        public CancelJobResponse build() {
            return new CancelJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
