/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the quantum processing units (QPUs) or simulator used to create and run an Amazon Braket job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceConfig implements SdkPojo, Serializable, ToCopyableBuilder<DeviceConfig.Builder, DeviceConfig> {
    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("device")
            .getter(getter(DeviceConfig::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String device;

    private DeviceConfig(BuilderImpl builder) {
        this.device = builder.device;
    }

    /**
     * <p>
     * The primary quantum processing unit (QPU) or simulator used to create and run an Amazon Braket job.
     * </p>
     * 
     * @return The primary quantum processing unit (QPU) or simulator used to create and run an Amazon Braket job.
     */
    public final String device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceConfig)) {
            return false;
        }
        DeviceConfig other = (DeviceConfig) obj;
        return Objects.equals(device(), other.device());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceConfig").add("Device", device()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceConfig, T> g) {
        return obj -> g.apply((DeviceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceConfig> {
        /**
         * <p>
         * The primary quantum processing unit (QPU) or simulator used to create and run an Amazon Braket job.
         * </p>
         * 
         * @param device
         *        The primary quantum processing unit (QPU) or simulator used to create and run an Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);
    }

    static final class BuilderImpl implements Builder {
        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceConfig model) {
            device(model.device);
        }

        public final String getDevice() {
            return device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        @Transient
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        @Override
        public DeviceConfig build() {
            return new DeviceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
