/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchQuantumTasksResponse extends BraketResponse implements
        ToCopyableBuilder<SearchQuantumTasksResponse.Builder, SearchQuantumTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchQuantumTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<QuantumTaskSummary>> QUANTUM_TASKS_FIELD = SdkField
            .<List<QuantumTaskSummary>> builder(MarshallingType.LIST)
            .memberName("quantumTasks")
            .getter(getter(SearchQuantumTasksResponse::quantumTasks))
            .setter(setter(Builder::quantumTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuantumTaskSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuantumTaskSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            QUANTUM_TASKS_FIELD));

    private final String nextToken;

    private final List<QuantumTaskSummary> quantumTasks;

    private SearchQuantumTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quantumTasks = builder.quantumTasks;
    }

    /**
     * <p>
     * A token used for pagination of results, or null if there are no additional results. Use the token value in a
     * subsequent request to continue results where the previous request ended.
     * </p>
     * 
     * @return A token used for pagination of results, or null if there are no additional results. Use the token value
     *         in a subsequent request to continue results where the previous request ended.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the QuantumTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQuantumTasks() {
        return quantumTasks != null && !(quantumTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuantumTasks} method.
     * </p>
     * 
     * @return An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
     */
    public final List<QuantumTaskSummary> quantumTasks() {
        return quantumTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuantumTasks() ? quantumTasks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQuantumTasksResponse)) {
            return false;
        }
        SearchQuantumTasksResponse other = (SearchQuantumTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasQuantumTasks() == other.hasQuantumTasks()
                && Objects.equals(quantumTasks(), other.quantumTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchQuantumTasksResponse").add("NextToken", nextToken())
                .add("QuantumTasks", hasQuantumTasks() ? quantumTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "quantumTasks":
            return Optional.ofNullable(clazz.cast(quantumTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchQuantumTasksResponse, T> g) {
        return obj -> g.apply((SearchQuantumTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchQuantumTasksResponse> {
        /**
         * <p>
         * A token used for pagination of results, or null if there are no additional results. Use the token value in a
         * subsequent request to continue results where the previous request ended.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results, or null if there are no additional results. Use the token
         *        value in a subsequent request to continue results where the previous request ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
         * </p>
         * 
         * @param quantumTasks
         *        An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTasks(Collection<QuantumTaskSummary> quantumTasks);

        /**
         * <p>
         * An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
         * </p>
         * 
         * @param quantumTasks
         *        An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTasks(QuantumTaskSummary... quantumTasks);

        /**
         * <p>
         * An array of <code>QuantumTaskSummary</code> objects for tasks that match the specified filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QuantumTaskSummary>.Builder} avoiding the
         * need to create one manually via {@link List<QuantumTaskSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QuantumTaskSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #quantumTasks(List<QuantumTaskSummary>)}.
         * 
         * @param quantumTasks
         *        a consumer that will call methods on {@link List<QuantumTaskSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quantumTasks(List<QuantumTaskSummary>)
         */
        Builder quantumTasks(Consumer<QuantumTaskSummary.Builder>... quantumTasks);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<QuantumTaskSummary> quantumTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchQuantumTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            quantumTasks(model.quantumTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QuantumTaskSummary.Builder> getQuantumTasks() {
            List<QuantumTaskSummary.Builder> result = QuantumTaskSummaryListCopier.copyToBuilder(this.quantumTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuantumTasks(Collection<QuantumTaskSummary.BuilderImpl> quantumTasks) {
            this.quantumTasks = QuantumTaskSummaryListCopier.copyFromBuilder(quantumTasks);
        }

        @Override
        @Transient
        public final Builder quantumTasks(Collection<QuantumTaskSummary> quantumTasks) {
            this.quantumTasks = QuantumTaskSummaryListCopier.copy(quantumTasks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder quantumTasks(QuantumTaskSummary... quantumTasks) {
            quantumTasks(Arrays.asList(quantumTasks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder quantumTasks(Consumer<QuantumTaskSummary.Builder>... quantumTasks) {
            quantumTasks(Stream.of(quantumTasks).map(c -> QuantumTaskSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchQuantumTasksResponse build() {
            return new SearchQuantumTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
