/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobResponse extends BraketResponse implements ToCopyableBuilder<GetJobResponse.Builder, GetJobResponse> {
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<AlgorithmSpecification> builder(MarshallingType.SDK_POJO).memberName("algorithmSpecification")
            .getter(getter(GetJobResponse::algorithmSpecification)).setter(setter(Builder::algorithmSpecification))
            .constructor(AlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmSpecification").build())
            .build();

    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField
            .<List<Association>> builder(MarshallingType.LIST)
            .memberName("associations")
            .getter(getter(GetJobResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Association> builder(MarshallingType.SDK_POJO)
                                            .constructor(Association::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> BILLABLE_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("billableDuration").getter(getter(GetJobResponse::billableDuration))
            .setter(setter(Builder::billableDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billableDuration").build()).build();

    private static final SdkField<JobCheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField
            .<JobCheckpointConfig> builder(MarshallingType.SDK_POJO).memberName("checkpointConfig")
            .getter(getter(GetJobResponse::checkpointConfig)).setter(setter(Builder::checkpointConfig))
            .constructor(JobCheckpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkpointConfig").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DeviceConfig> DEVICE_CONFIG_FIELD = SdkField.<DeviceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("deviceConfig").getter(getter(GetJobResponse::deviceConfig)).setter(setter(Builder::deviceConfig))
            .constructor(DeviceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceConfig").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetJobResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<JobEventDetails>> EVENTS_FIELD = SdkField
            .<List<JobEventDetails>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(GetJobResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobEventDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobEventDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetJobResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperParameters")
            .getter(getter(GetJobResponse::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<InputFileConfig>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<InputFileConfig>> builder(MarshallingType.LIST)
            .memberName("inputDataConfig")
            .getter(getter(GetJobResponse::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputFileConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputFileConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceConfig> INSTANCE_CONFIG_FIELD = SdkField
            .<InstanceConfig> builder(MarshallingType.SDK_POJO).memberName("instanceConfig")
            .getter(getter(GetJobResponse::instanceConfig)).setter(setter(Builder::instanceConfig))
            .constructor(InstanceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfig").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetJobResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<JobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<JobOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(GetJobResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(JobOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<HybridJobQueueInfo> QUEUE_INFO_FIELD = SdkField
            .<HybridJobQueueInfo> builder(MarshallingType.SDK_POJO).memberName("queueInfo")
            .getter(getter(GetJobResponse::queueInfo)).setter(setter(Builder::queueInfo))
            .constructor(HybridJobQueueInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueInfo").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetJobResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<JobStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<JobStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("stoppingCondition")
            .getter(getter(GetJobResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(JobStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SPECIFICATION_FIELD,
            ASSOCIATIONS_FIELD, BILLABLE_DURATION_FIELD, CHECKPOINT_CONFIG_FIELD, CREATED_AT_FIELD, DEVICE_CONFIG_FIELD,
            ENDED_AT_FIELD, EVENTS_FIELD, FAILURE_REASON_FIELD, HYPER_PARAMETERS_FIELD, INPUT_DATA_CONFIG_FIELD,
            INSTANCE_CONFIG_FIELD, JOB_ARN_FIELD, JOB_NAME_FIELD, OUTPUT_DATA_CONFIG_FIELD, QUEUE_INFO_FIELD, ROLE_ARN_FIELD,
            STARTED_AT_FIELD, STATUS_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private final AlgorithmSpecification algorithmSpecification;

    private final List<Association> associations;

    private final Integer billableDuration;

    private final JobCheckpointConfig checkpointConfig;

    private final Instant createdAt;

    private final DeviceConfig deviceConfig;

    private final Instant endedAt;

    private final List<JobEventDetails> events;

    private final String failureReason;

    private final Map<String, String> hyperParameters;

    private final List<InputFileConfig> inputDataConfig;

    private final InstanceConfig instanceConfig;

    private final String jobArn;

    private final String jobName;

    private final JobOutputDataConfig outputDataConfig;

    private final HybridJobQueueInfo queueInfo;

    private final String roleArn;

    private final Instant startedAt;

    private final String status;

    private final JobStoppingCondition stoppingCondition;

    private final Map<String, String> tags;

    private GetJobResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmSpecification = builder.algorithmSpecification;
        this.associations = builder.associations;
        this.billableDuration = builder.billableDuration;
        this.checkpointConfig = builder.checkpointConfig;
        this.createdAt = builder.createdAt;
        this.deviceConfig = builder.deviceConfig;
        this.endedAt = builder.endedAt;
        this.events = builder.events;
        this.failureReason = builder.failureReason;
        this.hyperParameters = builder.hyperParameters;
        this.inputDataConfig = builder.inputDataConfig;
        this.instanceConfig = builder.instanceConfig;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.outputDataConfig = builder.outputDataConfig;
        this.queueInfo = builder.queueInfo;
        this.roleArn = builder.roleArn;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Definition of the Amazon Braket job created. Specifies the container image the job uses, information about the
     * Python scripts used for entry and training, and the user-defined metrics used to evaluation the job.
     * </p>
     * 
     * @return Definition of the Amazon Braket job created. Specifies the container image the job uses, information
     *         about the Python scripts used for entry and training, and the user-defined metrics used to evaluation the
     *         job.
     */
    public final AlgorithmSpecification algorithmSpecification() {
        return algorithmSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Braket resources associated with the hybrid job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return The list of Amazon Braket resources associated with the hybrid job.
     */
    public final List<Association> associations() {
        return associations;
    }

    /**
     * <p>
     * The billable time the Amazon Braket job used to complete.
     * </p>
     * 
     * @return The billable time the Amazon Braket job used to complete.
     */
    public final Integer billableDuration() {
        return billableDuration;
    }

    /**
     * <p>
     * Information about the output locations for job checkpoint data.
     * </p>
     * 
     * @return Information about the output locations for job checkpoint data.
     */
    public final JobCheckpointConfig checkpointConfig() {
        return checkpointConfig;
    }

    /**
     * <p>
     * The date and time that the Amazon Braket job was created.
     * </p>
     * 
     * @return The date and time that the Amazon Braket job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
     * </p>
     * 
     * @return The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
     */
    public final DeviceConfig deviceConfig() {
        return deviceConfig;
    }

    /**
     * <p>
     * The date and time that the Amazon Braket job ended.
     * </p>
     * 
     * @return The date and time that the Amazon Braket job ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the type and time events occurred related to the Amazon Braket job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return Details about the type and time events occurred related to the Amazon Braket job.
     */
    public final List<JobEventDetails> events() {
        return events;
    }

    /**
     * <p>
     * A description of the reason why an Amazon Braket job failed, if it failed.
     * </p>
     * 
     * @return A description of the reason why an Amazon Braket job failed, if it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the HyperParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing job. The
     * values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the
     * value is the value of th hyperparameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperParameters} method.
     * </p>
     * 
     * @return Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing job.
     *         The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter
     *         and the value is the value of th hyperparameter.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDataConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters that specify the name and type of input data and where it is located.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDataConfig} method.
     * </p>
     * 
     * @return A list of parameters that specify the name and type of input data and where it is located.
     */
    public final List<InputFileConfig> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The resource instances to use while running the hybrid job on Amazon Braket.
     * </p>
     * 
     * @return The resource instances to use while running the hybrid job on Amazon Braket.
     */
    public final InstanceConfig instanceConfig() {
        return instanceConfig;
    }

    /**
     * <p>
     * The ARN of the Amazon Braket job.
     * </p>
     * 
     * @return The ARN of the Amazon Braket job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the Amazon Braket job.
     * </p>
     * 
     * @return The name of the Amazon Braket job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The path to the S3 location where job artifacts are stored and the encryption key used to store them there.
     * </p>
     * 
     * @return The path to the S3 location where job artifacts are stored and the encryption key used to store them
     *         there.
     */
    public final JobOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * Queue information for the requested job. Only returned if <code>QueueInfo</code> is specified in the
     * <code>additionalAttributeNames"</code> field in the <code>GetJob</code> API request.
     * </p>
     * 
     * @return Queue information for the requested job. Only returned if <code>QueueInfo</code> is specified in the
     *         <code>additionalAttributeNames"</code> field in the <code>GetJob</code> API request.
     */
    public final HybridJobQueueInfo queueInfo() {
        return queueInfo;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user.
     * It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the
     * s3 buckets of a user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of
     *         a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output
     *         resources to the s3 buckets of a user.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The date and time that the Amazon Braket job was started.
     * </p>
     * 
     * @return The date and time that the Amazon Braket job was started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The status of the Amazon Braket job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobPrimaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Braket job.
     * @see JobPrimaryStatus
     */
    public final JobPrimaryStatus status() {
        return JobPrimaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Braket job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobPrimaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Braket job.
     * @see JobPrimaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The user-defined criteria that specifies when to stop a job running.
     * </p>
     * 
     * @return The user-defined criteria that specifies when to stop a job running.
     */
    public final JobStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket
     *         resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billableDuration());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobResponse)) {
            return false;
        }
        GetJobResponse other = (GetJobResponse) obj;
        return Objects.equals(algorithmSpecification(), other.algorithmSpecification())
                && hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(billableDuration(), other.billableDuration())
                && Objects.equals(checkpointConfig(), other.checkpointConfig()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deviceConfig(), other.deviceConfig()) && Objects.equals(endedAt(), other.endedAt())
                && hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && Objects.equals(failureReason(), other.failureReason()) && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(instanceConfig(), other.instanceConfig()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(queueInfo(), other.queueInfo()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(stoppingCondition(), other.stoppingCondition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobResponse").add("AlgorithmSpecification", algorithmSpecification())
                .add("Associations", hasAssociations() ? associations() : null).add("BillableDuration", billableDuration())
                .add("CheckpointConfig", checkpointConfig()).add("CreatedAt", createdAt()).add("DeviceConfig", deviceConfig())
                .add("EndedAt", endedAt()).add("Events", hasEvents() ? events() : null).add("FailureReason", failureReason())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null).add("InstanceConfig", instanceConfig())
                .add("JobArn", jobArn()).add("JobName", jobName()).add("OutputDataConfig", outputDataConfig())
                .add("QueueInfo", queueInfo()).add("RoleArn", roleArn()).add("StartedAt", startedAt())
                .add("Status", statusAsString()).add("StoppingCondition", stoppingCondition())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "algorithmSpecification":
            return Optional.ofNullable(clazz.cast(algorithmSpecification()));
        case "associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "billableDuration":
            return Optional.ofNullable(clazz.cast(billableDuration()));
        case "checkpointConfig":
            return Optional.ofNullable(clazz.cast(checkpointConfig()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deviceConfig":
            return Optional.ofNullable(clazz.cast(deviceConfig()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "hyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "inputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "instanceConfig":
            return Optional.ofNullable(clazz.cast(instanceConfig()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "queueInfo":
            return Optional.ofNullable(clazz.cast(queueInfo()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "stoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobResponse, T> g) {
        return obj -> g.apply((GetJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobResponse> {
        /**
         * <p>
         * Definition of the Amazon Braket job created. Specifies the container image the job uses, information about
         * the Python scripts used for entry and training, and the user-defined metrics used to evaluation the job.
         * </p>
         * 
         * @param algorithmSpecification
         *        Definition of the Amazon Braket job created. Specifies the container image the job uses, information
         *        about the Python scripts used for entry and training, and the user-defined metrics used to evaluation
         *        the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification);

        /**
         * <p>
         * Definition of the Amazon Braket job created. Specifies the container image the job uses, information about
         * the Python scripts used for entry and training, and the user-defined metrics used to evaluation the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlgorithmSpecification.Builder} avoiding
         * the need to create one manually via {@link AlgorithmSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlgorithmSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmSpecification(AlgorithmSpecification)}.
         * 
         * @param algorithmSpecification
         *        a consumer that will call methods on {@link AlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmSpecification(AlgorithmSpecification)
         */
        default Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return algorithmSpecification(AlgorithmSpecification.builder().applyMutation(algorithmSpecification).build());
        }

        /**
         * <p>
         * The list of Amazon Braket resources associated with the hybrid job.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<Association> associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the hybrid job.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Association... associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the hybrid job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.Association#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder#build()} is called immediately and
         * its result is passed to {@link #associations(List<Association>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.Association.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<Association>)
         */
        Builder associations(Consumer<Association.Builder>... associations);

        /**
         * <p>
         * The billable time the Amazon Braket job used to complete.
         * </p>
         * 
         * @param billableDuration
         *        The billable time the Amazon Braket job used to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billableDuration(Integer billableDuration);

        /**
         * <p>
         * Information about the output locations for job checkpoint data.
         * </p>
         * 
         * @param checkpointConfig
         *        Information about the output locations for job checkpoint data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfig(JobCheckpointConfig checkpointConfig);

        /**
         * <p>
         * Information about the output locations for job checkpoint data.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobCheckpointConfig.Builder} avoiding the
         * need to create one manually via {@link JobCheckpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobCheckpointConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #checkpointConfig(JobCheckpointConfig)}.
         * 
         * @param checkpointConfig
         *        a consumer that will call methods on {@link JobCheckpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfig(JobCheckpointConfig)
         */
        default Builder checkpointConfig(Consumer<JobCheckpointConfig.Builder> checkpointConfig) {
            return checkpointConfig(JobCheckpointConfig.builder().applyMutation(checkpointConfig).build());
        }

        /**
         * <p>
         * The date and time that the Amazon Braket job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the Amazon Braket job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
         * </p>
         * 
         * @param deviceConfig
         *        The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfig(DeviceConfig deviceConfig);

        /**
         * <p>
         * The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceConfig.Builder} avoiding the need
         * to create one manually via {@link DeviceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceConfig(DeviceConfig)}.
         * 
         * @param deviceConfig
         *        a consumer that will call methods on {@link DeviceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfig(DeviceConfig)
         */
        default Builder deviceConfig(Consumer<DeviceConfig.Builder> deviceConfig) {
            return deviceConfig(DeviceConfig.builder().applyMutation(deviceConfig).build());
        }

        /**
         * <p>
         * The date and time that the Amazon Braket job ended.
         * </p>
         * 
         * @param endedAt
         *        The date and time that the Amazon Braket job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * Details about the type and time events occurred related to the Amazon Braket job.
         * </p>
         * 
         * @param events
         *        Details about the type and time events occurred related to the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<JobEventDetails> events);

        /**
         * <p>
         * Details about the type and time events occurred related to the Amazon Braket job.
         * </p>
         * 
         * @param events
         *        Details about the type and time events occurred related to the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(JobEventDetails... events);

        /**
         * <p>
         * Details about the type and time events occurred related to the Amazon Braket job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.JobEventDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.JobEventDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.JobEventDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #events(List<JobEventDetails>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.JobEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<JobEventDetails>)
         */
        Builder events(Consumer<JobEventDetails.Builder>... events);

        /**
         * <p>
         * A description of the reason why an Amazon Braket job failed, if it failed.
         * </p>
         * 
         * @param failureReason
         *        A description of the reason why an Amazon Braket job failed, if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing job. The
         * values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the
         * value is the value of th hyperparameter.
         * </p>
         * 
         * @param hyperParameters
         *        Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing
         *        job. The values are set with a string of JSON key:value pairs, where the key is the name of the
         *        hyperparameter and the value is the value of th hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * A list of parameters that specify the name and type of input data and where it is located.
         * </p>
         * 
         * @param inputDataConfig
         *        A list of parameters that specify the name and type of input data and where it is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<InputFileConfig> inputDataConfig);

        /**
         * <p>
         * A list of parameters that specify the name and type of input data and where it is located.
         * </p>
         * 
         * @param inputDataConfig
         *        A list of parameters that specify the name and type of input data and where it is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputFileConfig... inputDataConfig);

        /**
         * <p>
         * A list of parameters that specify the name and type of input data and where it is located.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.InputFileConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.InputFileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.InputFileConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #inputDataConfig(List<InputFileConfig>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.InputFileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(java.util.Collection<InputFileConfig>)
         */
        Builder inputDataConfig(Consumer<InputFileConfig.Builder>... inputDataConfig);

        /**
         * <p>
         * The resource instances to use while running the hybrid job on Amazon Braket.
         * </p>
         * 
         * @param instanceConfig
         *        The resource instances to use while running the hybrid job on Amazon Braket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfig(InstanceConfig instanceConfig);

        /**
         * <p>
         * The resource instances to use while running the hybrid job on Amazon Braket.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConfig.Builder} avoiding the need
         * to create one manually via {@link InstanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceConfig(InstanceConfig)}.
         * 
         * @param instanceConfig
         *        a consumer that will call methods on {@link InstanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfig(InstanceConfig)
         */
        default Builder instanceConfig(Consumer<InstanceConfig.Builder> instanceConfig) {
            return instanceConfig(InstanceConfig.builder().applyMutation(instanceConfig).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Braket job.
         * </p>
         * 
         * @param jobArn
         *        The ARN of the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the Amazon Braket job.
         * </p>
         * 
         * @param jobName
         *        The name of the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The path to the S3 location where job artifacts are stored and the encryption key used to store them there.
         * </p>
         * 
         * @param outputDataConfig
         *        The path to the S3 location where job artifacts are stored and the encryption key used to store them
         *        there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(JobOutputDataConfig outputDataConfig);

        /**
         * <p>
         * The path to the S3 location where job artifacts are stored and the encryption key used to store them there.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobOutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link JobOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobOutputDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputDataConfig(JobOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link JobOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(JobOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<JobOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(JobOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * Queue information for the requested job. Only returned if <code>QueueInfo</code> is specified in the
         * <code>additionalAttributeNames"</code> field in the <code>GetJob</code> API request.
         * </p>
         * 
         * @param queueInfo
         *        Queue information for the requested job. Only returned if <code>QueueInfo</code> is specified in the
         *        <code>additionalAttributeNames"</code> field in the <code>GetJob</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueInfo(HybridJobQueueInfo queueInfo);

        /**
         * <p>
         * Queue information for the requested job. Only returned if <code>QueueInfo</code> is specified in the
         * <code>additionalAttributeNames"</code> field in the <code>GetJob</code> API request.
         * </p>
         * This is a convenience method that creates an instance of the {@link HybridJobQueueInfo.Builder} avoiding the
         * need to create one manually via {@link HybridJobQueueInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HybridJobQueueInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #queueInfo(HybridJobQueueInfo)}.
         * 
         * @param queueInfo
         *        a consumer that will call methods on {@link HybridJobQueueInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueInfo(HybridJobQueueInfo)
         */
        default Builder queueInfo(Consumer<HybridJobQueueInfo.Builder> queueInfo) {
            return queueInfo(HybridJobQueueInfo.builder().applyMutation(queueInfo).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a
         * user. It can access user resources, run an Amazon Braket job container on behalf of user, and output
         * resources to the s3 buckets of a user.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf
         *        of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and
         *        output resources to the s3 buckets of a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The date and time that the Amazon Braket job was started.
         * </p>
         * 
         * @param startedAt
         *        The date and time that the Amazon Braket job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The status of the Amazon Braket job.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Braket job.
         * @see JobPrimaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobPrimaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Braket job.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Braket job.
         * @see JobPrimaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobPrimaryStatus
         */
        Builder status(JobPrimaryStatus status);

        /**
         * <p>
         * The user-defined criteria that specifies when to stop a job running.
         * </p>
         * 
         * @param stoppingCondition
         *        The user-defined criteria that specifies when to stop a job running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(JobStoppingCondition stoppingCondition);

        /**
         * <p>
         * The user-defined criteria that specifies when to stop a job running.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link JobStoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobStoppingCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #stoppingCondition(JobStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link JobStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(JobStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<JobStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(JobStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket
         * resources.
         * </p>
         * 
         * @param tags
         *        A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private AlgorithmSpecification algorithmSpecification;

        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();

        private Integer billableDuration;

        private JobCheckpointConfig checkpointConfig;

        private Instant createdAt;

        private DeviceConfig deviceConfig;

        private Instant endedAt;

        private List<JobEventDetails> events = DefaultSdkAutoConstructList.getInstance();

        private String failureReason;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<InputFileConfig> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private InstanceConfig instanceConfig;

        private String jobArn;

        private String jobName;

        private JobOutputDataConfig outputDataConfig;

        private HybridJobQueueInfo queueInfo;

        private String roleArn;

        private Instant startedAt;

        private String status;

        private JobStoppingCondition stoppingCondition;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobResponse model) {
            super(model);
            algorithmSpecification(model.algorithmSpecification);
            associations(model.associations);
            billableDuration(model.billableDuration);
            checkpointConfig(model.checkpointConfig);
            createdAt(model.createdAt);
            deviceConfig(model.deviceConfig);
            endedAt(model.endedAt);
            events(model.events);
            failureReason(model.failureReason);
            hyperParameters(model.hyperParameters);
            inputDataConfig(model.inputDataConfig);
            instanceConfig(model.instanceConfig);
            jobArn(model.jobArn);
            jobName(model.jobName);
            outputDataConfig(model.outputDataConfig);
            queueInfo(model.queueInfo);
            roleArn(model.roleArn);
            startedAt(model.startedAt);
            status(model.status);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return algorithmSpecification != null ? algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = AssociationsCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = AssociationsCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = AssociationsCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder>... associations) {
            associations(Stream.of(associations).map(c -> Association.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getBillableDuration() {
            return billableDuration;
        }

        public final void setBillableDuration(Integer billableDuration) {
            this.billableDuration = billableDuration;
        }

        @Override
        public final Builder billableDuration(Integer billableDuration) {
            this.billableDuration = billableDuration;
            return this;
        }

        public final JobCheckpointConfig.Builder getCheckpointConfig() {
            return checkpointConfig != null ? checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(JobCheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        public final Builder checkpointConfig(JobCheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DeviceConfig.Builder getDeviceConfig() {
            return deviceConfig != null ? deviceConfig.toBuilder() : null;
        }

        public final void setDeviceConfig(DeviceConfig.BuilderImpl deviceConfig) {
            this.deviceConfig = deviceConfig != null ? deviceConfig.build() : null;
        }

        @Override
        public final Builder deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final List<JobEventDetails.Builder> getEvents() {
            List<JobEventDetails.Builder> result = JobEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<JobEventDetails.BuilderImpl> events) {
            this.events = JobEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<JobEventDetails> events) {
            this.events = JobEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(JobEventDetails... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<JobEventDetails.Builder>... events) {
            events(Stream.of(events).map(c -> JobEventDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final List<InputFileConfig.Builder> getInputDataConfig() {
            List<InputFileConfig.Builder> result = InputConfigListCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<InputFileConfig.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputConfigListCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<InputFileConfig> inputDataConfig) {
            this.inputDataConfig = InputConfigListCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(InputFileConfig... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<InputFileConfig.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> InputFileConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfig.Builder getInstanceConfig() {
            return instanceConfig != null ? instanceConfig.toBuilder() : null;
        }

        public final void setInstanceConfig(InstanceConfig.BuilderImpl instanceConfig) {
            this.instanceConfig = instanceConfig != null ? instanceConfig.build() : null;
        }

        @Override
        public final Builder instanceConfig(InstanceConfig instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(JobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(JobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final HybridJobQueueInfo.Builder getQueueInfo() {
            return queueInfo != null ? queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(HybridJobQueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(HybridJobQueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobPrimaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final JobStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(JobStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(JobStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetJobResponse build() {
            return new GetJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
