/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobRequest extends BraketRequest implements ToCopyableBuilder<GetJobRequest.Builder, GetJobRequest> {
    private static final SdkField<List<String>> ADDITIONAL_ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalAttributeNames")
            .getter(getter(GetJobRequest::additionalAttributeNamesAsStrings))
            .setter(setter(Builder::additionalAttributeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additionalAttributeNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetJobRequest::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_ATTRIBUTE_NAMES_FIELD, JOB_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> additionalAttributeNames;

    private final String jobArn;

    private GetJobRequest(BuilderImpl builder) {
        super(builder);
        this.additionalAttributeNames = builder.additionalAttributeNames;
        this.jobArn = builder.jobArn;
    }

    /**
     * <p>
     * A list of attributes to return information for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributeNames} method.
     * </p>
     * 
     * @return A list of attributes to return information for.
     */
    public final List<HybridJobAdditionalAttributeName> additionalAttributeNames() {
        return HybridJobAdditionalAttributeNamesListCopier.copyStringToEnum(additionalAttributeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributeNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalAttributeNames() {
        return additionalAttributeNames != null && !(additionalAttributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attributes to return information for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributeNames} method.
     * </p>
     * 
     * @return A list of attributes to return information for.
     */
    public final List<String> additionalAttributeNamesAsStrings() {
        return additionalAttributeNames;
    }

    /**
     * <p>
     * The ARN of the job to retrieve.
     * </p>
     * 
     * @return The ARN of the job to retrieve.
     */
    public final String jobArn() {
        return jobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributeNames() ? additionalAttributeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRequest)) {
            return false;
        }
        GetJobRequest other = (GetJobRequest) obj;
        return hasAdditionalAttributeNames() == other.hasAdditionalAttributeNames()
                && Objects.equals(additionalAttributeNamesAsStrings(), other.additionalAttributeNamesAsStrings())
                && Objects.equals(jobArn(), other.jobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobRequest")
                .add("AdditionalAttributeNames", hasAdditionalAttributeNames() ? additionalAttributeNamesAsStrings() : null)
                .add("JobArn", jobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalAttributeNames":
            return Optional.ofNullable(clazz.cast(additionalAttributeNamesAsStrings()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalAttributeNames", ADDITIONAL_ATTRIBUTE_NAMES_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobRequest, T> g) {
        return obj -> g.apply((GetJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetJobRequest> {
        /**
         * <p>
         * A list of attributes to return information for.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNamesWithStrings(Collection<String> additionalAttributeNames);

        /**
         * <p>
         * A list of attributes to return information for.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNamesWithStrings(String... additionalAttributeNames);

        /**
         * <p>
         * A list of attributes to return information for.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNames(Collection<HybridJobAdditionalAttributeName> additionalAttributeNames);

        /**
         * <p>
         * A list of attributes to return information for.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNames(HybridJobAdditionalAttributeName... additionalAttributeNames);

        /**
         * <p>
         * The ARN of the job to retrieve.
         * </p>
         * 
         * @param jobArn
         *        The ARN of the job to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BraketRequest.BuilderImpl implements Builder {
        private List<String> additionalAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private String jobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRequest model) {
            super(model);
            additionalAttributeNamesWithStrings(model.additionalAttributeNames);
            jobArn(model.jobArn);
        }

        public final Collection<String> getAdditionalAttributeNames() {
            if (additionalAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalAttributeNames;
        }

        public final void setAdditionalAttributeNames(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = HybridJobAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
        }

        @Override
        public final Builder additionalAttributeNamesWithStrings(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = HybridJobAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNamesWithStrings(String... additionalAttributeNames) {
            additionalAttributeNamesWithStrings(Arrays.asList(additionalAttributeNames));
            return this;
        }

        @Override
        public final Builder additionalAttributeNames(Collection<HybridJobAdditionalAttributeName> additionalAttributeNames) {
            this.additionalAttributeNames = HybridJobAdditionalAttributeNamesListCopier
                    .copyEnumToString(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNames(HybridJobAdditionalAttributeName... additionalAttributeNames) {
            additionalAttributeNames(Arrays.asList(additionalAttributeNames));
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJobRequest build() {
            return new GetJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
