/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes information about a quantum task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuantumTaskSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<QuantumTaskSummary.Builder, QuantumTaskSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(QuantumTaskSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(QuantumTaskSummary::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(QuantumTaskSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Bucket").getter(getter(QuantumTaskSummary::outputS3Bucket))
            .setter(setter(Builder::outputS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()).build();

    private static final SdkField<String> OUTPUT_S3_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Directory").getter(getter(QuantumTaskSummary::outputS3Directory))
            .setter(setter(Builder::outputS3Directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Directory").build()).build();

    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quantumTaskArn").getter(getter(QuantumTaskSummary::quantumTaskArn))
            .setter(setter(Builder::quantumTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTaskArn").build()).build();

    private static final SdkField<Long> SHOTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("shots")
            .getter(getter(QuantumTaskSummary::shots)).setter(setter(Builder::shots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(QuantumTaskSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(QuantumTaskSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEVICE_ARN_FIELD, ENDED_AT_FIELD, OUTPUT_S3_BUCKET_FIELD, OUTPUT_S3_DIRECTORY_FIELD, QUANTUM_TASK_ARN_FIELD,
            SHOTS_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String deviceArn;

    private final Instant endedAt;

    private final String outputS3Bucket;

    private final String outputS3Directory;

    private final String quantumTaskArn;

    private final Long shots;

    private final String status;

    private final Map<String, String> tags;

    private QuantumTaskSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deviceArn = builder.deviceArn;
        this.endedAt = builder.endedAt;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3Directory = builder.outputS3Directory;
        this.quantumTaskArn = builder.quantumTaskArn;
        this.shots = builder.shots;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time at which the task was created.
     * </p>
     * 
     * @return The time at which the task was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ARN of the device the task ran on.
     * </p>
     * 
     * @return The ARN of the device the task ran on.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The time at which the task finished.
     * </p>
     * 
     * @return The time at which the task finished.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The S3 bucket where the task result file is stored..
     * </p>
     * 
     * @return The S3 bucket where the task result file is stored..
     */
    public final String outputS3Bucket() {
        return outputS3Bucket;
    }

    /**
     * <p>
     * The folder in the S3 bucket where the task result file is stored.
     * </p>
     * 
     * @return The folder in the S3 bucket where the task result file is stored.
     */
    public final String outputS3Directory() {
        return outputS3Directory;
    }

    /**
     * <p>
     * The ARN of the task.
     * </p>
     * 
     * @return The ARN of the task.
     */
    public final String quantumTaskArn() {
        return quantumTaskArn;
    }

    /**
     * <p>
     * The shots used for the task.
     * </p>
     * 
     * @return The shots used for the task.
     */
    public final Long shots() {
        return shots;
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuantumTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task.
     * @see QuantumTaskStatus
     */
    public final QuantumTaskStatus status() {
        return QuantumTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuantumTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task.
     * @see QuantumTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Displays the key, value pairs of tags associated with this quantum task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Displays the key, value pairs of tags associated with this quantum task.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Directory());
        hashCode = 31 * hashCode + Objects.hashCode(quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(shots());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuantumTaskSummary)) {
            return false;
        }
        QuantumTaskSummary other = (QuantumTaskSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(outputS3Bucket(), other.outputS3Bucket())
                && Objects.equals(outputS3Directory(), other.outputS3Directory())
                && Objects.equals(quantumTaskArn(), other.quantumTaskArn()) && Objects.equals(shots(), other.shots())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuantumTaskSummary").add("CreatedAt", createdAt()).add("DeviceArn", deviceArn())
                .add("EndedAt", endedAt()).add("OutputS3Bucket", outputS3Bucket()).add("OutputS3Directory", outputS3Directory())
                .add("QuantumTaskArn", quantumTaskArn()).add("Shots", shots()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "outputS3Bucket":
            return Optional.ofNullable(clazz.cast(outputS3Bucket()));
        case "outputS3Directory":
            return Optional.ofNullable(clazz.cast(outputS3Directory()));
        case "quantumTaskArn":
            return Optional.ofNullable(clazz.cast(quantumTaskArn()));
        case "shots":
            return Optional.ofNullable(clazz.cast(shots()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("outputS3Bucket", OUTPUT_S3_BUCKET_FIELD);
        map.put("outputS3Directory", OUTPUT_S3_DIRECTORY_FIELD);
        map.put("quantumTaskArn", QUANTUM_TASK_ARN_FIELD);
        map.put("shots", SHOTS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuantumTaskSummary, T> g) {
        return obj -> g.apply((QuantumTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuantumTaskSummary> {
        /**
         * <p>
         * The time at which the task was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ARN of the device the task ran on.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device the task ran on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The time at which the task finished.
         * </p>
         * 
         * @param endedAt
         *        The time at which the task finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The S3 bucket where the task result file is stored..
         * </p>
         * 
         * @param outputS3Bucket
         *        The S3 bucket where the task result file is stored..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Bucket(String outputS3Bucket);

        /**
         * <p>
         * The folder in the S3 bucket where the task result file is stored.
         * </p>
         * 
         * @param outputS3Directory
         *        The folder in the S3 bucket where the task result file is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Directory(String outputS3Directory);

        /**
         * <p>
         * The ARN of the task.
         * </p>
         * 
         * @param quantumTaskArn
         *        The ARN of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTaskArn(String quantumTaskArn);

        /**
         * <p>
         * The shots used for the task.
         * </p>
         * 
         * @param shots
         *        The shots used for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shots(Long shots);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param status
         *        The status of the task.
         * @see QuantumTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuantumTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param status
         *        The status of the task.
         * @see QuantumTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuantumTaskStatus
         */
        Builder status(QuantumTaskStatus status);

        /**
         * <p>
         * Displays the key, value pairs of tags associated with this quantum task.
         * </p>
         * 
         * @param tags
         *        Displays the key, value pairs of tags associated with this quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String deviceArn;

        private Instant endedAt;

        private String outputS3Bucket;

        private String outputS3Directory;

        private String quantumTaskArn;

        private Long shots;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuantumTaskSummary model) {
            createdAt(model.createdAt);
            deviceArn(model.deviceArn);
            endedAt(model.endedAt);
            outputS3Bucket(model.outputS3Bucket);
            outputS3Directory(model.outputS3Directory);
            quantumTaskArn(model.quantumTaskArn);
            shots(model.shots);
            status(model.status);
            tags(model.tags);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getOutputS3Bucket() {
            return outputS3Bucket;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final String getOutputS3Directory() {
            return outputS3Directory;
        }

        public final void setOutputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
        }

        @Override
        public final Builder outputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
            return this;
        }

        public final String getQuantumTaskArn() {
            return quantumTaskArn;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final Long getShots() {
            return shots;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuantumTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public QuantumTaskSummary build() {
            return new QuantumTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
