/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.ContainerImage;
import software.amazon.awssdk.services.braket.model.ScriptModeConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmSpecification> {
    private static final SdkField<ContainerImage> CONTAINER_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerImage").getter(AlgorithmSpecification.getter(AlgorithmSpecification::containerImage)).setter(AlgorithmSpecification.setter(Builder::containerImage)).constructor(ContainerImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerImage").build()}).build();
    private static final SdkField<ScriptModeConfig> SCRIPT_MODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scriptModeConfig").getter(AlgorithmSpecification.getter(AlgorithmSpecification::scriptModeConfig)).setter(AlgorithmSpecification.setter(Builder::scriptModeConfig)).constructor(ScriptModeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptModeConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_IMAGE_FIELD, SCRIPT_MODE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlgorithmSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContainerImage containerImage;
    private final ScriptModeConfig scriptModeConfig;

    private AlgorithmSpecification(BuilderImpl builder) {
        this.containerImage = builder.containerImage;
        this.scriptModeConfig = builder.scriptModeConfig;
    }

    public final ContainerImage containerImage() {
        return this.containerImage;
    }

    public final ScriptModeConfig scriptModeConfig() {
        return this.scriptModeConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptModeConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSpecification)) {
            return false;
        }
        AlgorithmSpecification other = (AlgorithmSpecification)obj;
        return Objects.equals(this.containerImage(), other.containerImage()) && Objects.equals(this.scriptModeConfig(), other.scriptModeConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AlgorithmSpecification").add("ContainerImage", (Object)this.containerImage()).add("ScriptModeConfig", (Object)this.scriptModeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerImage": {
                return Optional.ofNullable(clazz.cast(this.containerImage()));
            }
            case "scriptModeConfig": {
                return Optional.ofNullable(clazz.cast(this.scriptModeConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containerImage", CONTAINER_IMAGE_FIELD);
        map.put("scriptModeConfig", SCRIPT_MODE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmSpecification, T> g) {
        return obj -> g.apply((AlgorithmSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContainerImage containerImage;
        private ScriptModeConfig scriptModeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSpecification model) {
            this.containerImage(model.containerImage);
            this.scriptModeConfig(model.scriptModeConfig);
        }

        public final ContainerImage.Builder getContainerImage() {
            return this.containerImage != null ? this.containerImage.toBuilder() : null;
        }

        public final void setContainerImage(ContainerImage.BuilderImpl containerImage) {
            this.containerImage = containerImage != null ? containerImage.build() : null;
        }

        @Override
        public final Builder containerImage(ContainerImage containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        public final ScriptModeConfig.Builder getScriptModeConfig() {
            return this.scriptModeConfig != null ? this.scriptModeConfig.toBuilder() : null;
        }

        public final void setScriptModeConfig(ScriptModeConfig.BuilderImpl scriptModeConfig) {
            this.scriptModeConfig = scriptModeConfig != null ? scriptModeConfig.build() : null;
        }

        @Override
        public final Builder scriptModeConfig(ScriptModeConfig scriptModeConfig) {
            this.scriptModeConfig = scriptModeConfig;
            return this;
        }

        public AlgorithmSpecification build() {
            return new AlgorithmSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmSpecification> {
        public Builder containerImage(ContainerImage var1);

        default public Builder containerImage(Consumer<ContainerImage.Builder> containerImage) {
            return this.containerImage((ContainerImage)((ContainerImage.Builder)ContainerImage.builder().applyMutation(containerImage)).build());
        }

        public Builder scriptModeConfig(ScriptModeConfig var1);

        default public Builder scriptModeConfig(Consumer<ScriptModeConfig.Builder> scriptModeConfig) {
            return this.scriptModeConfig((ScriptModeConfig)((ScriptModeConfig.Builder)ScriptModeConfig.builder().applyMutation(scriptModeConfig)).build());
        }
    }
}

