/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.services.braket.model.HybridJobAdditionalAttributeName;
import software.amazon.awssdk.services.braket.model.HybridJobAdditionalAttributeNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, GetJobRequest> {
    private static final SdkField<List<String>> ADDITIONAL_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalAttributeNames").getter(GetJobRequest.getter(GetJobRequest::additionalAttributeNamesAsStrings)).setter(GetJobRequest.setter(Builder::additionalAttributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additionalAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetJobRequest.getter(GetJobRequest::jobArn)).setter(GetJobRequest.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTE_NAMES_FIELD, JOB_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetJobRequest.memberNameToFieldInitializer();
    private final List<String> additionalAttributeNames;
    private final String jobArn;

    private GetJobRequest(BuilderImpl builder) {
        super(builder);
        this.additionalAttributeNames = builder.additionalAttributeNames;
        this.jobArn = builder.jobArn;
    }

    public final List<HybridJobAdditionalAttributeName> additionalAttributeNames() {
        return HybridJobAdditionalAttributeNamesListCopier.copyStringToEnum(this.additionalAttributeNames);
    }

    public final boolean hasAdditionalAttributeNames() {
        return this.additionalAttributeNames != null && !(this.additionalAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> additionalAttributeNamesAsStrings() {
        return this.additionalAttributeNames;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributeNames() ? this.additionalAttributeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRequest)) {
            return false;
        }
        GetJobRequest other = (GetJobRequest)((Object)obj);
        return this.hasAdditionalAttributeNames() == other.hasAdditionalAttributeNames() && Objects.equals(this.additionalAttributeNamesAsStrings(), other.additionalAttributeNamesAsStrings()) && Objects.equals(this.jobArn(), other.jobArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetJobRequest").add("AdditionalAttributeNames", this.hasAdditionalAttributeNames() ? this.additionalAttributeNamesAsStrings() : null).add("JobArn", (Object)this.jobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributeNamesAsStrings()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalAttributeNames", ADDITIONAL_ATTRIBUTE_NAMES_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobRequest, T> g) {
        return obj -> g.apply((GetJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private List<String> additionalAttributeNames = DefaultSdkAutoConstructList.getInstance();
        private String jobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRequest model) {
            super(model);
            this.additionalAttributeNamesWithStrings(model.additionalAttributeNames);
            this.jobArn(model.jobArn);
        }

        public final Collection<String> getAdditionalAttributeNames() {
            if (this.additionalAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalAttributeNames;
        }

        public final void setAdditionalAttributeNames(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = HybridJobAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
        }

        @Override
        public final Builder additionalAttributeNamesWithStrings(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = HybridJobAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNamesWithStrings(String ... additionalAttributeNames) {
            this.additionalAttributeNamesWithStrings(Arrays.asList(additionalAttributeNames));
            return this;
        }

        @Override
        public final Builder additionalAttributeNames(Collection<HybridJobAdditionalAttributeName> additionalAttributeNames) {
            this.additionalAttributeNames = HybridJobAdditionalAttributeNamesListCopier.copyEnumToString(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNames(HybridJobAdditionalAttributeName ... additionalAttributeNames) {
            this.additionalAttributeNames(Arrays.asList(additionalAttributeNames));
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJobRequest build() {
            return new GetJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobRequest> {
        public Builder additionalAttributeNamesWithStrings(Collection<String> var1);

        public Builder additionalAttributeNamesWithStrings(String ... var1);

        public Builder additionalAttributeNames(Collection<HybridJobAdditionalAttributeName> var1);

        public Builder additionalAttributeNames(HybridJobAdditionalAttributeName ... var1);

        public Builder jobArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

