/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionMetadata> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(ActionMetadata.getter(ActionMetadata::actionType)).setter(ActionMetadata.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<Long> PROGRAM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("programCount").getter(ActionMetadata.getter(ActionMetadata::programCount)).setter(ActionMetadata.setter(Builder::programCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programCount").build()}).build();
    private static final SdkField<Long> EXECUTABLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executableCount").getter(ActionMetadata.getter(ActionMetadata::executableCount)).setter(ActionMetadata.setter(Builder::executableCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executableCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, PROGRAM_COUNT_FIELD, EXECUTABLE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final Long programCount;
    private final Long executableCount;

    private ActionMetadata(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.programCount = builder.programCount;
        this.executableCount = builder.executableCount;
    }

    public final String actionType() {
        return this.actionType;
    }

    public final Long programCount() {
        return this.programCount;
    }

    public final Long executableCount() {
        return this.executableCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.programCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.executableCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionMetadata)) {
            return false;
        }
        ActionMetadata other = (ActionMetadata)obj;
        return Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.programCount(), other.programCount()) && Objects.equals(this.executableCount(), other.executableCount());
    }

    public final String toString() {
        return ToString.builder((String)"ActionMetadata").add("ActionType", (Object)this.actionType()).add("ProgramCount", (Object)this.programCount()).add("ExecutableCount", (Object)this.executableCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
            case "programCount": {
                return Optional.ofNullable(clazz.cast(this.programCount()));
            }
            case "executableCount": {
                return Optional.ofNullable(clazz.cast(this.executableCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("programCount", PROGRAM_COUNT_FIELD);
        map.put("executableCount", EXECUTABLE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionMetadata, T> g) {
        return obj -> g.apply((ActionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private Long programCount;
        private Long executableCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionMetadata model) {
            this.actionType(model.actionType);
            this.programCount(model.programCount);
            this.executableCount(model.executableCount);
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final Long getProgramCount() {
            return this.programCount;
        }

        public final void setProgramCount(Long programCount) {
            this.programCount = programCount;
        }

        @Override
        public final Builder programCount(Long programCount) {
            this.programCount = programCount;
            return this;
        }

        public final Long getExecutableCount() {
            return this.executableCount;
        }

        public final void setExecutableCount(Long executableCount) {
            this.executableCount = executableCount;
        }

        @Override
        public final Builder executableCount(Long executableCount) {
            this.executableCount = executableCount;
            return this;
        }

        public ActionMetadata build() {
            return new ActionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionMetadata> {
        public Builder actionType(String var1);

        public Builder programCount(Long var1);

        public Builder executableCount(Long var1);
    }
}

