/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.ProgramValidationFailuresListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProgramSetValidationFailure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProgramSetValidationFailure> {
    private static final SdkField<Long> PROGRAM_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("programIndex").getter(ProgramSetValidationFailure.getter(ProgramSetValidationFailure::programIndex)).setter(ProgramSetValidationFailure.setter(Builder::programIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programIndex").build()}).build();
    private static final SdkField<Long> INPUTS_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("inputsIndex").getter(ProgramSetValidationFailure.getter(ProgramSetValidationFailure::inputsIndex)).setter(ProgramSetValidationFailure.setter(Builder::inputsIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputsIndex").build()}).build();
    private static final SdkField<List<String>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(ProgramSetValidationFailure.getter(ProgramSetValidationFailure::errors)).setter(ProgramSetValidationFailure.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAM_INDEX_FIELD, INPUTS_INDEX_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProgramSetValidationFailure.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long programIndex;
    private final Long inputsIndex;
    private final List<String> errors;

    private ProgramSetValidationFailure(BuilderImpl builder) {
        this.programIndex = builder.programIndex;
        this.inputsIndex = builder.inputsIndex;
        this.errors = builder.errors;
    }

    public final Long programIndex() {
        return this.programIndex;
    }

    public final Long inputsIndex() {
        return this.inputsIndex;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<String> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.programIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputsIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramSetValidationFailure)) {
            return false;
        }
        ProgramSetValidationFailure other = (ProgramSetValidationFailure)obj;
        return Objects.equals(this.programIndex(), other.programIndex()) && Objects.equals(this.inputsIndex(), other.inputsIndex()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"ProgramSetValidationFailure").add("ProgramIndex", (Object)this.programIndex()).add("InputsIndex", (Object)this.inputsIndex()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "programIndex": {
                return Optional.ofNullable(clazz.cast(this.programIndex()));
            }
            case "inputsIndex": {
                return Optional.ofNullable(clazz.cast(this.inputsIndex()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("programIndex", PROGRAM_INDEX_FIELD);
        map.put("inputsIndex", INPUTS_INDEX_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramSetValidationFailure, T> g) {
        return obj -> g.apply((ProgramSetValidationFailure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long programIndex;
        private Long inputsIndex;
        private List<String> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramSetValidationFailure model) {
            this.programIndex(model.programIndex);
            this.inputsIndex(model.inputsIndex);
            this.errors(model.errors);
        }

        public final Long getProgramIndex() {
            return this.programIndex;
        }

        public final void setProgramIndex(Long programIndex) {
            this.programIndex = programIndex;
        }

        @Override
        public final Builder programIndex(Long programIndex) {
            this.programIndex = programIndex;
            return this;
        }

        public final Long getInputsIndex() {
            return this.inputsIndex;
        }

        public final void setInputsIndex(Long inputsIndex) {
            this.inputsIndex = inputsIndex;
        }

        @Override
        public final Builder inputsIndex(Long inputsIndex) {
            this.inputsIndex = inputsIndex;
            return this;
        }

        public final Collection<String> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = ProgramValidationFailuresListCopier.copy(errors);
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = ProgramValidationFailuresListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        public ProgramSetValidationFailure build() {
            return new ProgramSetValidationFailure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProgramSetValidationFailure> {
        public Builder programIndex(Long var1);

        public Builder inputsIndex(Long var1);

        public Builder errors(Collection<String> var1);

        public Builder errors(String ... var1);
    }
}

