/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.services.braket.model.QuantumTaskAdditionalAttributeName;
import software.amazon.awssdk.services.braket.model.QuantumTaskAdditionalAttributeNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQuantumTaskRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, GetQuantumTaskRequest> {
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quantumTaskArn").getter(GetQuantumTaskRequest.getter(GetQuantumTaskRequest::quantumTaskArn)).setter(GetQuantumTaskRequest.setter(Builder::quantumTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("quantumTaskArn").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalAttributeNames").getter(GetQuantumTaskRequest.getter(GetQuantumTaskRequest::additionalAttributeNamesAsStrings)).setter(GetQuantumTaskRequest.setter(Builder::additionalAttributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additionalAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTUM_TASK_ARN_FIELD, ADDITIONAL_ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQuantumTaskRequest.memberNameToFieldInitializer();
    private final String quantumTaskArn;
    private final List<String> additionalAttributeNames;

    private GetQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.quantumTaskArn = builder.quantumTaskArn;
        this.additionalAttributeNames = builder.additionalAttributeNames;
    }

    public final String quantumTaskArn() {
        return this.quantumTaskArn;
    }

    public final List<QuantumTaskAdditionalAttributeName> additionalAttributeNames() {
        return QuantumTaskAdditionalAttributeNamesListCopier.copyStringToEnum(this.additionalAttributeNames);
    }

    public final boolean hasAdditionalAttributeNames() {
        return this.additionalAttributeNames != null && !(this.additionalAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> additionalAttributeNamesAsStrings() {
        return this.additionalAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributeNames() ? this.additionalAttributeNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuantumTaskRequest)) {
            return false;
        }
        GetQuantumTaskRequest other = (GetQuantumTaskRequest)((Object)obj);
        return Objects.equals(this.quantumTaskArn(), other.quantumTaskArn()) && this.hasAdditionalAttributeNames() == other.hasAdditionalAttributeNames() && Objects.equals(this.additionalAttributeNamesAsStrings(), other.additionalAttributeNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetQuantumTaskRequest").add("QuantumTaskArn", (Object)this.quantumTaskArn()).add("AdditionalAttributeNames", this.hasAdditionalAttributeNames() ? this.additionalAttributeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "quantumTaskArn": {
                return Optional.ofNullable(clazz.cast(this.quantumTaskArn()));
            }
            case "additionalAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("quantumTaskArn", QUANTUM_TASK_ARN_FIELD);
        map.put("additionalAttributeNames", ADDITIONAL_ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQuantumTaskRequest, T> g) {
        return obj -> g.apply((GetQuantumTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private String quantumTaskArn;
        private List<String> additionalAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuantumTaskRequest model) {
            super(model);
            this.quantumTaskArn(model.quantumTaskArn);
            this.additionalAttributeNamesWithStrings(model.additionalAttributeNames);
        }

        public final String getQuantumTaskArn() {
            return this.quantumTaskArn;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final Collection<String> getAdditionalAttributeNames() {
            if (this.additionalAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalAttributeNames;
        }

        public final void setAdditionalAttributeNames(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = QuantumTaskAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
        }

        @Override
        public final Builder additionalAttributeNamesWithStrings(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = QuantumTaskAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNamesWithStrings(String ... additionalAttributeNames) {
            this.additionalAttributeNamesWithStrings(Arrays.asList(additionalAttributeNames));
            return this;
        }

        @Override
        public final Builder additionalAttributeNames(Collection<QuantumTaskAdditionalAttributeName> additionalAttributeNames) {
            this.additionalAttributeNames = QuantumTaskAdditionalAttributeNamesListCopier.copyEnumToString(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNames(QuantumTaskAdditionalAttributeName ... additionalAttributeNames) {
            this.additionalAttributeNames(Arrays.asList(additionalAttributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQuantumTaskRequest build() {
            return new GetQuantumTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQuantumTaskRequest> {
        public Builder quantumTaskArn(String var1);

        public Builder additionalAttributeNamesWithStrings(Collection<String> var1);

        public Builder additionalAttributeNamesWithStrings(String ... var1);

        public Builder additionalAttributeNames(Collection<QuantumTaskAdditionalAttributeName> var1);

        public Builder additionalAttributeNames(QuantumTaskAdditionalAttributeName ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

