/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.braket.model.AccessDeniedException;
import software.amazon.awssdk.services.braket.model.BraketException;
import software.amazon.awssdk.services.braket.model.CancelJobRequest;
import software.amazon.awssdk.services.braket.model.CancelJobResponse;
import software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.ConflictException;
import software.amazon.awssdk.services.braket.model.CreateJobRequest;
import software.amazon.awssdk.services.braket.model.CreateJobResponse;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.DeviceOfflineException;
import software.amazon.awssdk.services.braket.model.DeviceRetiredException;
import software.amazon.awssdk.services.braket.model.GetDeviceRequest;
import software.amazon.awssdk.services.braket.model.GetDeviceResponse;
import software.amazon.awssdk.services.braket.model.GetJobRequest;
import software.amazon.awssdk.services.braket.model.GetJobResponse;
import software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.GetQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.InternalServiceException;
import software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.braket.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.braket.model.ResourceNotFoundException;
import software.amazon.awssdk.services.braket.model.SearchDevicesRequest;
import software.amazon.awssdk.services.braket.model.SearchDevicesResponse;
import software.amazon.awssdk.services.braket.model.SearchJobsRequest;
import software.amazon.awssdk.services.braket.model.SearchJobsResponse;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse;
import software.amazon.awssdk.services.braket.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.braket.model.TagResourceRequest;
import software.amazon.awssdk.services.braket.model.TagResourceResponse;
import software.amazon.awssdk.services.braket.model.ThrottlingException;
import software.amazon.awssdk.services.braket.model.UntagResourceRequest;
import software.amazon.awssdk.services.braket.model.UntagResourceResponse;
import software.amazon.awssdk.services.braket.model.ValidationException;
import software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable;
import software.amazon.awssdk.services.braket.paginators.SearchJobsIterable;
import software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable;

/**
 * Service client for accessing Braket. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amazon Braket API Reference provides information about the operations and structures supported by Amazon Braket.
 * </p>
 * <p>
 * To learn about the permissions required to call an Amazon Braket API action, see <a
 * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbraket.html">Actions, resources,
 * and condition keys for Amazon Braket</a>. <a
 * href="https://amazon-braket-sdk-python.readthedocs.io/en/latest/#">Amazon Braket Python SDK</a> and the <a
 * href="https://docs.aws.amazon.com/cli/latest/reference/braket/">AWS Command Line Interface</a> can be used to make
 * discovery and creation of API calls easier. For more information about Amazon Braket features, see <a
 * href="https://docs.aws.amazon.com/braket/latest/developerguide/what-is-braket.html">What is Amazon Braket?</a> and
 * important <a href="https://docs.aws.amazon.com/braket/latest/developerguide/braket-terms.html">terms and concepts</a>
 * in the <i>Amazon Braket Developer Guide</i>.
 * </p>
 * <p>
 * <b>In this guide:</b>
 * </p>
 * <ul>
 * <li>
 * <p/></li>
 * <li>
 * <p/></li>
 * <li>
 * <p>
 * <a>CommonParameters</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CommonErrors</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Available languages for AWS SDK:</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sdkfornet/v3/apidocs/items/Braket/NBraket.html">.NET</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://sdk.amazonaws.com/cpp/api/LATEST/root/html/index.html">C++</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sdk-for-go/api/service/braket/">Go API reference</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/braket/package-summary.html">
 * Java</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Braket.html">JavaScript</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/aws-sdk-php/v3/api/class-Aws.Braket.BraketClient.html">PHP</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/braket.html">Python (Boto)</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sdk-for-ruby/v3/api/Aws/Braket.html">Ruby</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Code examples from the Amazon Braket Tutorials GitHub repository:</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://github.com/amazon-braket/amazon-braket-examples">Amazon Braket Examples</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BraketClient extends AwsClient {
    String SERVICE_NAME = "braket";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "braket";

    /**
     * <p>
     * Cancels an Amazon Braket hybrid job.
     * </p>
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an Amazon Braket hybrid job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.CancelJobRequest.Builder} to create a request.
     * @return Result of the CancelJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified task.
     * </p>
     *
     * @param cancelQuantumTaskRequest
     * @return Result of the CancelQuantumTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CancelQuantumTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CancelQuantumTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelQuantumTaskResponse cancelQuantumTask(CancelQuantumTaskRequest cancelQuantumTaskRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelQuantumTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelQuantumTaskRequest#builder()}
     * </p>
     *
     * @param cancelQuantumTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest.Builder} to create a request.
     * @return Result of the CancelQuantumTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CancelQuantumTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CancelQuantumTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelQuantumTaskResponse cancelQuantumTask(Consumer<CancelQuantumTaskRequest.Builder> cancelQuantumTaskRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return cancelQuantumTask(CancelQuantumTaskRequest.builder().applyMutation(cancelQuantumTaskRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Braket hybrid job.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws DeviceOfflineException
     *         The specified device is currently offline.
     * @throws DeviceRetiredException
     *         The specified device has been retired.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws ConflictException, AccessDeniedException,
            ThrottlingException, DeviceOfflineException, DeviceRetiredException, ServiceQuotaExceededException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Braket hybrid job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.CreateJobRequest.Builder} to create a request.
     * @return Result of the CreateJob operation returned by the service.
     * @throws ConflictException
     *         An error occurred due to a conflict.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws DeviceOfflineException
     *         The specified device is currently offline.
     * @throws DeviceRetiredException
     *         The specified device has been retired.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws ConflictException,
            AccessDeniedException, ThrottlingException, DeviceOfflineException, DeviceRetiredException,
            ServiceQuotaExceededException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates a quantum task.
     * </p>
     *
     * @param createQuantumTaskRequest
     * @return Result of the CreateQuantumTask operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws DeviceOfflineException
     *         The specified device is currently offline.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws DeviceRetiredException
     *         The specified device has been retired.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CreateQuantumTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CreateQuantumTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQuantumTaskResponse createQuantumTask(CreateQuantumTaskRequest createQuantumTaskRequest)
            throws AccessDeniedException, DeviceOfflineException, ThrottlingException, DeviceRetiredException,
            ServiceQuotaExceededException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a quantum task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuantumTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CreateQuantumTaskRequest#builder()}
     * </p>
     *
     * @param createQuantumTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest.Builder} to create a request.
     * @return Result of the CreateQuantumTask operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws DeviceOfflineException
     *         The specified device is currently offline.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws DeviceRetiredException
     *         The specified device has been retired.
     * @throws ServiceQuotaExceededException
     *         The request failed because a service quota is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.CreateQuantumTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CreateQuantumTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQuantumTaskResponse createQuantumTask(Consumer<CreateQuantumTaskRequest.Builder> createQuantumTaskRequest)
            throws AccessDeniedException, DeviceOfflineException, ThrottlingException, DeviceRetiredException,
            ServiceQuotaExceededException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        return createQuantumTask(CreateQuantumTaskRequest.builder().applyMutation(createQuantumTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves the devices available in Amazon Braket.
     * </p>
     * <note>
     * <p>
     * For backwards compatibility with older versions of BraketSchemas, OpenQASM information is omitted from GetDevice
     * API calls. To get this information the user-agent needs to present a recent version of the BraketSchemas (1.8.0
     * or later). The Braket SDK automatically reports this for you. If you do not see OpenQASM results in the GetDevice
     * response when using a Braket SDK, you may need to set AWS_EXECUTION_ENV environment variable to configure
     * user-agent. See the code examples provided below for how to do this for the AWS CLI, Boto3, and the Go, Java, and
     * JavaScript/TypeScript SDKs.
     * </p>
     * </note>
     *
     * @param getDeviceRequest
     * @return Result of the GetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the devices available in Amazon Braket.
     * </p>
     * <note>
     * <p>
     * For backwards compatibility with older versions of BraketSchemas, OpenQASM information is omitted from GetDevice
     * API calls. To get this information the user-agent needs to present a recent version of the BraketSchemas (1.8.0
     * or later). The Braket SDK automatically reports this for you. If you do not see OpenQASM results in the GetDevice
     * response when using a Braket SDK, you may need to set AWS_EXECUTION_ENV environment variable to configure
     * user-agent. See the code examples provided below for how to do this for the AWS CLI, Boto3, and the Go, Java, and
     * JavaScript/TypeScript SDKs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.GetDeviceRequest.Builder} to create a request.
     * @return Result of the GetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified Amazon Braket hybrid job.
     * </p>
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException,
            BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified Amazon Braket hybrid job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.GetJobRequest.Builder} to create a request.
     * @return Result of the GetJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified quantum task.
     * </p>
     *
     * @param getQuantumTaskRequest
     * @return Result of the GetQuantumTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.GetQuantumTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetQuantumTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQuantumTaskResponse getQuantumTask(GetQuantumTaskRequest getQuantumTaskRequest) throws ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified quantum task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQuantumTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetQuantumTaskRequest#builder()}
     * </p>
     *
     * @param getQuantumTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest.Builder} to create a request.
     * @return Result of the GetQuantumTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.GetQuantumTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetQuantumTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQuantumTaskResponse getQuantumTask(Consumer<GetQuantumTaskRequest.Builder> getQuantumTaskRequest)
            throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException,
            ValidationException, AwsServiceException, SdkClientException, BraketException {
        return getQuantumTask(GetQuantumTaskRequest.builder().applyMutation(getQuantumTaskRequest).build());
    }

    /**
     * <p>
     * Shows the tags associated with this resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows the tags associated with this resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Searches for devices using the specified filters.
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchDevicesResponse searchDevices(SearchDevicesRequest searchDevicesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException,
            BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for devices using the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchDevicesRequest#builder()}
     * </p>
     *
     * @param searchDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.SearchDevicesRequest.Builder} to create a request.
     * @return Result of the SearchDevices operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchDevicesResponse searchDevices(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        return searchDevices(SearchDevicesRequest.builder().applyMutation(searchDevicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchDevices(software.amazon.awssdk.services.braket.model.SearchDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.braket.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.braket.model.SearchDevicesRequest)} operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchDevicesIterable searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException,
            BraketException {
        return new SearchDevicesIterable(this, searchDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchDevices(software.amazon.awssdk.services.braket.model.SearchDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.braket.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.braket.model.SearchDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchDevicesRequest#builder()}
     * </p>
     *
     * @param searchDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.SearchDevicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchDevicesIterable searchDevicesPaginator(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        return searchDevicesPaginator(SearchDevicesRequest.builder().applyMutation(searchDevicesRequest).build());
    }

    /**
     * <p>
     * Searches for Amazon Braket hybrid jobs that match the specified filter values.
     * </p>
     *
     * @param searchJobsRequest
     * @return Result of the SearchJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchJobsResponse searchJobs(SearchJobsRequest searchJobsRequest) throws AccessDeniedException, ThrottlingException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for Amazon Braket hybrid jobs that match the specified filter values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchJobsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchJobsRequest#builder()}
     * </p>
     *
     * @param searchJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.SearchJobsRequest.Builder} to create a request.
     * @return Result of the SearchJobs operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchJobsResponse searchJobs(Consumer<SearchJobsRequest.Builder> searchJobsRequest) throws AccessDeniedException,
            ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException,
            BraketException {
        return searchJobs(SearchJobsRequest.builder().applyMutation(searchJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchJobs(software.amazon.awssdk.services.braket.model.SearchJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchJobsIterable responses = client.searchJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.braket.paginators.SearchJobsIterable responses = client.searchJobsPaginator(request);
     *     for (software.amazon.awssdk.services.braket.model.SearchJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchJobsIterable responses = client.searchJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchJobs(software.amazon.awssdk.services.braket.model.SearchJobsRequest)} operation.</b>
     * </p>
     *
     * @param searchJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchJobsIterable searchJobsPaginator(SearchJobsRequest searchJobsRequest) throws AccessDeniedException,
            ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException,
            BraketException {
        return new SearchJobsIterable(this, searchJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchJobs(software.amazon.awssdk.services.braket.model.SearchJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchJobsIterable responses = client.searchJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.braket.paginators.SearchJobsIterable responses = client.searchJobsPaginator(request);
     *     for (software.amazon.awssdk.services.braket.model.SearchJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchJobsIterable responses = client.searchJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchJobs(software.amazon.awssdk.services.braket.model.SearchJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchJobsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchJobsRequest#builder()}
     * </p>
     *
     * @param searchJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.SearchJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchJobsIterable searchJobsPaginator(Consumer<SearchJobsRequest.Builder> searchJobsRequest)
            throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        return searchJobsPaginator(SearchJobsRequest.builder().applyMutation(searchJobsRequest).build());
    }

    /**
     * <p>
     * Searches for tasks that match the specified filter values.
     * </p>
     *
     * @param searchQuantumTasksRequest
     * @return Result of the SearchQuantumTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchQuantumTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchQuantumTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchQuantumTasksResponse searchQuantumTasks(SearchQuantumTasksRequest searchQuantumTasksRequest)
            throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for tasks that match the specified filter values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchQuantumTasksRequest.Builder} avoiding the
     * need to create one manually via {@link SearchQuantumTasksRequest#builder()}
     * </p>
     *
     * @param searchQuantumTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest.Builder} to create a
     *        request.
     * @return Result of the SearchQuantumTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchQuantumTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchQuantumTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchQuantumTasksResponse searchQuantumTasks(Consumer<SearchQuantumTasksRequest.Builder> searchQuantumTasksRequest)
            throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        return searchQuantumTasks(SearchQuantumTasksRequest.builder().applyMutation(searchQuantumTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchQuantumTasks(software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable responses = client.searchQuantumTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable responses = client
     *             .searchQuantumTasksPaginator(request);
     *     for (software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable responses = client.searchQuantumTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchQuantumTasks(software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchQuantumTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchQuantumTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchQuantumTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchQuantumTasksIterable searchQuantumTasksPaginator(SearchQuantumTasksRequest searchQuantumTasksRequest)
            throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException,
            AwsServiceException, SdkClientException, BraketException {
        return new SearchQuantumTasksIterable(this, searchQuantumTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchQuantumTasks(software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable responses = client.searchQuantumTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable responses = client
     *             .searchQuantumTasksPaginator(request);
     *     for (software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable responses = client.searchQuantumTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchQuantumTasks(software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchQuantumTasksRequest.Builder} avoiding the
     * need to create one manually via {@link SearchQuantumTasksRequest#builder()}
     * </p>
     *
     * @param searchQuantumTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The API throttling rate limit is exceeded.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.SearchQuantumTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchQuantumTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchQuantumTasksIterable searchQuantumTasksPaginator(
            Consumer<SearchQuantumTasksRequest.Builder> searchQuantumTasksRequest) throws AccessDeniedException,
            ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException,
            BraketException {
        return searchQuantumTasksPaginator(SearchQuantumTasksRequest.builder().applyMutation(searchQuantumTasksRequest).build());
    }

    /**
     * <p>
     * Add a tag to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a tag to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.braket.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         The request failed because of an unknown error.
     * @throws ValidationException
     *         The input request failed to satisfy constraints expected by Amazon Braket.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BraketException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BraketClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException,
            SdkClientException, BraketException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link BraketClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BraketClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BraketClient}.
     */
    static BraketClientBuilder builder() {
        return new DefaultBraketClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BraketServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
