/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about the quantum task action, including the action type and program statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionMetadata implements SdkPojo, Serializable, ToCopyableBuilder<ActionMetadata.Builder, ActionMetadata> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(ActionMetadata::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<Long> PROGRAM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("programCount").getter(getter(ActionMetadata::programCount)).setter(setter(Builder::programCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programCount").build()).build();

    private static final SdkField<Long> EXECUTABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("executableCount").getter(getter(ActionMetadata::executableCount))
            .setter(setter(Builder::executableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executableCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            PROGRAM_COUNT_FIELD, EXECUTABLE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final Long programCount;

    private final Long executableCount;

    private ActionMetadata(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.programCount = builder.programCount;
        this.executableCount = builder.executableCount;
    }

    /**
     * <p>
     * The type of action associated with the quantum task.
     * </p>
     * 
     * @return The type of action associated with the quantum task.
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * <p>
     * The number of programs in a program set. This is only available for a program set.
     * </p>
     * 
     * @return The number of programs in a program set. This is only available for a program set.
     */
    public final Long programCount() {
        return programCount;
    }

    /**
     * <p>
     * The number of executables in a program set. This is only available for a program set.
     * </p>
     * 
     * @return The number of executables in a program set. This is only available for a program set.
     */
    public final Long executableCount() {
        return executableCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(programCount());
        hashCode = 31 * hashCode + Objects.hashCode(executableCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionMetadata)) {
            return false;
        }
        ActionMetadata other = (ActionMetadata) obj;
        return Objects.equals(actionType(), other.actionType()) && Objects.equals(programCount(), other.programCount())
                && Objects.equals(executableCount(), other.executableCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionMetadata").add("ActionType", actionType()).add("ProgramCount", programCount())
                .add("ExecutableCount", executableCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "programCount":
            return Optional.ofNullable(clazz.cast(programCount()));
        case "executableCount":
            return Optional.ofNullable(clazz.cast(executableCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("programCount", PROGRAM_COUNT_FIELD);
        map.put("executableCount", EXECUTABLE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionMetadata, T> g) {
        return obj -> g.apply((ActionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionMetadata> {
        /**
         * <p>
         * The type of action associated with the quantum task.
         * </p>
         * 
         * @param actionType
         *        The type of action associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The number of programs in a program set. This is only available for a program set.
         * </p>
         * 
         * @param programCount
         *        The number of programs in a program set. This is only available for a program set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programCount(Long programCount);

        /**
         * <p>
         * The number of executables in a program set. This is only available for a program set.
         * </p>
         * 
         * @param executableCount
         *        The number of executables in a program set. This is only available for a program set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executableCount(Long executableCount);
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private Long programCount;

        private Long executableCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionMetadata model) {
            actionType(model.actionType);
            programCount(model.programCount);
            executableCount(model.executableCount);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final Long getProgramCount() {
            return programCount;
        }

        public final void setProgramCount(Long programCount) {
            this.programCount = programCount;
        }

        @Override
        public final Builder programCount(Long programCount) {
            this.programCount = programCount;
            return this;
        }

        public final Long getExecutableCount() {
            return executableCount;
        }

        public final void setExecutableCount(Long executableCount) {
            this.executableCount = executableCount;
        }

        @Override
        public final Builder executableCount(Long executableCount) {
            this.executableCount = executableCount;
            return this;
        }

        @Override
        public ActionMetadata build() {
            return new ActionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
