/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelQuantumTaskRequest extends BraketRequest implements
        ToCopyableBuilder<CancelQuantumTaskRequest.Builder, CancelQuantumTaskRequest> {
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quantumTaskArn").getter(getter(CancelQuantumTaskRequest::quantumTaskArn))
            .setter(setter(Builder::quantumTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("quantumTaskArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CancelQuantumTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTUM_TASK_ARN_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String quantumTaskArn;

    private final String clientToken;

    private CancelQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.quantumTaskArn = builder.quantumTaskArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ARN of the quantum task to cancel.
     * </p>
     * 
     * @return The ARN of the quantum task to cancel.
     */
    public final String quantumTaskArn() {
        return quantumTaskArn;
    }

    /**
     * <p>
     * The client token associated with the cancellation request.
     * </p>
     * 
     * @return The client token associated with the cancellation request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelQuantumTaskRequest)) {
            return false;
        }
        CancelQuantumTaskRequest other = (CancelQuantumTaskRequest) obj;
        return Objects.equals(quantumTaskArn(), other.quantumTaskArn()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelQuantumTaskRequest").add("QuantumTaskArn", quantumTaskArn())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "quantumTaskArn":
            return Optional.ofNullable(clazz.cast(quantumTaskArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("quantumTaskArn", QUANTUM_TASK_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelQuantumTaskRequest, T> g) {
        return obj -> g.apply((CancelQuantumTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BraketRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelQuantumTaskRequest> {
        /**
         * <p>
         * The ARN of the quantum task to cancel.
         * </p>
         * 
         * @param quantumTaskArn
         *        The ARN of the quantum task to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTaskArn(String quantumTaskArn);

        /**
         * <p>
         * The client token associated with the cancellation request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the cancellation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BraketRequest.BuilderImpl implements Builder {
        private String quantumTaskArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelQuantumTaskRequest model) {
            super(model);
            quantumTaskArn(model.quantumTaskArn);
            clientToken(model.clientToken);
        }

        public final String getQuantumTaskArn() {
            return quantumTaskArn;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelQuantumTaskRequest build() {
            return new CancelQuantumTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
