/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQuantumTaskRequest extends BraketRequest implements
        ToCopyableBuilder<CreateQuantumTaskRequest.Builder, CreateQuantumTaskRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateQuantumTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(CreateQuantumTaskRequest::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceParameters")
            .getter(getter(CreateQuantumTaskRequest::deviceParameters))
            .setter(setter(Builder::deviceParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Long> SHOTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("shots")
            .getter(getter(CreateQuantumTaskRequest::shots)).setter(setter(Builder::shots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Bucket").getter(getter(CreateQuantumTaskRequest::outputS3Bucket))
            .setter(setter(Builder::outputS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()).build();

    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3KeyPrefix").getter(getter(CreateQuantumTaskRequest::outputS3KeyPrefix))
            .setter(setter(Builder::outputS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3KeyPrefix").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("action")
            .getter(getter(CreateQuantumTaskRequest::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateQuantumTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> JOB_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobToken").getter(getter(CreateQuantumTaskRequest::jobToken)).setter(setter(Builder::jobToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobToken").build()).build();

    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField
            .<List<Association>> builder(MarshallingType.LIST)
            .memberName("associations")
            .getter(getter(CreateQuantumTaskRequest::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Association> builder(MarshallingType.SDK_POJO)
                                            .constructor(Association::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExperimentalCapabilities> EXPERIMENTAL_CAPABILITIES_FIELD = SdkField
            .<ExperimentalCapabilities> builder(MarshallingType.SDK_POJO).memberName("experimentalCapabilities")
            .getter(getter(CreateQuantumTaskRequest::experimentalCapabilities)).setter(setter(Builder::experimentalCapabilities))
            .constructor(ExperimentalCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentalCapabilities").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, SHOTS_FIELD, OUTPUT_S3_BUCKET_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD,
            ACTION_FIELD, TAGS_FIELD, JOB_TOKEN_FIELD, ASSOCIATIONS_FIELD, EXPERIMENTAL_CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String deviceArn;

    private final String deviceParameters;

    private final Long shots;

    private final String outputS3Bucket;

    private final String outputS3KeyPrefix;

    private final String action;

    private final Map<String, String> tags;

    private final String jobToken;

    private final List<Association> associations;

    private final ExperimentalCapabilities experimentalCapabilities;

    private CreateQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.shots = builder.shots;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.action = builder.action;
        this.tags = builder.tags;
        this.jobToken = builder.jobToken;
        this.associations = builder.associations;
        this.experimentalCapabilities = builder.experimentalCapabilities;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN of the device to run the quantum task on.
     * </p>
     * 
     * @return The ARN of the device to run the quantum task on.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The parameters for the device to run the quantum task on.
     * </p>
     * 
     * @return The parameters for the device to run the quantum task on.
     */
    public final String deviceParameters() {
        return deviceParameters;
    }

    /**
     * <p>
     * The number of shots to use for the quantum task.
     * </p>
     * 
     * @return The number of shots to use for the quantum task.
     */
    public final Long shots() {
        return shots;
    }

    /**
     * <p>
     * The S3 bucket to store quantum task result files in.
     * </p>
     * 
     * @return The S3 bucket to store quantum task result files in.
     */
    public final String outputS3Bucket() {
        return outputS3Bucket;
    }

    /**
     * <p>
     * The key prefix for the location in the S3 bucket to store quantum task results in.
     * </p>
     * 
     * @return The key prefix for the location in the S3 bucket to store quantum task results in.
     */
    public final String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * The action associated with the quantum task.
     * </p>
     * 
     * @return The action associated with the quantum task.
     */
    public final String action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to be added to the quantum task you're creating.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be added to the quantum task you're creating.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The token for an Amazon Braket hybrid job that associates it with the quantum task.
     * </p>
     * 
     * @return The token for an Amazon Braket hybrid job that associates it with the quantum task.
     */
    public final String jobToken() {
        return jobToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Braket resources associated with the quantum task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return The list of Amazon Braket resources associated with the quantum task.
     */
    public final List<Association> associations() {
        return associations;
    }

    /**
     * <p>
     * Enable experimental capabilities for the quantum task.
     * </p>
     * 
     * @return Enable experimental capabilities for the quantum task.
     */
    public final ExperimentalCapabilities experimentalCapabilities() {
        return experimentalCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(shots());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(experimentalCapabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuantumTaskRequest)) {
            return false;
        }
        CreateQuantumTaskRequest other = (CreateQuantumTaskRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(deviceParameters(), other.deviceParameters()) && Objects.equals(shots(), other.shots())
                && Objects.equals(outputS3Bucket(), other.outputS3Bucket())
                && Objects.equals(outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(action(), other.action())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(jobToken(), other.jobToken()) && hasAssociations() == other.hasAssociations()
                && Objects.equals(associations(), other.associations())
                && Objects.equals(experimentalCapabilities(), other.experimentalCapabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQuantumTaskRequest").add("ClientToken", clientToken()).add("DeviceArn", deviceArn())
                .add("DeviceParameters", deviceParameters()).add("Shots", shots()).add("OutputS3Bucket", outputS3Bucket())
                .add("OutputS3KeyPrefix", outputS3KeyPrefix()).add("Action", action()).add("Tags", hasTags() ? tags() : null)
                .add("JobToken", jobToken()).add("Associations", hasAssociations() ? associations() : null)
                .add("ExperimentalCapabilities", experimentalCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "deviceParameters":
            return Optional.ofNullable(clazz.cast(deviceParameters()));
        case "shots":
            return Optional.ofNullable(clazz.cast(shots()));
        case "outputS3Bucket":
            return Optional.ofNullable(clazz.cast(outputS3Bucket()));
        case "outputS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(outputS3KeyPrefix()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "jobToken":
            return Optional.ofNullable(clazz.cast(jobToken()));
        case "associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "experimentalCapabilities":
            return Optional.ofNullable(clazz.cast(experimentalCapabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("deviceParameters", DEVICE_PARAMETERS_FIELD);
        map.put("shots", SHOTS_FIELD);
        map.put("outputS3Bucket", OUTPUT_S3_BUCKET_FIELD);
        map.put("outputS3KeyPrefix", OUTPUT_S3_KEY_PREFIX_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("jobToken", JOB_TOKEN_FIELD);
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("experimentalCapabilities", EXPERIMENTAL_CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateQuantumTaskRequest, T> g) {
        return obj -> g.apply((CreateQuantumTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BraketRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQuantumTaskRequest> {
        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN of the device to run the quantum task on.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to run the quantum task on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The parameters for the device to run the quantum task on.
         * </p>
         * 
         * @param deviceParameters
         *        The parameters for the device to run the quantum task on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceParameters(String deviceParameters);

        /**
         * <p>
         * The number of shots to use for the quantum task.
         * </p>
         * 
         * @param shots
         *        The number of shots to use for the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shots(Long shots);

        /**
         * <p>
         * The S3 bucket to store quantum task result files in.
         * </p>
         * 
         * @param outputS3Bucket
         *        The S3 bucket to store quantum task result files in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Bucket(String outputS3Bucket);

        /**
         * <p>
         * The key prefix for the location in the S3 bucket to store quantum task results in.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The key prefix for the location in the S3 bucket to store quantum task results in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * The action associated with the quantum task.
         * </p>
         * 
         * @param action
         *        The action associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Tags to be added to the quantum task you're creating.
         * </p>
         * 
         * @param tags
         *        Tags to be added to the quantum task you're creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The token for an Amazon Braket hybrid job that associates it with the quantum task.
         * </p>
         * 
         * @param jobToken
         *        The token for an Amazon Braket hybrid job that associates it with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobToken(String jobToken);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the quantum task.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<Association> associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the quantum task.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Association... associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the quantum task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.Association#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder#build()} is called immediately and
         * its result is passed to {@link #associations(List<Association>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.Association.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<Association>)
         */
        Builder associations(Consumer<Association.Builder>... associations);

        /**
         * <p>
         * Enable experimental capabilities for the quantum task.
         * </p>
         * 
         * @param experimentalCapabilities
         *        Enable experimental capabilities for the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentalCapabilities(ExperimentalCapabilities experimentalCapabilities);

        /**
         * <p>
         * Enable experimental capabilities for the quantum task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentalCapabilities.Builder}
         * avoiding the need to create one manually via {@link ExperimentalCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentalCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #experimentalCapabilities(ExperimentalCapabilities)}.
         * 
         * @param experimentalCapabilities
         *        a consumer that will call methods on {@link ExperimentalCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentalCapabilities(ExperimentalCapabilities)
         */
        default Builder experimentalCapabilities(Consumer<ExperimentalCapabilities.Builder> experimentalCapabilities) {
            return experimentalCapabilities(ExperimentalCapabilities.builder().applyMutation(experimentalCapabilities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BraketRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String deviceArn;

        private String deviceParameters;

        private Long shots;

        private String outputS3Bucket;

        private String outputS3KeyPrefix;

        private String action;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String jobToken;

        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();

        private ExperimentalCapabilities experimentalCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuantumTaskRequest model) {
            super(model);
            clientToken(model.clientToken);
            deviceArn(model.deviceArn);
            deviceParameters(model.deviceParameters);
            shots(model.shots);
            outputS3Bucket(model.outputS3Bucket);
            outputS3KeyPrefix(model.outputS3KeyPrefix);
            action(model.action);
            tags(model.tags);
            jobToken(model.jobToken);
            associations(model.associations);
            experimentalCapabilities(model.experimentalCapabilities);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceParameters() {
            return deviceParameters;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final Long getShots() {
            return shots;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final String getOutputS3Bucket() {
            return outputS3Bucket;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getJobToken() {
            return jobToken;
        }

        public final void setJobToken(String jobToken) {
            this.jobToken = jobToken;
        }

        @Override
        public final Builder jobToken(String jobToken) {
            this.jobToken = jobToken;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = CreateQuantumTaskRequestAssociationsListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = CreateQuantumTaskRequestAssociationsListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = CreateQuantumTaskRequestAssociationsListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder>... associations) {
            associations(Stream.of(associations).map(c -> Association.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ExperimentalCapabilities.Builder getExperimentalCapabilities() {
            return experimentalCapabilities != null ? experimentalCapabilities.toBuilder() : null;
        }

        public final void setExperimentalCapabilities(ExperimentalCapabilities.BuilderImpl experimentalCapabilities) {
            this.experimentalCapabilities = experimentalCapabilities != null ? experimentalCapabilities.build() : null;
        }

        @Override
        public final Builder experimentalCapabilities(ExperimentalCapabilities experimentalCapabilities) {
            this.experimentalCapabilities = experimentalCapabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuantumTaskRequest build() {
            return new CreateQuantumTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
