/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enabled experimental capabilities for quantum hardware. Note that the use of these features may impact device
 * capabilities and performance beyond its standard specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentalCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentalCapabilities.Builder, ExperimentalCapabilities> {
    private static final SdkField<String> ENABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("enabled")
            .getter(getter(ExperimentalCapabilities::enabledAsString)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String enabled;

    private final Type type;

    private ExperimentalCapabilities(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.type = builder.type;
    }

    /**
     * <p>
     * Enabled experimental capabilities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enabled} will
     * return {@link ExperimentalCapabilitiesEnablementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #enabledAsString}.
     * </p>
     * 
     * @return Enabled experimental capabilities.
     * @see ExperimentalCapabilitiesEnablementType
     */
    public final ExperimentalCapabilitiesEnablementType enabled() {
        return ExperimentalCapabilitiesEnablementType.fromValue(enabled);
    }

    /**
     * <p>
     * Enabled experimental capabilities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enabled} will
     * return {@link ExperimentalCapabilitiesEnablementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #enabledAsString}.
     * </p>
     * 
     * @return Enabled experimental capabilities.
     * @see ExperimentalCapabilitiesEnablementType
     */
    public final String enabledAsString() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabledAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentalCapabilities)) {
            return false;
        }
        ExperimentalCapabilities other = (ExperimentalCapabilities) obj;
        return Objects.equals(enabledAsString(), other.enabledAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentalCapabilities").add("Enabled", enabledAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabledAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #enabledAsString()} initialized to the given value.
     *
     * <p>
     * Enabled experimental capabilities.
     * </p>
     * 
     * @param enabled
     *        Enabled experimental capabilities.
     * @see ExperimentalCapabilitiesEnablementType
     */
    public static ExperimentalCapabilities fromEnabled(String enabled) {
        return builder().enabled(enabled).build();
    }

    /**
     * Create an instance of this class with {@link #enabledAsString()} initialized to the given value.
     *
     * <p>
     * Enabled experimental capabilities.
     * </p>
     * 
     * @param enabled
     *        Enabled experimental capabilities.
     * @see ExperimentalCapabilitiesEnablementType
     */
    public static ExperimentalCapabilities fromEnabled(ExperimentalCapabilitiesEnablementType enabled) {
        return builder().enabled(enabled).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentalCapabilities, T> g) {
        return obj -> g.apply((ExperimentalCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentalCapabilities> {
        /**
         * <p>
         * Enabled experimental capabilities.
         * </p>
         * 
         * @param enabled
         *        Enabled experimental capabilities.
         * @see ExperimentalCapabilitiesEnablementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentalCapabilitiesEnablementType
         */
        Builder enabled(String enabled);

        /**
         * <p>
         * Enabled experimental capabilities.
         * </p>
         * 
         * @param enabled
         *        Enabled experimental capabilities.
         * @see ExperimentalCapabilitiesEnablementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentalCapabilitiesEnablementType
         */
        Builder enabled(ExperimentalCapabilitiesEnablementType enabled);
    }

    static final class BuilderImpl implements Builder {
        private String enabled;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentalCapabilities model) {
            enabled(model.enabled);
        }

        public final String getEnabled() {
            return enabled;
        }

        public final void setEnabled(String enabled) {
            Object oldValue = this.enabled;
            this.enabled = enabled;
            handleUnionValueChange(Type.ENABLED, oldValue, this.enabled);
        }

        @Override
        public final Builder enabled(String enabled) {
            Object oldValue = this.enabled;
            this.enabled = enabled;
            handleUnionValueChange(Type.ENABLED, oldValue, this.enabled);
            return this;
        }

        @Override
        public final Builder enabled(ExperimentalCapabilitiesEnablementType enabled) {
            this.enabled(enabled == null ? null : enabled.toString());
            return this;
        }

        @Override
        public ExperimentalCapabilities build() {
            return new ExperimentalCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ExperimentalCapabilities#type()
     */
    public enum Type {
        ENABLED,

        UNKNOWN_TO_SDK_VERSION
    }
}
