/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceResponse extends BraketResponse implements
        ToCopyableBuilder<GetDeviceResponse.Builder, GetDeviceResponse> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(GetDeviceResponse::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceName").getter(getter(GetDeviceResponse::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(GetDeviceResponse::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceType").getter(getter(GetDeviceResponse::deviceTypeAsString)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()).build();

    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceStatus").getter(getter(GetDeviceResponse::deviceStatusAsString))
            .setter(setter(Builder::deviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceStatus").build()).build();

    private static final SdkField<String> DEVICE_CAPABILITIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceCapabilities")
            .getter(getter(GetDeviceResponse::deviceCapabilities))
            .setter(setter(Builder::deviceCapabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCapabilities").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<List<DeviceQueueInfo>> DEVICE_QUEUE_INFO_FIELD = SdkField
            .<List<DeviceQueueInfo>> builder(MarshallingType.LIST)
            .memberName("deviceQueueInfo")
            .getter(getter(GetDeviceResponse::deviceQueueInfo))
            .setter(setter(Builder::deviceQueueInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceQueueInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceQueueInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceQueueInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD,
            DEVICE_NAME_FIELD, PROVIDER_NAME_FIELD, DEVICE_TYPE_FIELD, DEVICE_STATUS_FIELD, DEVICE_CAPABILITIES_FIELD,
            DEVICE_QUEUE_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deviceArn;

    private final String deviceName;

    private final String providerName;

    private final String deviceType;

    private final String deviceStatus;

    private final String deviceCapabilities;

    private final List<DeviceQueueInfo> deviceQueueInfo;

    private GetDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceName = builder.deviceName;
        this.providerName = builder.providerName;
        this.deviceType = builder.deviceType;
        this.deviceStatus = builder.deviceStatus;
        this.deviceCapabilities = builder.deviceCapabilities;
        this.deviceQueueInfo = builder.deviceQueueInfo;
    }

    /**
     * <p>
     * The ARN of the device.
     * </p>
     * 
     * @return The ARN of the device.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The name of the device.
     * </p>
     * 
     * @return The name of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The name of the partner company for the device.
     * </p>
     * 
     * @return The name of the partner company for the device.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The type of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The type of the device.
     * @see DeviceType
     */
    public final DeviceType deviceType() {
        return DeviceType.fromValue(deviceType);
    }

    /**
     * <p>
     * The type of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The type of the device.
     * @see DeviceType
     */
    public final String deviceTypeAsString() {
        return deviceType;
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public final DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(deviceStatus);
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public final String deviceStatusAsString() {
        return deviceStatus;
    }

    /**
     * <p>
     * Details about the capabilities of the device.
     * </p>
     * 
     * @return Details about the capabilities of the device.
     */
    public final String deviceCapabilities() {
        return deviceCapabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceQueueInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceQueueInfo() {
        return deviceQueueInfo != null && !(deviceQueueInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of quantum tasks and hybrid jobs currently queued on the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceQueueInfo} method.
     * </p>
     * 
     * @return The number of quantum tasks and hybrid jobs currently queued on the device.
     */
    public final List<DeviceQueueInfo> deviceQueueInfo() {
        return deviceQueueInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceQueueInfo() ? deviceQueueInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(providerName(), other.providerName())
                && Objects.equals(deviceTypeAsString(), other.deviceTypeAsString())
                && Objects.equals(deviceStatusAsString(), other.deviceStatusAsString())
                && Objects.equals(deviceCapabilities(), other.deviceCapabilities())
                && hasDeviceQueueInfo() == other.hasDeviceQueueInfo()
                && Objects.equals(deviceQueueInfo(), other.deviceQueueInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceResponse").add("DeviceArn", deviceArn()).add("DeviceName", deviceName())
                .add("ProviderName", providerName()).add("DeviceType", deviceTypeAsString())
                .add("DeviceStatus", deviceStatusAsString()).add("DeviceCapabilities", deviceCapabilities())
                .add("DeviceQueueInfo", hasDeviceQueueInfo() ? deviceQueueInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "deviceType":
            return Optional.ofNullable(clazz.cast(deviceTypeAsString()));
        case "deviceStatus":
            return Optional.ofNullable(clazz.cast(deviceStatusAsString()));
        case "deviceCapabilities":
            return Optional.ofNullable(clazz.cast(deviceCapabilities()));
        case "deviceQueueInfo":
            return Optional.ofNullable(clazz.cast(deviceQueueInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("deviceName", DEVICE_NAME_FIELD);
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("deviceType", DEVICE_TYPE_FIELD);
        map.put("deviceStatus", DEVICE_STATUS_FIELD);
        map.put("deviceCapabilities", DEVICE_CAPABILITIES_FIELD);
        map.put("deviceQueueInfo", DEVICE_QUEUE_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceResponse, T> g) {
        return obj -> g.apply((GetDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeviceResponse> {
        /**
         * <p>
         * The ARN of the device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The name of the device.
         * </p>
         * 
         * @param deviceName
         *        The name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The name of the partner company for the device.
         * </p>
         * 
         * @param providerName
         *        The name of the partner company for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The type of the device.
         * </p>
         * 
         * @param deviceType
         *        The type of the device.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The type of the device.
         * </p>
         * 
         * @param deviceType
         *        The type of the device.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(DeviceType deviceType);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(String deviceStatus);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param deviceStatus
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(DeviceStatus deviceStatus);

        /**
         * <p>
         * Details about the capabilities of the device.
         * </p>
         * 
         * @param deviceCapabilities
         *        Details about the capabilities of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCapabilities(String deviceCapabilities);

        /**
         * <p>
         * The number of quantum tasks and hybrid jobs currently queued on the device.
         * </p>
         * 
         * @param deviceQueueInfo
         *        The number of quantum tasks and hybrid jobs currently queued on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceQueueInfo(Collection<DeviceQueueInfo> deviceQueueInfo);

        /**
         * <p>
         * The number of quantum tasks and hybrid jobs currently queued on the device.
         * </p>
         * 
         * @param deviceQueueInfo
         *        The number of quantum tasks and hybrid jobs currently queued on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceQueueInfo(DeviceQueueInfo... deviceQueueInfo);

        /**
         * <p>
         * The number of quantum tasks and hybrid jobs currently queued on the device.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.DeviceQueueInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.DeviceQueueInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.DeviceQueueInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceQueueInfo(List<DeviceQueueInfo>)}.
         * 
         * @param deviceQueueInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.DeviceQueueInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceQueueInfo(java.util.Collection<DeviceQueueInfo>)
         */
        Builder deviceQueueInfo(Consumer<DeviceQueueInfo.Builder>... deviceQueueInfo);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceName;

        private String providerName;

        private String deviceType;

        private String deviceStatus;

        private String deviceCapabilities;

        private List<DeviceQueueInfo> deviceQueueInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            super(model);
            deviceArn(model.deviceArn);
            deviceName(model.deviceName);
            providerName(model.providerName);
            deviceType(model.deviceType);
            deviceStatus(model.deviceStatus);
            deviceCapabilities(model.deviceCapabilities);
            deviceQueueInfo(model.deviceQueueInfo);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final String getDeviceStatus() {
            return deviceStatus;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        public final String getDeviceCapabilities() {
            return deviceCapabilities;
        }

        public final void setDeviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
        }

        @Override
        public final Builder deviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
            return this;
        }

        public final List<DeviceQueueInfo.Builder> getDeviceQueueInfo() {
            List<DeviceQueueInfo.Builder> result = DeviceQueueInfoListCopier.copyToBuilder(this.deviceQueueInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceQueueInfo(Collection<DeviceQueueInfo.BuilderImpl> deviceQueueInfo) {
            this.deviceQueueInfo = DeviceQueueInfoListCopier.copyFromBuilder(deviceQueueInfo);
        }

        @Override
        public final Builder deviceQueueInfo(Collection<DeviceQueueInfo> deviceQueueInfo) {
            this.deviceQueueInfo = DeviceQueueInfoListCopier.copy(deviceQueueInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceQueueInfo(DeviceQueueInfo... deviceQueueInfo) {
            deviceQueueInfo(Arrays.asList(deviceQueueInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceQueueInfo(Consumer<DeviceQueueInfo.Builder>... deviceQueueInfo) {
            deviceQueueInfo(Stream.of(deviceQueueInfo).map(c -> DeviceQueueInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
