/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQuantumTaskRequest extends BraketRequest implements
        ToCopyableBuilder<GetQuantumTaskRequest.Builder, GetQuantumTaskRequest> {
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quantumTaskArn").getter(getter(GetQuantumTaskRequest::quantumTaskArn))
            .setter(setter(Builder::quantumTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("quantumTaskArn").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalAttributeNames")
            .getter(getter(GetQuantumTaskRequest::additionalAttributeNamesAsStrings))
            .setter(setter(Builder::additionalAttributeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("additionalAttributeNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTUM_TASK_ARN_FIELD,
            ADDITIONAL_ATTRIBUTE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String quantumTaskArn;

    private final List<String> additionalAttributeNames;

    private GetQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.quantumTaskArn = builder.quantumTaskArn;
        this.additionalAttributeNames = builder.additionalAttributeNames;
    }

    /**
     * <p>
     * The ARN of the quantum task to retrieve.
     * </p>
     * 
     * @return The ARN of the quantum task to retrieve.
     */
    public final String quantumTaskArn() {
        return quantumTaskArn;
    }

    /**
     * <p>
     * A list of attributes to return additional information for. Only the QueueInfo additional attribute name is
     * currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributeNames} method.
     * </p>
     * 
     * @return A list of attributes to return additional information for. Only the QueueInfo additional attribute name
     *         is currently supported.
     */
    public final List<QuantumTaskAdditionalAttributeName> additionalAttributeNames() {
        return QuantumTaskAdditionalAttributeNamesListCopier.copyStringToEnum(additionalAttributeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributeNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalAttributeNames() {
        return additionalAttributeNames != null && !(additionalAttributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attributes to return additional information for. Only the QueueInfo additional attribute name is
     * currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributeNames} method.
     * </p>
     * 
     * @return A list of attributes to return additional information for. Only the QueueInfo additional attribute name
     *         is currently supported.
     */
    public final List<String> additionalAttributeNamesAsStrings() {
        return additionalAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributeNames() ? additionalAttributeNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuantumTaskRequest)) {
            return false;
        }
        GetQuantumTaskRequest other = (GetQuantumTaskRequest) obj;
        return Objects.equals(quantumTaskArn(), other.quantumTaskArn())
                && hasAdditionalAttributeNames() == other.hasAdditionalAttributeNames()
                && Objects.equals(additionalAttributeNamesAsStrings(), other.additionalAttributeNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQuantumTaskRequest").add("QuantumTaskArn", quantumTaskArn())
                .add("AdditionalAttributeNames", hasAdditionalAttributeNames() ? additionalAttributeNamesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "quantumTaskArn":
            return Optional.ofNullable(clazz.cast(quantumTaskArn()));
        case "additionalAttributeNames":
            return Optional.ofNullable(clazz.cast(additionalAttributeNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("quantumTaskArn", QUANTUM_TASK_ARN_FIELD);
        map.put("additionalAttributeNames", ADDITIONAL_ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQuantumTaskRequest, T> g) {
        return obj -> g.apply((GetQuantumTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BraketRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetQuantumTaskRequest> {
        /**
         * <p>
         * The ARN of the quantum task to retrieve.
         * </p>
         * 
         * @param quantumTaskArn
         *        The ARN of the quantum task to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTaskArn(String quantumTaskArn);

        /**
         * <p>
         * A list of attributes to return additional information for. Only the QueueInfo additional attribute name is
         * currently supported.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return additional information for. Only the QueueInfo additional attribute
         *        name is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNamesWithStrings(Collection<String> additionalAttributeNames);

        /**
         * <p>
         * A list of attributes to return additional information for. Only the QueueInfo additional attribute name is
         * currently supported.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return additional information for. Only the QueueInfo additional attribute
         *        name is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNamesWithStrings(String... additionalAttributeNames);

        /**
         * <p>
         * A list of attributes to return additional information for. Only the QueueInfo additional attribute name is
         * currently supported.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return additional information for. Only the QueueInfo additional attribute
         *        name is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNames(Collection<QuantumTaskAdditionalAttributeName> additionalAttributeNames);

        /**
         * <p>
         * A list of attributes to return additional information for. Only the QueueInfo additional attribute name is
         * currently supported.
         * </p>
         * 
         * @param additionalAttributeNames
         *        A list of attributes to return additional information for. Only the QueueInfo additional attribute
         *        name is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributeNames(QuantumTaskAdditionalAttributeName... additionalAttributeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BraketRequest.BuilderImpl implements Builder {
        private String quantumTaskArn;

        private List<String> additionalAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuantumTaskRequest model) {
            super(model);
            quantumTaskArn(model.quantumTaskArn);
            additionalAttributeNamesWithStrings(model.additionalAttributeNames);
        }

        public final String getQuantumTaskArn() {
            return quantumTaskArn;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final Collection<String> getAdditionalAttributeNames() {
            if (additionalAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalAttributeNames;
        }

        public final void setAdditionalAttributeNames(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = QuantumTaskAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
        }

        @Override
        public final Builder additionalAttributeNamesWithStrings(Collection<String> additionalAttributeNames) {
            this.additionalAttributeNames = QuantumTaskAdditionalAttributeNamesListCopier.copy(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNamesWithStrings(String... additionalAttributeNames) {
            additionalAttributeNamesWithStrings(Arrays.asList(additionalAttributeNames));
            return this;
        }

        @Override
        public final Builder additionalAttributeNames(Collection<QuantumTaskAdditionalAttributeName> additionalAttributeNames) {
            this.additionalAttributeNames = QuantumTaskAdditionalAttributeNamesListCopier
                    .copyEnumToString(additionalAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributeNames(QuantumTaskAdditionalAttributeName... additionalAttributeNames) {
            additionalAttributeNames(Arrays.asList(additionalAttributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQuantumTaskRequest build() {
            return new GetQuantumTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
