/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQuantumTaskResponse extends BraketResponse implements
        ToCopyableBuilder<GetQuantumTaskResponse.Builder, GetQuantumTaskResponse> {
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quantumTaskArn").getter(getter(GetQuantumTaskResponse::quantumTaskArn))
            .setter(setter(Builder::quantumTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTaskArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQuantumTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetQuantumTaskResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(GetQuantumTaskResponse::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceParameters")
            .getter(getter(GetQuantumTaskResponse::deviceParameters))
            .setter(setter(Builder::deviceParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Long> SHOTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("shots")
            .getter(getter(GetQuantumTaskResponse::shots)).setter(setter(Builder::shots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Bucket").getter(getter(GetQuantumTaskResponse::outputS3Bucket))
            .setter(setter(Builder::outputS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()).build();

    private static final SdkField<String> OUTPUT_S3_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Directory").getter(getter(GetQuantumTaskResponse::outputS3Directory))
            .setter(setter(Builder::outputS3Directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Directory").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetQuantumTaskResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetQuantumTaskResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetQuantumTaskResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetQuantumTaskResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<QuantumTaskQueueInfo> QUEUE_INFO_FIELD = SdkField
            .<QuantumTaskQueueInfo> builder(MarshallingType.SDK_POJO).memberName("queueInfo")
            .getter(getter(GetQuantumTaskResponse::queueInfo)).setter(setter(Builder::queueInfo))
            .constructor(QuantumTaskQueueInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueInfo").build()).build();

    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField
            .<List<Association>> builder(MarshallingType.LIST)
            .memberName("associations")
            .getter(getter(GetQuantumTaskResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Association> builder(MarshallingType.SDK_POJO)
                                            .constructor(Association::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> NUM_SUCCESSFUL_SHOTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numSuccessfulShots").getter(getter(GetQuantumTaskResponse::numSuccessfulShots))
            .setter(setter(Builder::numSuccessfulShots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numSuccessfulShots").build())
            .build();

    private static final SdkField<ActionMetadata> ACTION_METADATA_FIELD = SdkField
            .<ActionMetadata> builder(MarshallingType.SDK_POJO).memberName("actionMetadata")
            .getter(getter(GetQuantumTaskResponse::actionMetadata)).setter(setter(Builder::actionMetadata))
            .constructor(ActionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionMetadata").build()).build();

    private static final SdkField<ExperimentalCapabilities> EXPERIMENTAL_CAPABILITIES_FIELD = SdkField
            .<ExperimentalCapabilities> builder(MarshallingType.SDK_POJO).memberName("experimentalCapabilities")
            .getter(getter(GetQuantumTaskResponse::experimentalCapabilities)).setter(setter(Builder::experimentalCapabilities))
            .constructor(ExperimentalCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentalCapabilities").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTUM_TASK_ARN_FIELD,
            STATUS_FIELD, FAILURE_REASON_FIELD, DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, SHOTS_FIELD, OUTPUT_S3_BUCKET_FIELD,
            OUTPUT_S3_DIRECTORY_FIELD, CREATED_AT_FIELD, ENDED_AT_FIELD, TAGS_FIELD, JOB_ARN_FIELD, QUEUE_INFO_FIELD,
            ASSOCIATIONS_FIELD, NUM_SUCCESSFUL_SHOTS_FIELD, ACTION_METADATA_FIELD, EXPERIMENTAL_CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String quantumTaskArn;

    private final String status;

    private final String failureReason;

    private final String deviceArn;

    private final String deviceParameters;

    private final Long shots;

    private final String outputS3Bucket;

    private final String outputS3Directory;

    private final Instant createdAt;

    private final Instant endedAt;

    private final Map<String, String> tags;

    private final String jobArn;

    private final QuantumTaskQueueInfo queueInfo;

    private final List<Association> associations;

    private final Long numSuccessfulShots;

    private final ActionMetadata actionMetadata;

    private final ExperimentalCapabilities experimentalCapabilities;

    private GetQuantumTaskResponse(BuilderImpl builder) {
        super(builder);
        this.quantumTaskArn = builder.quantumTaskArn;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.shots = builder.shots;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3Directory = builder.outputS3Directory;
        this.createdAt = builder.createdAt;
        this.endedAt = builder.endedAt;
        this.tags = builder.tags;
        this.jobArn = builder.jobArn;
        this.queueInfo = builder.queueInfo;
        this.associations = builder.associations;
        this.numSuccessfulShots = builder.numSuccessfulShots;
        this.actionMetadata = builder.actionMetadata;
        this.experimentalCapabilities = builder.experimentalCapabilities;
    }

    /**
     * <p>
     * The ARN of the quantum task.
     * </p>
     * 
     * @return The ARN of the quantum task.
     */
    public final String quantumTaskArn() {
        return quantumTaskArn;
    }

    /**
     * <p>
     * The status of the quantum task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuantumTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the quantum task.
     * @see QuantumTaskStatus
     */
    public final QuantumTaskStatus status() {
        return QuantumTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the quantum task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuantumTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the quantum task.
     * @see QuantumTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason that a quantum task failed.
     * </p>
     * 
     * @return The reason that a quantum task failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The ARN of the device the quantum task was run on.
     * </p>
     * 
     * @return The ARN of the device the quantum task was run on.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The parameters for the device on which the quantum task ran.
     * </p>
     * 
     * @return The parameters for the device on which the quantum task ran.
     */
    public final String deviceParameters() {
        return deviceParameters;
    }

    /**
     * <p>
     * The number of shots used in the quantum task.
     * </p>
     * 
     * @return The number of shots used in the quantum task.
     */
    public final Long shots() {
        return shots;
    }

    /**
     * <p>
     * The S3 bucket where quantum task results are stored.
     * </p>
     * 
     * @return The S3 bucket where quantum task results are stored.
     */
    public final String outputS3Bucket() {
        return outputS3Bucket;
    }

    /**
     * <p>
     * The folder in the S3 bucket where quantum task results are stored.
     * </p>
     * 
     * @return The folder in the S3 bucket where quantum task results are stored.
     */
    public final String outputS3Directory() {
        return outputS3Directory;
    }

    /**
     * <p>
     * The time at which the quantum task was created.
     * </p>
     * 
     * @return The time at which the quantum task was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which the quantum task ended.
     * </p>
     * 
     * @return The time at which the quantum task ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that belong to this quantum task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that belong to this quantum task.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ARN of the Amazon Braket job associated with the quantum task.
     * </p>
     * 
     * @return The ARN of the Amazon Braket job associated with the quantum task.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * Queue information for the requested quantum task. Only returned if <code>QueueInfo</code> is specified in the
     * <code>additionalAttributeNames"</code> field in the <code>GetQuantumTask</code> API request.
     * </p>
     * 
     * @return Queue information for the requested quantum task. Only returned if <code>QueueInfo</code> is specified in
     *         the <code>additionalAttributeNames"</code> field in the <code>GetQuantumTask</code> API request.
     */
    public final QuantumTaskQueueInfo queueInfo() {
        return queueInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Braket resources associated with the quantum task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return The list of Amazon Braket resources associated with the quantum task.
     */
    public final List<Association> associations() {
        return associations;
    }

    /**
     * <p>
     * The number of successful shots for the quantum task. This is available after a successfully completed quantum
     * task.
     * </p>
     * 
     * @return The number of successful shots for the quantum task. This is available after a successfully completed
     *         quantum task.
     */
    public final Long numSuccessfulShots() {
        return numSuccessfulShots;
    }

    /**
     * <p>
     * Metadata about the action performed by the quantum task, including information about the type of action and
     * program counts.
     * </p>
     * 
     * @return Metadata about the action performed by the quantum task, including information about the type of action
     *         and program counts.
     */
    public final ActionMetadata actionMetadata() {
        return actionMetadata;
    }

    /**
     * <p>
     * Enabled experimental capabilities for the quantum task, if any.
     * </p>
     * 
     * @return Enabled experimental capabilities for the quantum task, if any.
     */
    public final ExperimentalCapabilities experimentalCapabilities() {
        return experimentalCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(shots());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Directory());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numSuccessfulShots());
        hashCode = 31 * hashCode + Objects.hashCode(actionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(experimentalCapabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuantumTaskResponse)) {
            return false;
        }
        GetQuantumTaskResponse other = (GetQuantumTaskResponse) obj;
        return Objects.equals(quantumTaskArn(), other.quantumTaskArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(deviceParameters(), other.deviceParameters()) && Objects.equals(shots(), other.shots())
                && Objects.equals(outputS3Bucket(), other.outputS3Bucket())
                && Objects.equals(outputS3Directory(), other.outputS3Directory())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(endedAt(), other.endedAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(queueInfo(), other.queueInfo())
                && hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(numSuccessfulShots(), other.numSuccessfulShots())
                && Objects.equals(actionMetadata(), other.actionMetadata())
                && Objects.equals(experimentalCapabilities(), other.experimentalCapabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQuantumTaskResponse").add("QuantumTaskArn", quantumTaskArn()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("DeviceArn", deviceArn()).add("DeviceParameters", deviceParameters())
                .add("Shots", shots()).add("OutputS3Bucket", outputS3Bucket()).add("OutputS3Directory", outputS3Directory())
                .add("CreatedAt", createdAt()).add("EndedAt", endedAt()).add("Tags", hasTags() ? tags() : null)
                .add("JobArn", jobArn()).add("QueueInfo", queueInfo())
                .add("Associations", hasAssociations() ? associations() : null).add("NumSuccessfulShots", numSuccessfulShots())
                .add("ActionMetadata", actionMetadata()).add("ExperimentalCapabilities", experimentalCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "quantumTaskArn":
            return Optional.ofNullable(clazz.cast(quantumTaskArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "deviceParameters":
            return Optional.ofNullable(clazz.cast(deviceParameters()));
        case "shots":
            return Optional.ofNullable(clazz.cast(shots()));
        case "outputS3Bucket":
            return Optional.ofNullable(clazz.cast(outputS3Bucket()));
        case "outputS3Directory":
            return Optional.ofNullable(clazz.cast(outputS3Directory()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "queueInfo":
            return Optional.ofNullable(clazz.cast(queueInfo()));
        case "associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "numSuccessfulShots":
            return Optional.ofNullable(clazz.cast(numSuccessfulShots()));
        case "actionMetadata":
            return Optional.ofNullable(clazz.cast(actionMetadata()));
        case "experimentalCapabilities":
            return Optional.ofNullable(clazz.cast(experimentalCapabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("quantumTaskArn", QUANTUM_TASK_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("deviceParameters", DEVICE_PARAMETERS_FIELD);
        map.put("shots", SHOTS_FIELD);
        map.put("outputS3Bucket", OUTPUT_S3_BUCKET_FIELD);
        map.put("outputS3Directory", OUTPUT_S3_DIRECTORY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("queueInfo", QUEUE_INFO_FIELD);
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("numSuccessfulShots", NUM_SUCCESSFUL_SHOTS_FIELD);
        map.put("actionMetadata", ACTION_METADATA_FIELD);
        map.put("experimentalCapabilities", EXPERIMENTAL_CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQuantumTaskResponse, T> g) {
        return obj -> g.apply((GetQuantumTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQuantumTaskResponse> {
        /**
         * <p>
         * The ARN of the quantum task.
         * </p>
         * 
         * @param quantumTaskArn
         *        The ARN of the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTaskArn(String quantumTaskArn);

        /**
         * <p>
         * The status of the quantum task.
         * </p>
         * 
         * @param status
         *        The status of the quantum task.
         * @see QuantumTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuantumTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the quantum task.
         * </p>
         * 
         * @param status
         *        The status of the quantum task.
         * @see QuantumTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuantumTaskStatus
         */
        Builder status(QuantumTaskStatus status);

        /**
         * <p>
         * The reason that a quantum task failed.
         * </p>
         * 
         * @param failureReason
         *        The reason that a quantum task failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The ARN of the device the quantum task was run on.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device the quantum task was run on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The parameters for the device on which the quantum task ran.
         * </p>
         * 
         * @param deviceParameters
         *        The parameters for the device on which the quantum task ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceParameters(String deviceParameters);

        /**
         * <p>
         * The number of shots used in the quantum task.
         * </p>
         * 
         * @param shots
         *        The number of shots used in the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shots(Long shots);

        /**
         * <p>
         * The S3 bucket where quantum task results are stored.
         * </p>
         * 
         * @param outputS3Bucket
         *        The S3 bucket where quantum task results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Bucket(String outputS3Bucket);

        /**
         * <p>
         * The folder in the S3 bucket where quantum task results are stored.
         * </p>
         * 
         * @param outputS3Directory
         *        The folder in the S3 bucket where quantum task results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Directory(String outputS3Directory);

        /**
         * <p>
         * The time at which the quantum task was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the quantum task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which the quantum task ended.
         * </p>
         * 
         * @param endedAt
         *        The time at which the quantum task ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The tags that belong to this quantum task.
         * </p>
         * 
         * @param tags
         *        The tags that belong to this quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ARN of the Amazon Braket job associated with the quantum task.
         * </p>
         * 
         * @param jobArn
         *        The ARN of the Amazon Braket job associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * Queue information for the requested quantum task. Only returned if <code>QueueInfo</code> is specified in the
         * <code>additionalAttributeNames"</code> field in the <code>GetQuantumTask</code> API request.
         * </p>
         * 
         * @param queueInfo
         *        Queue information for the requested quantum task. Only returned if <code>QueueInfo</code> is specified
         *        in the <code>additionalAttributeNames"</code> field in the <code>GetQuantumTask</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueInfo(QuantumTaskQueueInfo queueInfo);

        /**
         * <p>
         * Queue information for the requested quantum task. Only returned if <code>QueueInfo</code> is specified in the
         * <code>additionalAttributeNames"</code> field in the <code>GetQuantumTask</code> API request.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuantumTaskQueueInfo.Builder} avoiding
         * the need to create one manually via {@link QuantumTaskQueueInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuantumTaskQueueInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #queueInfo(QuantumTaskQueueInfo)}.
         * 
         * @param queueInfo
         *        a consumer that will call methods on {@link QuantumTaskQueueInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueInfo(QuantumTaskQueueInfo)
         */
        default Builder queueInfo(Consumer<QuantumTaskQueueInfo.Builder> queueInfo) {
            return queueInfo(QuantumTaskQueueInfo.builder().applyMutation(queueInfo).build());
        }

        /**
         * <p>
         * The list of Amazon Braket resources associated with the quantum task.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<Association> associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the quantum task.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Association... associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the quantum task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.Association#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder#build()} is called immediately and
         * its result is passed to {@link #associations(List<Association>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.Association.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<Association>)
         */
        Builder associations(Consumer<Association.Builder>... associations);

        /**
         * <p>
         * The number of successful shots for the quantum task. This is available after a successfully completed quantum
         * task.
         * </p>
         * 
         * @param numSuccessfulShots
         *        The number of successful shots for the quantum task. This is available after a successfully completed
         *        quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numSuccessfulShots(Long numSuccessfulShots);

        /**
         * <p>
         * Metadata about the action performed by the quantum task, including information about the type of action and
         * program counts.
         * </p>
         * 
         * @param actionMetadata
         *        Metadata about the action performed by the quantum task, including information about the type of
         *        action and program counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionMetadata(ActionMetadata actionMetadata);

        /**
         * <p>
         * Metadata about the action performed by the quantum task, including information about the type of action and
         * program counts.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionMetadata.Builder} avoiding the need
         * to create one manually via {@link ActionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #actionMetadata(ActionMetadata)}.
         * 
         * @param actionMetadata
         *        a consumer that will call methods on {@link ActionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionMetadata(ActionMetadata)
         */
        default Builder actionMetadata(Consumer<ActionMetadata.Builder> actionMetadata) {
            return actionMetadata(ActionMetadata.builder().applyMutation(actionMetadata).build());
        }

        /**
         * <p>
         * Enabled experimental capabilities for the quantum task, if any.
         * </p>
         * 
         * @param experimentalCapabilities
         *        Enabled experimental capabilities for the quantum task, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentalCapabilities(ExperimentalCapabilities experimentalCapabilities);

        /**
         * <p>
         * Enabled experimental capabilities for the quantum task, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentalCapabilities.Builder}
         * avoiding the need to create one manually via {@link ExperimentalCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentalCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #experimentalCapabilities(ExperimentalCapabilities)}.
         * 
         * @param experimentalCapabilities
         *        a consumer that will call methods on {@link ExperimentalCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentalCapabilities(ExperimentalCapabilities)
         */
        default Builder experimentalCapabilities(Consumer<ExperimentalCapabilities.Builder> experimentalCapabilities) {
            return experimentalCapabilities(ExperimentalCapabilities.builder().applyMutation(experimentalCapabilities).build());
        }
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private String quantumTaskArn;

        private String status;

        private String failureReason;

        private String deviceArn;

        private String deviceParameters;

        private Long shots;

        private String outputS3Bucket;

        private String outputS3Directory;

        private Instant createdAt;

        private Instant endedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String jobArn;

        private QuantumTaskQueueInfo queueInfo;

        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();

        private Long numSuccessfulShots;

        private ActionMetadata actionMetadata;

        private ExperimentalCapabilities experimentalCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuantumTaskResponse model) {
            super(model);
            quantumTaskArn(model.quantumTaskArn);
            status(model.status);
            failureReason(model.failureReason);
            deviceArn(model.deviceArn);
            deviceParameters(model.deviceParameters);
            shots(model.shots);
            outputS3Bucket(model.outputS3Bucket);
            outputS3Directory(model.outputS3Directory);
            createdAt(model.createdAt);
            endedAt(model.endedAt);
            tags(model.tags);
            jobArn(model.jobArn);
            queueInfo(model.queueInfo);
            associations(model.associations);
            numSuccessfulShots(model.numSuccessfulShots);
            actionMetadata(model.actionMetadata);
            experimentalCapabilities(model.experimentalCapabilities);
        }

        public final String getQuantumTaskArn() {
            return quantumTaskArn;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuantumTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceParameters() {
            return deviceParameters;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final Long getShots() {
            return shots;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final String getOutputS3Bucket() {
            return outputS3Bucket;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final String getOutputS3Directory() {
            return outputS3Directory;
        }

        public final void setOutputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
        }

        @Override
        public final Builder outputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final QuantumTaskQueueInfo.Builder getQueueInfo() {
            return queueInfo != null ? queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(QuantumTaskQueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(QuantumTaskQueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = AssociationsCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = AssociationsCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = AssociationsCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder>... associations) {
            associations(Stream.of(associations).map(c -> Association.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getNumSuccessfulShots() {
            return numSuccessfulShots;
        }

        public final void setNumSuccessfulShots(Long numSuccessfulShots) {
            this.numSuccessfulShots = numSuccessfulShots;
        }

        @Override
        public final Builder numSuccessfulShots(Long numSuccessfulShots) {
            this.numSuccessfulShots = numSuccessfulShots;
            return this;
        }

        public final ActionMetadata.Builder getActionMetadata() {
            return actionMetadata != null ? actionMetadata.toBuilder() : null;
        }

        public final void setActionMetadata(ActionMetadata.BuilderImpl actionMetadata) {
            this.actionMetadata = actionMetadata != null ? actionMetadata.build() : null;
        }

        @Override
        public final Builder actionMetadata(ActionMetadata actionMetadata) {
            this.actionMetadata = actionMetadata;
            return this;
        }

        public final ExperimentalCapabilities.Builder getExperimentalCapabilities() {
            return experimentalCapabilities != null ? experimentalCapabilities.toBuilder() : null;
        }

        public final void setExperimentalCapabilities(ExperimentalCapabilities.BuilderImpl experimentalCapabilities) {
            this.experimentalCapabilities = experimentalCapabilities != null ? experimentalCapabilities.build() : null;
        }

        @Override
        public final Builder experimentalCapabilities(ExperimentalCapabilities experimentalCapabilities) {
            this.experimentalCapabilities = experimentalCapabilities;
            return this;
        }

        @Override
        public GetQuantumTaskResponse build() {
            return new GetQuantumTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
