/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the type and time events that occurred related to the Amazon Braket hybrid job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobEventDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobEventDetails.Builder, JobEventDetails> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(JobEventDetails::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<Instant> TIME_OF_EVENT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timeOfEvent")
            .getter(getter(JobEventDetails::timeOfEvent))
            .setter(setter(Builder::timeOfEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOfEvent").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(JobEventDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            TIME_OF_EVENT_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final Instant timeOfEvent;

    private final String message;

    private JobEventDetails(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.timeOfEvent = builder.timeOfEvent;
        this.message = builder.message;
    }

    /**
     * <p>
     * The type of event that occurred related to the Amazon Braket hybrid job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link JobEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event that occurred related to the Amazon Braket hybrid job.
     * @see JobEventType
     */
    public final JobEventType eventType() {
        return JobEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of event that occurred related to the Amazon Braket hybrid job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link JobEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event that occurred related to the Amazon Braket hybrid job.
     * @see JobEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The time of the event that occurred related to the Amazon Braket hybrid job.
     * </p>
     * 
     * @return The time of the event that occurred related to the Amazon Braket hybrid job.
     */
    public final Instant timeOfEvent() {
        return timeOfEvent;
    }

    /**
     * <p>
     * A message describing the event that occurred related to the Amazon Braket hybrid job.
     * </p>
     * 
     * @return A message describing the event that occurred related to the Amazon Braket hybrid job.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeOfEvent());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEventDetails)) {
            return false;
        }
        JobEventDetails other = (JobEventDetails) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(timeOfEvent(), other.timeOfEvent()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobEventDetails").add("EventType", eventTypeAsString()).add("TimeOfEvent", timeOfEvent())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "timeOfEvent":
            return Optional.ofNullable(clazz.cast(timeOfEvent()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("timeOfEvent", TIME_OF_EVENT_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobEventDetails, T> g) {
        return obj -> g.apply((JobEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobEventDetails> {
        /**
         * <p>
         * The type of event that occurred related to the Amazon Braket hybrid job.
         * </p>
         * 
         * @param eventType
         *        The type of event that occurred related to the Amazon Braket hybrid job.
         * @see JobEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of event that occurred related to the Amazon Braket hybrid job.
         * </p>
         * 
         * @param eventType
         *        The type of event that occurred related to the Amazon Braket hybrid job.
         * @see JobEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobEventType
         */
        Builder eventType(JobEventType eventType);

        /**
         * <p>
         * The time of the event that occurred related to the Amazon Braket hybrid job.
         * </p>
         * 
         * @param timeOfEvent
         *        The time of the event that occurred related to the Amazon Braket hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfEvent(Instant timeOfEvent);

        /**
         * <p>
         * A message describing the event that occurred related to the Amazon Braket hybrid job.
         * </p>
         * 
         * @param message
         *        A message describing the event that occurred related to the Amazon Braket hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private Instant timeOfEvent;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(JobEventDetails model) {
            eventType(model.eventType);
            timeOfEvent(model.timeOfEvent);
            message(model.message);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(JobEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getTimeOfEvent() {
            return timeOfEvent;
        }

        public final void setTimeOfEvent(Instant timeOfEvent) {
            this.timeOfEvent = timeOfEvent;
        }

        @Override
        public final Builder timeOfEvent(Instant timeOfEvent) {
            this.timeOfEvent = timeOfEvent;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public JobEventDetails build() {
            return new JobEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
