/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an Amazon Braket hybrid job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(JobSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(JobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("device")
            .getter(getter(JobSummary::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(JobSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(JobSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(JobSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(JobSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, JOB_ARN_FIELD,
            JOB_NAME_FIELD, DEVICE_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String jobArn;

    private final String jobName;

    private final String device;

    private final Instant createdAt;

    private final Instant startedAt;

    private final Instant endedAt;

    private final Map<String, String> tags;

    private JobSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.device = builder.device;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The status of the Amazon Braket hybrid job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobPrimaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Braket hybrid job.
     * @see JobPrimaryStatus
     */
    public final JobPrimaryStatus status() {
        return JobPrimaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Braket hybrid job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobPrimaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Braket hybrid job.
     * @see JobPrimaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ARN of the Amazon Braket hybrid job.
     * </p>
     * 
     * @return The ARN of the Amazon Braket hybrid job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The name of the Amazon Braket hybrid job.
     * </p>
     * 
     * @return The name of the Amazon Braket hybrid job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The primary device used by an Amazon Braket hybrid job.
     * </p>
     * 
     * @return The primary device used by an Amazon Braket hybrid job.
     */
    public final String device() {
        return device;
    }

    /**
     * <p>
     * The time at which the Amazon Braket hybrid job was created.
     * </p>
     * 
     * @return The time at which the Amazon Braket hybrid job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which the Amazon Braket hybrid job was started.
     * </p>
     * 
     * @return The time at which the Amazon Braket hybrid job was started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time at which the Amazon Braket hybrid job ended.
     * </p>
     * 
     * @return The time at which the Amazon Braket hybrid job ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Displays the key, value pairs of tags associated with this hybrid job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Displays the key, value pairs of tags associated with this hybrid job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(device(), other.device())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobSummary").add("Status", statusAsString()).add("JobArn", jobArn()).add("JobName", jobName())
                .add("Device", device()).add("CreatedAt", createdAt()).add("StartedAt", startedAt()).add("EndedAt", endedAt())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("device", DEVICE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The status of the Amazon Braket hybrid job.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Braket hybrid job.
         * @see JobPrimaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobPrimaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Braket hybrid job.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Braket hybrid job.
         * @see JobPrimaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobPrimaryStatus
         */
        Builder status(JobPrimaryStatus status);

        /**
         * <p>
         * The ARN of the Amazon Braket hybrid job.
         * </p>
         * 
         * @param jobArn
         *        The ARN of the Amazon Braket hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The name of the Amazon Braket hybrid job.
         * </p>
         * 
         * @param jobName
         *        The name of the Amazon Braket hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The primary device used by an Amazon Braket hybrid job.
         * </p>
         * 
         * @param device
         *        The primary device used by an Amazon Braket hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The time at which the Amazon Braket hybrid job was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the Amazon Braket hybrid job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which the Amazon Braket hybrid job was started.
         * </p>
         * 
         * @param startedAt
         *        The time at which the Amazon Braket hybrid job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time at which the Amazon Braket hybrid job ended.
         * </p>
         * 
         * @param endedAt
         *        The time at which the Amazon Braket hybrid job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * Displays the key, value pairs of tags associated with this hybrid job.
         * </p>
         * 
         * @param tags
         *        Displays the key, value pairs of tags associated with this hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String jobArn;

        private String jobName;

        private String device;

        private Instant createdAt;

        private Instant startedAt;

        private Instant endedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            status(model.status);
            jobArn(model.jobArn);
            jobName(model.jobName);
            device(model.device);
            createdAt(model.createdAt);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            tags(model.tags);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobPrimaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDevice() {
            return device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
