/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about validation failures that occurred during the processing of a program set in a quantum
 * task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgramSetValidationFailure implements SdkPojo, Serializable,
        ToCopyableBuilder<ProgramSetValidationFailure.Builder, ProgramSetValidationFailure> {
    private static final SdkField<Long> PROGRAM_INDEX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("programIndex").getter(getter(ProgramSetValidationFailure::programIndex))
            .setter(setter(Builder::programIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programIndex").build()).build();

    private static final SdkField<Long> INPUTS_INDEX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("inputsIndex").getter(getter(ProgramSetValidationFailure::inputsIndex))
            .setter(setter(Builder::inputsIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputsIndex").build()).build();

    private static final SdkField<List<String>> ERRORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(ProgramSetValidationFailure::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAM_INDEX_FIELD,
            INPUTS_INDEX_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long programIndex;

    private final Long inputsIndex;

    private final List<String> errors;

    private ProgramSetValidationFailure(BuilderImpl builder) {
        this.programIndex = builder.programIndex;
        this.inputsIndex = builder.inputsIndex;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The index of the program within the program set that failed validation.
     * </p>
     * 
     * @return The index of the program within the program set that failed validation.
     */
    public final Long programIndex() {
        return programIndex;
    }

    /**
     * <p>
     * The index of the input within the program set that failed validation.
     * </p>
     * 
     * @return The index of the input within the program set that failed validation.
     */
    public final Long inputsIndex() {
        return inputsIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of error messages describing the validation failures that occurred.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of error messages describing the validation failures that occurred.
     */
    public final List<String> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(programIndex());
        hashCode = 31 * hashCode + Objects.hashCode(inputsIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramSetValidationFailure)) {
            return false;
        }
        ProgramSetValidationFailure other = (ProgramSetValidationFailure) obj;
        return Objects.equals(programIndex(), other.programIndex()) && Objects.equals(inputsIndex(), other.inputsIndex())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProgramSetValidationFailure").add("ProgramIndex", programIndex())
                .add("InputsIndex", inputsIndex()).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "programIndex":
            return Optional.ofNullable(clazz.cast(programIndex()));
        case "inputsIndex":
            return Optional.ofNullable(clazz.cast(inputsIndex()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programIndex", PROGRAM_INDEX_FIELD);
        map.put("inputsIndex", INPUTS_INDEX_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramSetValidationFailure, T> g) {
        return obj -> g.apply((ProgramSetValidationFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgramSetValidationFailure> {
        /**
         * <p>
         * The index of the program within the program set that failed validation.
         * </p>
         * 
         * @param programIndex
         *        The index of the program within the program set that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programIndex(Long programIndex);

        /**
         * <p>
         * The index of the input within the program set that failed validation.
         * </p>
         * 
         * @param inputsIndex
         *        The index of the input within the program set that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputsIndex(Long inputsIndex);

        /**
         * <p>
         * A list of error messages describing the validation failures that occurred.
         * </p>
         * 
         * @param errors
         *        A list of error messages describing the validation failures that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<String> errors);

        /**
         * <p>
         * A list of error messages describing the validation failures that occurred.
         * </p>
         * 
         * @param errors
         *        A list of error messages describing the validation failures that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(String... errors);
    }

    static final class BuilderImpl implements Builder {
        private Long programIndex;

        private Long inputsIndex;

        private List<String> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramSetValidationFailure model) {
            programIndex(model.programIndex);
            inputsIndex(model.inputsIndex);
            errors(model.errors);
        }

        public final Long getProgramIndex() {
            return programIndex;
        }

        public final void setProgramIndex(Long programIndex) {
            this.programIndex = programIndex;
        }

        @Override
        public final Builder programIndex(Long programIndex) {
            this.programIndex = programIndex;
            return this;
        }

        public final Long getInputsIndex() {
            return inputsIndex;
        }

        public final void setInputsIndex(Long inputsIndex) {
            this.inputsIndex = inputsIndex;
        }

        @Override
        public final Builder inputsIndex(Long inputsIndex) {
            this.inputsIndex = inputsIndex;
            return this;
        }

        public final Collection<String> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = ProgramValidationFailuresListCopier.copy(errors);
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = ProgramValidationFailuresListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        public ProgramSetValidationFailure build() {
            return new ProgramSetValidationFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
