/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about algorithm scripts used for the Amazon Braket hybrid job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScriptModeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ScriptModeConfig.Builder, ScriptModeConfig> {
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryPoint").getter(getter(ScriptModeConfig::entryPoint)).setter(setter(Builder::entryPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(ScriptModeConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("compressionType").getter(getter(ScriptModeConfig::compressionTypeAsString))
            .setter(setter(Builder::compressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD,
            S3_URI_FIELD, COMPRESSION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entryPoint;

    private final String s3Uri;

    private final String compressionType;

    private ScriptModeConfig(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.s3Uri = builder.s3Uri;
        this.compressionType = builder.compressionType;
    }

    /**
     * <p>
     * The entry point in the algorithm scripts from where the execution begins in the hybrid job.
     * </p>
     * 
     * @return The entry point in the algorithm scripts from where the execution begins in the hybrid job.
     */
    public final String entryPoint() {
        return entryPoint;
    }

    /**
     * <p>
     * The URI that specifies the S3 path to the algorithm scripts used by an Amazon Braket hybrid job.
     * </p>
     * 
     * @return The URI that specifies the S3 path to the algorithm scripts used by an Amazon Braket hybrid job.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The type of compression used to store the algorithm scripts in Amazon S3 storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return The type of compression used to store the algorithm scripts in Amazon S3 storage.
     * @see CompressionType
     */
    public final CompressionType compressionType() {
        return CompressionType.fromValue(compressionType);
    }

    /**
     * <p>
     * The type of compression used to store the algorithm scripts in Amazon S3 storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return The type of compression used to store the algorithm scripts in Amazon S3 storage.
     * @see CompressionType
     */
    public final String compressionTypeAsString() {
        return compressionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(compressionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptModeConfig)) {
            return false;
        }
        ScriptModeConfig other = (ScriptModeConfig) obj;
        return Objects.equals(entryPoint(), other.entryPoint()) && Objects.equals(s3Uri(), other.s3Uri())
                && Objects.equals(compressionTypeAsString(), other.compressionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScriptModeConfig").add("EntryPoint", entryPoint()).add("S3Uri", s3Uri())
                .add("CompressionType", compressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "compressionType":
            return Optional.ofNullable(clazz.cast(compressionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        map.put("compressionType", COMPRESSION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScriptModeConfig, T> g) {
        return obj -> g.apply((ScriptModeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScriptModeConfig> {
        /**
         * <p>
         * The entry point in the algorithm scripts from where the execution begins in the hybrid job.
         * </p>
         * 
         * @param entryPoint
         *        The entry point in the algorithm scripts from where the execution begins in the hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(String entryPoint);

        /**
         * <p>
         * The URI that specifies the S3 path to the algorithm scripts used by an Amazon Braket hybrid job.
         * </p>
         * 
         * @param s3Uri
         *        The URI that specifies the S3 path to the algorithm scripts used by an Amazon Braket hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The type of compression used to store the algorithm scripts in Amazon S3 storage.
         * </p>
         * 
         * @param compressionType
         *        The type of compression used to store the algorithm scripts in Amazon S3 storage.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(String compressionType);

        /**
         * <p>
         * The type of compression used to store the algorithm scripts in Amazon S3 storage.
         * </p>
         * 
         * @param compressionType
         *        The type of compression used to store the algorithm scripts in Amazon S3 storage.
         * @see CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionType
         */
        Builder compressionType(CompressionType compressionType);
    }

    static final class BuilderImpl implements Builder {
        private String entryPoint;

        private String s3Uri;

        private String compressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptModeConfig model) {
            entryPoint(model.entryPoint);
            s3Uri(model.s3Uri);
            compressionType(model.compressionType);
        }

        public final String getEntryPoint() {
            return entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getCompressionType() {
            return compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        @Override
        public ScriptModeConfig build() {
            return new ScriptModeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
