/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input request failed to satisfy constraints expected by Amazon Braket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends BraketException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ValidationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<List<ProgramSetValidationFailure>> PROGRAM_SET_VALIDATION_FAILURES_FIELD = SdkField
            .<List<ProgramSetValidationFailure>> builder(MarshallingType.LIST)
            .memberName("programSetValidationFailures")
            .getter(getter(ValidationException::programSetValidationFailures))
            .setter(setter(Builder::programSetValidationFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programSetValidationFailures")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProgramSetValidationFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProgramSetValidationFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            PROGRAM_SET_VALIDATION_FAILURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final List<ProgramSetValidationFailure> programSetValidationFailures;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.programSetValidationFailures = builder.programSetValidationFailures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The reason for validation failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for validation failure.
     * @see ValidationExceptionReason
     */
    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for validation failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for validation failure.
     * @see ValidationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProgramSetValidationFailures property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public boolean hasProgramSetValidationFailures() {
        return programSetValidationFailures != null && !(programSetValidationFailures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation failures in the program set submitted in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProgramSetValidationFailures} method.
     * </p>
     * 
     * @return The validation failures in the program set submitted in the request.
     */
    public List<ProgramSetValidationFailure> programSetValidationFailures() {
        return programSetValidationFailures;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reason", REASON_FIELD);
        map.put("programSetValidationFailures", PROGRAM_SET_VALIDATION_FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, BraketException.Builder {
        /**
         * <p>
         * The reason for validation failure.
         * </p>
         * 
         * @param reason
         *        The reason for validation failure.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for validation failure.
         * </p>
         * 
         * @param reason
         *        The reason for validation failure.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(ValidationExceptionReason reason);

        /**
         * <p>
         * The validation failures in the program set submitted in the request.
         * </p>
         * 
         * @param programSetValidationFailures
         *        The validation failures in the program set submitted in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programSetValidationFailures(Collection<ProgramSetValidationFailure> programSetValidationFailures);

        /**
         * <p>
         * The validation failures in the program set submitted in the request.
         * </p>
         * 
         * @param programSetValidationFailures
         *        The validation failures in the program set submitted in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programSetValidationFailures(ProgramSetValidationFailure... programSetValidationFailures);

        /**
         * <p>
         * The validation failures in the program set submitted in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.ProgramSetValidationFailure.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.braket.model.ProgramSetValidationFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.ProgramSetValidationFailure.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #programSetValidationFailures(List<ProgramSetValidationFailure>)}.
         * 
         * @param programSetValidationFailures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.ProgramSetValidationFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programSetValidationFailures(java.util.Collection<ProgramSetValidationFailure>)
         */
        Builder programSetValidationFailures(Consumer<ProgramSetValidationFailure.Builder>... programSetValidationFailures);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends BraketException.BuilderImpl implements Builder {
        private String reason;

        private List<ProgramSetValidationFailure> programSetValidationFailures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            reason(model.reason);
            programSetValidationFailures(model.programSetValidationFailures);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final List<ProgramSetValidationFailure.Builder> getProgramSetValidationFailures() {
            List<ProgramSetValidationFailure.Builder> result = ProgramSetValidationFailuresListCopier
                    .copyToBuilder(this.programSetValidationFailures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProgramSetValidationFailures(
                Collection<ProgramSetValidationFailure.BuilderImpl> programSetValidationFailures) {
            this.programSetValidationFailures = ProgramSetValidationFailuresListCopier
                    .copyFromBuilder(programSetValidationFailures);
        }

        @Override
        public final Builder programSetValidationFailures(Collection<ProgramSetValidationFailure> programSetValidationFailures) {
            this.programSetValidationFailures = ProgramSetValidationFailuresListCopier.copy(programSetValidationFailures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programSetValidationFailures(ProgramSetValidationFailure... programSetValidationFailures) {
            programSetValidationFailures(Arrays.asList(programSetValidationFailures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programSetValidationFailures(
                Consumer<ProgramSetValidationFailure.Builder>... programSetValidationFailures) {
            programSetValidationFailures(Stream.of(programSetValidationFailures)
                    .map(c -> ProgramSetValidationFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
