/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.ExperimentalCapabilitiesEnablementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentalCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentalCapabilities> {
    private static final SdkField<String> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enabled").getter(ExperimentalCapabilities.getter(ExperimentalCapabilities::enabledAsString)).setter(ExperimentalCapabilities.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentalCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String enabled;
    private final Type type;

    private ExperimentalCapabilities(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.type = builder.type;
    }

    public final ExperimentalCapabilitiesEnablementType enabled() {
        return ExperimentalCapabilitiesEnablementType.fromValue(this.enabled);
    }

    public final String enabledAsString() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentalCapabilities)) {
            return false;
        }
        ExperimentalCapabilities other = (ExperimentalCapabilities)obj;
        return Objects.equals(this.enabledAsString(), other.enabledAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentalCapabilities").add("Enabled", (Object)this.enabledAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabledAsString()));
            }
        }
        return Optional.empty();
    }

    public static ExperimentalCapabilities fromEnabled(String enabled) {
        return (ExperimentalCapabilities)ExperimentalCapabilities.builder().enabled(enabled).build();
    }

    public static ExperimentalCapabilities fromEnabled(ExperimentalCapabilitiesEnablementType enabled) {
        return (ExperimentalCapabilities)ExperimentalCapabilities.builder().enabled(enabled).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentalCapabilities, T> g) {
        return obj -> g.apply((ExperimentalCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ENABLED,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String enabled;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentalCapabilities model) {
            this.enabled(model.enabled);
        }

        public final String getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(String enabled) {
            String oldValue = this.enabled;
            this.enabled = enabled;
            this.handleUnionValueChange(Type.ENABLED, oldValue, this.enabled);
        }

        @Override
        public final Builder enabled(String enabled) {
            String oldValue = this.enabled;
            this.enabled = enabled;
            this.handleUnionValueChange(Type.ENABLED, oldValue, this.enabled);
            return this;
        }

        @Override
        public final Builder enabled(ExperimentalCapabilitiesEnablementType enabled) {
            this.enabled(enabled == null ? null : enabled.toString());
            return this;
        }

        public ExperimentalCapabilities build() {
            return new ExperimentalCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentalCapabilities> {
        public Builder enabled(String var1);

        public Builder enabled(ExperimentalCapabilitiesEnablementType var1);
    }
}

