/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of CreateBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateBudgetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateBudgetRequest.Builder, CreateBudgetRequest> {
    private final String accountId;

    private final Budget budget;

    private final List<NotificationWithSubscribers> notificationsWithSubscribers;

    private CreateBudgetRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budget = builder.budget;
        this.notificationsWithSubscribers = builder.notificationsWithSubscribers;
    }

    /**
     *
     * @return
     */
    public String accountId() {
        return accountId;
    }

    /**
     *
     * @return
     */
    public Budget budget() {
        return budget;
    }

    /**
     *
     * @return
     */
    public List<NotificationWithSubscribers> notificationsWithSubscribers() {
        return notificationsWithSubscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((budget() == null) ? 0 : budget().hashCode());
        hashCode = 31 * hashCode + ((notificationsWithSubscribers() == null) ? 0 : notificationsWithSubscribers().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budget() == null ^ this.budget() == null) {
            return false;
        }
        if (other.budget() != null && !other.budget().equals(this.budget())) {
            return false;
        }
        if (other.notificationsWithSubscribers() == null ^ this.notificationsWithSubscribers() == null) {
            return false;
        }
        if (other.notificationsWithSubscribers() != null
                && !other.notificationsWithSubscribers().equals(this.notificationsWithSubscribers())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budget() != null) {
            sb.append("Budget: ").append(budget()).append(",");
        }
        if (notificationsWithSubscribers() != null) {
            sb.append("NotificationsWithSubscribers: ").append(notificationsWithSubscribers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateBudgetRequest> {
        /**
         *
         * @param accountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         *
         * @param budget
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Budget budget);

        /**
         *
         * @param notificationsWithSubscribers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNotificationsWithSubscribers(java.util.Collection)} or
         * {@link #withNotificationsWithSubscribers(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param notificationsWithSubscribers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsWithSubscribers(NotificationWithSubscribers... notificationsWithSubscribers);
    }

    private static final class BuilderImpl implements Builder {
        private String accountId;

        private Budget budget;

        private List<NotificationWithSubscribers> notificationsWithSubscribers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBudgetRequest model) {
            setAccountId(model.accountId);
            setBudget(model.budget);
            setNotificationsWithSubscribers(model.notificationsWithSubscribers);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget getBudget() {
            return budget;
        }

        @Override
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final void setBudget(Budget budget) {
            this.budget = budget;
        }

        public final Collection<NotificationWithSubscribers> getNotificationsWithSubscribers() {
            return notificationsWithSubscribers;
        }

        @Override
        public final Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copy(notificationsWithSubscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationsWithSubscribers(NotificationWithSubscribers... notificationsWithSubscribers) {
            if (this.notificationsWithSubscribers == null) {
                this.notificationsWithSubscribers = new ArrayList<>(notificationsWithSubscribers.length);
            }
            for (NotificationWithSubscribers e : notificationsWithSubscribers) {
                this.notificationsWithSubscribers.add(e);
            }
            return this;
        }

        public final void setNotificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copy(notificationsWithSubscribers);
        }

        @SafeVarargs
        public final void setNotificationsWithSubscribers(NotificationWithSubscribers... notificationsWithSubscribers) {
            if (this.notificationsWithSubscribers == null) {
                this.notificationsWithSubscribers = new ArrayList<>(notificationsWithSubscribers.length);
            }
            for (NotificationWithSubscribers e : notificationsWithSubscribers) {
                this.notificationsWithSubscribers.add(e);
            }
        }

        @Override
        public CreateBudgetRequest build() {
            return new CreateBudgetRequest(this);
        }
    }
}
