/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of CreateNotification
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNotificationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateNotificationRequest.Builder, CreateNotificationRequest> {
    private final String accountId;

    private final String budgetName;

    private final Notification notification;

    private final List<Subscriber> subscribers;

    private CreateNotificationRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.subscribers = builder.subscribers;
    }

    /**
     *
     * @return
     */
    public String accountId() {
        return accountId;
    }

    /**
     *
     * @return
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     *
     * @return
     */
    public Notification notification() {
        return notification;
    }

    /**
     *
     * @return
     */
    public List<Subscriber> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((budgetName() == null) ? 0 : budgetName().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((subscribers() == null) ? 0 : subscribers().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationRequest)) {
            return false;
        }
        CreateNotificationRequest other = (CreateNotificationRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.subscribers() == null ^ this.subscribers() == null) {
            return false;
        }
        if (other.subscribers() != null && !other.subscribers().equals(this.subscribers())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (subscribers() != null) {
            sb.append("Subscribers: ").append(subscribers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateNotificationRequest> {
        /**
         *
         * @param accountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         *
         * @param budgetName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         *
         * @param notification
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         *
         * @param subscribers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSubscribers(java.util.Collection)} or {@link #withSubscribers(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param subscribers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);
    }

    private static final class BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification notification;

        private List<Subscriber> subscribers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationRequest model) {
            setAccountId(model.accountId);
            setBudgetName(model.budgetName);
            setNotification(model.notification);
            setSubscribers(model.subscribers);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final Collection<Subscriber> getSubscribers() {
            return subscribers;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            if (this.subscribers == null) {
                this.subscribers = new ArrayList<>(subscribers.length);
            }
            for (Subscriber e : subscribers) {
                this.subscribers.add(e);
            }
            return this;
        }

        public final void setSubscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
        }

        @SafeVarargs
        public final void setSubscribers(Subscriber... subscribers) {
            if (this.subscribers == null) {
                this.subscribers = new ArrayList<>(subscribers.length);
            }
            for (Subscriber e : subscribers) {
                this.subscribers.add(e);
            }
        }

        @Override
        public CreateNotificationRequest build() {
            return new CreateNotificationRequest(this);
        }
    }
}
