/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBudgetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeBudgetResponse.Builder, DescribeBudgetResponse> {
    private final Budget budget;

    private DescribeBudgetResponse(BuilderImpl builder) {
        this.budget = builder.budget;
    }

    /**
     *
     * @return
     */
    public Budget budget() {
        return budget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((budget() == null) ? 0 : budget().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetResponse)) {
            return false;
        }
        DescribeBudgetResponse other = (DescribeBudgetResponse) obj;
        if (other.budget() == null ^ this.budget() == null) {
            return false;
        }
        if (other.budget() != null && !other.budget().equals(this.budget())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (budget() != null) {
            sb.append("Budget: ").append(budget()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeBudgetResponse> {
        /**
         *
         * @param budget
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Budget budget);
    }

    private static final class BuilderImpl implements Builder {
        private Budget budget;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetResponse model) {
            setBudget(model.budget);
        }

        public final Budget getBudget() {
            return budget;
        }

        @Override
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final void setBudget(Budget budget) {
            this.budget = budget;
        }

        @Override
        public DescribeBudgetResponse build() {
            return new DescribeBudgetResponse(this);
        }
    }
}
