/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeBudgets
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBudgetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeBudgetsResponse.Builder, DescribeBudgetsResponse> {
    private final List<Budget> budgets;

    private final String nextToken;

    private DescribeBudgetsResponse(BuilderImpl builder) {
        this.budgets = builder.budgets;
        this.nextToken = builder.nextToken;
    }

    /**
     *
     * @return
     */
    public List<Budget> budgets() {
        return budgets;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((budgets() == null) ? 0 : budgets().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetsResponse)) {
            return false;
        }
        DescribeBudgetsResponse other = (DescribeBudgetsResponse) obj;
        if (other.budgets() == null ^ this.budgets() == null) {
            return false;
        }
        if (other.budgets() != null && !other.budgets().equals(this.budgets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (budgets() != null) {
            sb.append("Budgets: ").append(budgets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeBudgetsResponse> {
        /**
         *
         * @param budgets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Collection<Budget> budgets);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setBudgets(java.util.Collection)} or {@link #withBudgets(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param budgets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Budget... budgets);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Budget> budgets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetsResponse model) {
            setBudgets(model.budgets);
            setNextToken(model.nextToken);
        }

        public final Collection<Budget> getBudgets() {
            return budgets;
        }

        @Override
        public final Builder budgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Budget... budgets) {
            if (this.budgets == null) {
                this.budgets = new ArrayList<>(budgets.length);
            }
            for (Budget e : budgets) {
                this.budgets.add(e);
            }
            return this;
        }

        public final void setBudgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
        }

        @SafeVarargs
        public final void setBudgets(Budget... budgets) {
            if (this.budgets == null) {
                this.budgets = new ArrayList<>(budgets.length);
            }
            for (Budget e : budgets) {
                this.budgets.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetsResponse build() {
            return new DescribeBudgetsResponse(this);
        }
    }
}
