/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of DescribeSubscribersForNotification
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSubscribersForNotificationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeSubscribersForNotificationRequest.Builder, DescribeSubscribersForNotificationRequest> {
    private final String accountId;

    private final String budgetName;

    private final Notification notification;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeSubscribersForNotificationRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     *
     * @return
     */
    public String accountId() {
        return accountId;
    }

    /**
     *
     * @return
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     *
     * @return
     */
    public Notification notification() {
        return notification;
    }

    /**
     *
     * @return
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((budgetName() == null) ? 0 : budgetName().hashCode());
        hashCode = 31 * hashCode + ((notification() == null) ? 0 : notification().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscribersForNotificationRequest)) {
            return false;
        }
        DescribeSubscribersForNotificationRequest other = (DescribeSubscribersForNotificationRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (notification() != null) {
            sb.append("Notification: ").append(notification()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSubscribersForNotificationRequest> {
        /**
         *
         * @param accountId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         *
         * @param budgetName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         *
         * @param notification
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         *
         * @param maxResults
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification notification;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscribersForNotificationRequest model) {
            setAccountId(model.accountId);
            setBudgetName(model.budgetName);
            setNotification(model.notification);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getNotification() {
            return notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscribersForNotificationRequest build() {
            return new DescribeSubscribersForNotificationRequest(this);
        }
    }
}
