/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeSubscribersForNotification
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSubscribersForNotificationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSubscribersForNotificationResponse.Builder, DescribeSubscribersForNotificationResponse> {
    private final List<Subscriber> subscribers;

    private final String nextToken;

    private DescribeSubscribersForNotificationResponse(BuilderImpl builder) {
        this.subscribers = builder.subscribers;
        this.nextToken = builder.nextToken;
    }

    /**
     *
     * @return
     */
    public List<Subscriber> subscribers() {
        return subscribers;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subscribers() == null) ? 0 : subscribers().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscribersForNotificationResponse)) {
            return false;
        }
        DescribeSubscribersForNotificationResponse other = (DescribeSubscribersForNotificationResponse) obj;
        if (other.subscribers() == null ^ this.subscribers() == null) {
            return false;
        }
        if (other.subscribers() != null && !other.subscribers().equals(this.subscribers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (subscribers() != null) {
            sb.append("Subscribers: ").append(subscribers()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSubscribersForNotificationResponse> {
        /**
         *
         * @param subscribers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSubscribers(java.util.Collection)} or {@link #withSubscribers(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param subscribers
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Subscriber> subscribers;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscribersForNotificationResponse model) {
            setSubscribers(model.subscribers);
            setNextToken(model.nextToken);
        }

        public final Collection<Subscriber> getSubscribers() {
            return subscribers;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            if (this.subscribers == null) {
                this.subscribers = new ArrayList<>(subscribers.length);
            }
            for (Subscriber e : subscribers) {
                this.subscribers.add(e);
            }
            return this;
        }

        public final void setSubscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
        }

        @SafeVarargs
        public final void setSubscribers(Subscriber... subscribers) {
            if (this.subscribers == null) {
                this.subscribers = new ArrayList<>(subscribers.length);
            }
            for (Subscriber e : subscribers) {
                this.subscribers.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscribersForNotificationResponse build() {
            return new DescribeSubscribersForNotificationResponse(this);
        }
    }
}
