/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.SubscriberMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Subscriber model. Each notification may contain multiple subscribers with different addresses.
 */
@Generated("software.amazon.awssdk:codegen")
public class Subscriber implements StructuredPojo, ToCopyableBuilder<Subscriber.Builder, Subscriber> {
    private final String subscriptionType;

    private final String address;

    private Subscriber(BuilderImpl builder) {
        this.subscriptionType = builder.subscriptionType;
        this.address = builder.address;
    }

    /**
     *
     * @return
     * @see SubscriptionType
     */
    public String subscriptionType() {
        return subscriptionType;
    }

    /**
     *
     * @return
     */
    public String address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subscriptionType() == null) ? 0 : subscriptionType().hashCode());
        hashCode = 31 * hashCode + ((address() == null) ? 0 : address().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscriber)) {
            return false;
        }
        Subscriber other = (Subscriber) obj;
        if (other.subscriptionType() == null ^ this.subscriptionType() == null) {
            return false;
        }
        if (other.subscriptionType() != null && !other.subscriptionType().equals(this.subscriptionType())) {
            return false;
        }
        if (other.address() == null ^ this.address() == null) {
            return false;
        }
        if (other.address() != null && !other.address().equals(this.address())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (subscriptionType() != null) {
            sb.append("SubscriptionType: ").append(subscriptionType()).append(",");
        }
        if (address() != null) {
            sb.append("Address: ").append(address()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriberMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Subscriber> {
        /**
         *
         * @param subscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(String subscriptionType);

        /**
         *
         * @param subscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(SubscriptionType subscriptionType);

        /**
         *
         * @param address
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);
    }

    private static final class BuilderImpl implements Builder {
        private String subscriptionType;

        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscriber model) {
            setSubscriptionType(model.subscriptionType);
            setAddress(model.address);
        }

        public final String getSubscriptionType() {
            return subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final void setSubscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public Subscriber build() {
            return new Subscriber(this);
        }
    }
}
