/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.budgets.transform.TimePeriodMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimePeriod
implements StructuredPojo,
ToCopyableBuilder<Builder, TimePeriod> {
    private final Date start;
    private final Date end;

    private TimePeriod(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    public Date start() {
        return this.start;
    }

    public Date end() {
        return this.end;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod)obj;
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        return other.end() == null || other.end().equals(this.end());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimePeriodMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date start;
        private Date end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimePeriod model) {
            this.setStart(model.start);
            this.setEnd(model.end);
        }

        public final Date getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
            return this;
        }

        public final void setStart(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
        }

        public final Date getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
            return this;
        }

        public final void setEnd(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
        }

        public TimePeriod build() {
            return new TimePeriod(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimePeriod> {
        public Builder start(Date var1);

        public Builder end(Date var1);
    }
}

