/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.CostTypesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * This includes the options for getting the cost of a budget.
 */
@Generated("software.amazon.awssdk:codegen")
public class CostTypes implements StructuredPojo, ToCopyableBuilder<CostTypes.Builder, CostTypes> {
    private final Boolean includeTax;

    private final Boolean includeSubscription;

    private final Boolean useBlended;

    private CostTypes(BuilderImpl builder) {
        this.includeTax = builder.includeTax;
        this.includeSubscription = builder.includeSubscription;
        this.useBlended = builder.useBlended;
    }

    /**
     * Returns the value of the IncludeTax property for this object.
     * 
     * @return The value of the IncludeTax property for this object.
     */
    public Boolean includeTax() {
        return includeTax;
    }

    /**
     * Returns the value of the IncludeSubscription property for this object.
     * 
     * @return The value of the IncludeSubscription property for this object.
     */
    public Boolean includeSubscription() {
        return includeSubscription;
    }

    /**
     * Returns the value of the UseBlended property for this object.
     * 
     * @return The value of the UseBlended property for this object.
     */
    public Boolean useBlended() {
        return useBlended;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeTax());
        hashCode = 31 * hashCode + Objects.hashCode(includeSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(useBlended());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostTypes)) {
            return false;
        }
        CostTypes other = (CostTypes) obj;
        return Objects.equals(includeTax(), other.includeTax())
                && Objects.equals(includeSubscription(), other.includeSubscription())
                && Objects.equals(useBlended(), other.useBlended());
    }

    @Override
    public String toString() {
        return ToString.builder("CostTypes").add("IncludeTax", includeTax()).add("IncludeSubscription", includeSubscription())
                .add("UseBlended", useBlended()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeTax":
            return Optional.of(clazz.cast(includeTax()));
        case "IncludeSubscription":
            return Optional.of(clazz.cast(includeSubscription()));
        case "UseBlended":
            return Optional.of(clazz.cast(useBlended()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostTypesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CostTypes> {
        /**
         * Sets the value of the IncludeTax property for this object.
         *
         * @param includeTax
         *        The new value for the IncludeTax property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTax(Boolean includeTax);

        /**
         * Sets the value of the IncludeSubscription property for this object.
         *
         * @param includeSubscription
         *        The new value for the IncludeSubscription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSubscription(Boolean includeSubscription);

        /**
         * Sets the value of the UseBlended property for this object.
         *
         * @param useBlended
         *        The new value for the UseBlended property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBlended(Boolean useBlended);
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeTax;

        private Boolean includeSubscription;

        private Boolean useBlended;

        private BuilderImpl() {
        }

        private BuilderImpl(CostTypes model) {
            includeTax(model.includeTax);
            includeSubscription(model.includeSubscription);
            useBlended(model.useBlended);
        }

        public final Boolean getIncludeTax() {
            return includeTax;
        }

        @Override
        public final Builder includeTax(Boolean includeTax) {
            this.includeTax = includeTax;
            return this;
        }

        public final void setIncludeTax(Boolean includeTax) {
            this.includeTax = includeTax;
        }

        public final Boolean getIncludeSubscription() {
            return includeSubscription;
        }

        @Override
        public final Builder includeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
            return this;
        }

        public final void setIncludeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
        }

        public final Boolean getUseBlended() {
            return useBlended;
        }

        @Override
        public final Builder useBlended(Boolean useBlended) {
            this.useBlended = useBlended;
            return this;
        }

        public final void setUseBlended(Boolean useBlended) {
            this.useBlended = useBlended;
        }

        @Override
        public CostTypes build() {
            return new CostTypes(this);
        }
    }
}
