/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response of DescribeBudget
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBudgetResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeBudgetResponse.Builder, DescribeBudgetResponse> {
    private final Budget budget;

    private DescribeBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.budget = builder.budget;
    }

    /**
     * Returns the value of the Budget property for this object.
     * 
     * @return The value of the Budget property for this object.
     */
    public Budget budget() {
        return budget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(budget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetResponse)) {
            return false;
        }
        DescribeBudgetResponse other = (DescribeBudgetResponse) obj;
        return Objects.equals(budget(), other.budget());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeBudgetResponse").add("Budget", budget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Budget":
            return Optional.of(clazz.cast(budget()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BudgetsResponse.Builder, CopyableBuilder<Builder, DescribeBudgetResponse> {
        /**
         * Sets the value of the Budget property for this object.
         *
         * @param budget
         *        The new value for the Budget property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Budget budget);

        /**
         * Sets the value of the Budget property for this object.
         *
         * This is a convenience that creates an instance of the {@link Budget.Builder} avoiding the need to create one
         * manually via {@link Budget#builder()}.
         *
         * When the {@link Consumer} completes, {@link Budget.Builder#build()} is called immediately and its result is
         * passed to {@link #budget(Budget)}.
         * 
         * @param budget
         *        a consumer that will call methods on {@link Budget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budget(Budget)
         */
        default Builder budget(Consumer<Budget.Builder> budget) {
            return budget(Budget.builder().apply(budget).build());
        }
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private Budget budget;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetResponse model) {
            super(model);
            budget(model.budget);
        }

        public final Budget.Builder getBudget() {
            return budget != null ? budget.toBuilder() : null;
        }

        @Override
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final void setBudget(Budget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        @Override
        public DescribeBudgetResponse build() {
            return new DescribeBudgetResponse(this);
        }
    }
}
